/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   Redistribution in source and binary forms, with or without modification, are not permitted.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package taskModellingTool;

import java.util.*;
import java.io.*;
import java.awt.*;


public class Clipboard {
    private static TreeMap clipCoupleTreeMap = new TreeMap();    // id2 (key), linkableComponent couple (value)
    
    private static TreeMap clipLinkTreeMap = new TreeMap();      // id2 (key), link (value)
    
    public static int offsetX = -1;           // offset (x,y) coordinates of all the cut/copy components
    public static int offsetY = -1;
    
    
    public static void init() {
        clipCoupleTreeMap.clear();
        clipLinkTreeMap.clear();
    }
    
    public static boolean isEmpty() {
        if (size() == 0) return true;
        else return false;
    }

    public static int size() {
        int numCouples = clipCoupleTreeMap.size();

        return numCouples;
    }
    
    public static LinkableComponent [] getLinkableComponents() {
        LinkableComponent [] result = null;
        
        result = new LinkableComponent[size()];
        
        //fill array of LinkableComponent
        Set keys = clipCoupleTreeMap.keySet();

        int index = 0;
        for (Iterator it = keys.iterator();it.hasNext();) {
            Integer id2 = (Integer) it.next();
            LinkableComponent lc = getLinkableComponent(id2);
            
            //TMUtility.display("Clipboard.getLinkableComponents()",lc.getName());

            result[index++] = lc;
        }
        
        return result;
    }
   
    
    private static int getNumLinks() {
        Set keys = clipLinkTreeMap.keySet();

        return (keys.size());
    }
    
    public static Link [] getLinks() {
        Link [] result = null;
        
        result = new Link[getNumLinks()];
        
        //fill array of Link
        Set keys = clipLinkTreeMap.keySet();

        int index = 0;
        for (Iterator it = keys.iterator();it.hasNext();) {
            Integer id2 = (Integer) it.next();
            Link link = (Link) clipLinkTreeMap.get(id2);
            
            //TMUtility.display("Clipboard.getLinks()",link.getName());
            //TMUtility.display("    id2",id2);

            result[index++] = link;
        }
        
        return result;
    }
   
    public static Link getLink(Integer id2) {
        Link result = null;
        
        if (clipLinkTreeMap.containsKey(id2))
            result = (Link) clipLinkTreeMap.get(id2);
        
        return result;
    }
    
    public static LinkableComponent getLinkableComponent(Integer id2) {
        LinkableComponent result = null;
        
        if (clipCoupleTreeMap.containsKey(id2)) {
            Couple couple = (Couple) clipCoupleTreeMap.get(id2);

            GenericComponent gc = couple.object;
            
            if (gc instanceof LinkableComponent)
                result = (LinkableComponent) gc;
        }
        
        return result;
    }
    
    private static LinkableComponent findLinkableComponent(LinkableComponent lc) {
        Integer id2 = new Integer(lc.ID);
        
        return (getLinkableComponent(id2));
    }
    
    public static void addLink(Link link) {
        if (link == null) return;
        
        LinkableComponent newlc1 = findLinkableComponent(link.lc1);
        if (newlc1 == null) return;

        LinkableComponent newlc2 = findLinkableComponent(link.lc2);
        if (newlc2 == null) return;
        
        Link linkCopy = new Link(link,0,newlc1,newlc2,link.parentName);
        linkCopy.ID = link.ID;
        linkCopy.setName(link.getName());
        
        Integer id2 = new Integer(linkCopy.ID);

        clipLinkTreeMap.put(id2,linkCopy);
    }
    
    public static void addLinkableComponent(LinkableComponent lc, Node node) {
        if (lc == null) return;
        
        Node clipNode = new Node();
        clipNode.duplicateNode(node);

        //TMUtility.display("add in Clipboard","clipNode");
        //clipNode.printNode();
        
        Couple couple = new Couple(lc, clipNode);
        
        Integer id2 = new Integer(lc.ID);

        clipCoupleTreeMap.put(id2,couple);
    }
    
    public static Integer getFirstID() {
        Integer result = null;

        if (!isEmpty()) {
            result = (Integer) clipCoupleTreeMap.firstKey();
        }
        
        return result;
    }
    
    public static String getName(Integer id2) {
        String result = null;
        
        LinkableComponent lc = getLinkableComponent(id2);
        
        if (lc == null) return result;
        
        result = lc.getName();
        
        return result;
    }
    
    public static Node getNode(Integer id2) {
        Node result = null;

        if (clipCoupleTreeMap.containsKey(id2)) {
            Couple couple = (Couple) clipCoupleTreeMap.get(id2);
            result = couple.node;
        }
        
        return result;
    }
    
    public static void setToolBar(GenericComponent gc) {
        String type;
        
        if (gc instanceof Task)
            type = "Task";
        else
            type = ((BooleanConnector)gc).type;
            
        Manager.graphicToolBar.setClipboard(type);
    }
    
    public static void findOffsetXY() {
        offsetX = -1;
        offsetY = -1;
        
        Set keys = clipCoupleTreeMap.keySet();
        
        for (Iterator it = keys.iterator();it.hasNext();) {
            Integer id2 = (Integer) it.next();
            Couple couple = (Couple) clipCoupleTreeMap.get(id2);
            
            GenericComponent gc = couple.object;
            
            int x = gc.getX();
            int y = gc.getY();
            
            if (offsetX < 0) offsetX = x;
            if (offsetY < 0) offsetY = y;
            
            if (x < offsetX) offsetX = x;
            if (y < offsetY) offsetY = y;
        }

        //TMUtility.display("findOffsetXY : offsetX",offsetX);
        //TMUtility.display("findOffsetXY : offsetY",offsetY);
    }
    
    // display clipCoupleTreeMap content
    private static void displayClipCoupleContent() {
        Set keys = clipCoupleTreeMap.keySet();
        
        int num = keys.size();
        if (num == 0) return;
        
        TMUtility.display("displayContent","clipCoupleTreeMap");

        for (Iterator it = keys.iterator();it.hasNext();) {
            Integer id2 = (Integer) it.next();
            Couple couple = (Couple) clipCoupleTreeMap.get(id2);
            
            GenericComponent gc = couple.object;
            Node node = couple.node;

            TMUtility.displayGenericComponent("gc",gc);
            
            TMUtility.displayTab();
            node.printNode();
            
            TMUtility.displayTab(2);
            node.print2ndNode();
        }
    }

    // display clipLinkTreeMap content
    private static void displayClipLinkContent() {
        Set keys = clipLinkTreeMap.keySet();
        
        int num = keys.size();
        if (num == 0) return;
        
        TMUtility.display("displayContent","clipLinkTreeMap");

        for (Iterator it = keys.iterator();it.hasNext();) {
            Integer id2 = (Integer) it.next();
            Link link = (Link) clipLinkTreeMap.get(id2);
            
            TMUtility.display("name",link.getName());
            TMUtility.display("    id2",id2);
            TMUtility.display("    lc1",link.lc1.getName());
            TMUtility.display("    lc2",link.lc2.getName());
        }
    }
    
    public static void displayContent() {
        displayClipCoupleContent();
        displayClipLinkContent();
    }
    
}