/**
 *  Tamot --- Task Modelling Editor
 *  Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
 *  (CSIRO), Australia. All rights reserved. 
 *
 *  The Software, owned by CSIRO Australia, has been developed by the CSIRO 
 *  Intelligent Interactive Technology group. 
 *  For more information, please see http://www.cmis.csiro.au/iit/.
 *
 *  The Software is a beta-test version for internal research and evaluation purposes 
 *  by the Licensee. The Software is still at a development stage. 
 *  It has not undergone complete testing and may have inherent errors,
 *  bugs or deficiencies that can affect the operation of the Software. 
 *
 *  We encourage your feedback and suggestions. Any bugs / suggestions found please email to
 *  Shijian.Lu@cmis.csiro.au. 
 *
 *  After you have signed the Beta-Test Software License Agreement with the CSIRO,
 *  CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
 *  personal, non-commercial and lawful end use. Implied licenses are negated. 
 *
 *  Warranty Disclaimer : 
 *
 *  CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
 *  the Software by the Licensee will not infringe any third partys 
 *  Intellectual Property Rights nor that the Software will be of merchantable quality,
 *  or suitable for a particular purpose. CSIRO excludes all terms, conditions and
 *  warranties implied by custom, the general law or statute in relation to the
 *  Software.
*/

package rosetm;
import rose.*;

/**
 * class UseCaseTM is a wrapper class for RoseUseCase generated by 
 * using J-Integra. (See  <A HREF="http://www.linar.com/">http://www.linar.com/</A><P>)
 * The aim of this class is to provide customised functionality for create 
 * use cases, 20-11-2001
*/

public class ScenarioDiagramTM extends RoseScenarioDiagram{
	public ScenarioDiagramTM() throws java.io.IOException, java.net.UnknownHostException {
    	super();
  	}
	
  /**
   * containObjectView. 
   *
   * @param     sceDia (in); the name of a scenario diagram.
   * @param     insView (in); the rose-object-instance-view.
   * @return    return value.  "true" if insView presents in sceDia
   * 			false, otherwise.
   * @exception java.io.IOException If there are communications problems.
   * @exception com.linar.jintegra.AutomationException If the remote server throws an exception.
   */
public static boolean containObjectView (IRoseScenarioDiagram sceDia, 
										 IRoseInstanceView insView)  {
	try{									 	
		IRoseInstanceView insViewTemp =null;								 	
		IRoseInstanceViewCollection insViewCol =sceDia.getInstanceViews(); 	
	    for (short i = 1; i<= insViewCol.getCount(); i++){
        	insViewTemp=(IRoseInstanceView)insViewCol.getAt(i);
        	if (insViewTemp.equals(insView))
				return true;
        }
	  	return false;
	} catch (Exception e)
	{
		System.err.println(e);
	  	return false;
	}
		
}
	
  /**
   * containObjectInstance. 
   *
   * @param     sceDia (in); the name of a scenario diagram.
   * @param     ins (in); the rose-object-instance.
   * @return    return value.  "true" if ins presents in sceDia
   * 			false, otherwise.
   * @exception java.io.IOException If there are communications problems.
   * @exception com.linar.jintegra.AutomationException If the remote server throws an exception.
   */
public static boolean containObjectInstance (IRoseScenarioDiagram sceDia, 
										 IRoseObjectInstance ins)  {
	try{									 	
		IRoseObjectInstance insTemp =null;								 	
		IRoseObjectInstanceCollection insCol =sceDia.getObjects(); 	
	    for (short i = 1; i<= insCol.getCount(); i++){
        	insTemp=(IRoseObjectInstance)insCol.getAt(i);
        	if (insTemp.equals(ins))
				return true;
        }
	  	return false;
	} catch (Exception e)
	{
		System.err.println(e);
	  	return false;
	}
		
}
	
	
  /**
   * getScenDia. 
   *
   * @param     roseCat (in); the name of a rose category.
   * @param     clasName (in); rose calss name.
   * @return    return value.  the rose class whose name is clasName.
   * 			null, if there is no such class
   * @exception java.io.IOException If there are communications problems.
   * @exception com.linar.jintegra.AutomationException If the remote server throws an exception.
   */
public static IRoseObjectInstance getObjectInstance (IRoseScenarioDiagram sceDia, 
										 String name)  {
	try{									 	
		IRoseObjectInstance insTemp =null;								 	
		IRoseObjectInstanceCollection insCol =sceDia.getObjects(); 	
		
		System.err.println("OLD Object="+ name+ "-");
		System.err.println("object count="+ insCol.getCount()+ "-");

	    for (short i = 1; i<= insCol.getCount(); i++){
        	insTemp=(IRoseObjectInstance)insCol.getAt(i);
        	if (insTemp.getName().trim().equals(name))
				return insTemp;
				
	    		System.err.println(" NEW Object="+ insTemp.getName()+ "-");
        }
	  	return null;
	} catch (Exception e)
	{
		System.err.println(e);
	  	return null;
	}
		
}
	
  /**
   * containObjectView. 
   *
   * @param     sceDia (in); the name of a scenario diagram.
   * @param     insView (in); the rose-object-instance-view.
   * @return    return value.  "true" if insView presents in sceDia
   * 			false, otherwise.
   * @exception java.io.IOException If there are communications problems.
   * @exception com.linar.jintegra.AutomationException If the remote server throws an exception.
   */
public static IRoseInstanceView getObjectView (IRoseScenarioDiagram sceDia, 
										 String  name)  {
	try{									 	
		IRoseInstanceView insViewTemp =null;								 	
		IRoseInstanceViewCollection insViewCol = sceDia.getInstanceViews(); 	
	    for (short i = 1; i<= insViewCol.getCount(); i++){
        	insViewTemp=(IRoseInstanceView)insViewCol.getAt(i);
        	if (insViewTemp.getName().trim().equals(name))
				return insViewTemp;
        }
	  	return null;
	} catch (Exception e)
	{
		System.err.println(e);
	  	return null;
	}
		
}
    
public static void main(String[] args) {
/*
	try{	
		short type = 1;
		RoseUseCase uc = new RoseUseCase();	
		IRoseScenarioDiagram dia=uc.addScenarioDiagram("scedia", type);
		String mSender="sender";
		String mReceiver="receiver";
    	String m="mesage";
    	String mSenderClass = "senderClass";
    	String mReceiverClass= "receiverClass";
    	
	    	IRoseObjectInstance insTemp1, insTemp2;
	   		IRoseInstanceView insViewTemp1, insViewTemp2;
			
	   		if (ScenarioDiagramTM.getObjectInstance(dia,mSender) == null){
	   			insTemp1 = dia.addInstance(mSender, mSenderClass);
	    		System.err.println("create NEW Object=  "+ insTemp1.getName());
	   		} else
	   			insTemp1 = ScenarioDiagramTM.getObjectInstance(dia,mSender);
	   			
	   		if (ScenarioDiagramTM.getObjectInstance(dia,mReceiver) == null){
	    		insTemp2 = dia.addInstance(mReceiver, mReceiverClass);
	    		System.err.println("create NEW Object=  "+ insTemp2.getName());
	   		} else
	   			insTemp2 = ScenarioDiagramTM.getObjectInstance(dia,mReceiver);

	   		if (ScenarioDiagramTM.getObjectView(dia,mSender) == null){
	    		insViewTemp1 = dia.addInstanceView(insTemp1, true);
	    		System.err.println("create NEW view=  "+ insViewTemp1.getName());
	   		}else
	   			insViewTemp1 = ScenarioDiagramTM.getObjectView(dia,mSender);

	   		if (ScenarioDiagramTM.getObjectView(dia,mReceiver) == null){
	    		insViewTemp2 = dia.addInstanceView(insTemp2, true);
	    		System.err.println("create NEW view=  "+ insViewTemp2.getName());
	   		}else 
	   			insViewTemp2 = ScenarioDiagramTM.getObjectView(dia,mReceiver);
	   			
	    	
		
	} catch (Exception e)
	{
		System.err.println(e);
	}
	*/
}

}