/**
 *  Tamot --- Task Modelling Editor
 *  Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
 *  (CSIRO), Australia. All rights reserved. 
 *
 *  The Software, owned by CSIRO Australia, has been developed by the CSIRO 
 *  Intelligent Interactive Technology group. 
 *  For more information, please see http://www.cmis.csiro.au/iit/.
 *
 *  The Software is a beta-test version for internal research and evaluation purposes 
 *  by the Licensee. The Software is still at a development stage. 
 *  It has not undergone complete testing and may have inherent errors,
 *  bugs or deficiencies that can affect the operation of the Software. 
 *
 *  We encourage your feedback and suggestions. Any bugs / suggestions found please email to
 *  Shijian.Lu@cmis.csiro.au. 
 *
 *  After you have signed the Beta-Test Software License Agreement with the CSIRO,
 *  CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
 *  personal, non-commercial and lawful end use. Implied licenses are negated. 
 *
 *  Warranty Disclaimer : 
 *
 *  CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
 *  the Software by the Licensee will not infringe any third partys 
 *  Intellectual Property Rights nor that the Software will be of merchantable quality,
 *  or suitable for a particular purpose. CSIRO excludes all terms, conditions and
 *  warranties implied by custom, the general law or statute in relation to the
 *  Software.
*/

package rosetm;
import rose.*;

/**
 * class UseCaseTM is a wrapper class for RoseUseCase generated by 
 * using J-Integra. (See  <A HREF="http://www.linar.com/">http://www.linar.com/</A><P>)
 * The aim of this class is to provide customised functionality for create 
 * use cases, 20-11-2001
*/

public class CategoryTM extends RoseCategory{
	public CategoryTM() throws java.io.IOException, java.net.UnknownHostException {
    	super();
  	}	
	
  /**
   * containClass. 
   *
   * @param     roseCat (in); the name of a rose category.
   * @param     clasName (in); rose calss name.
   * @return    return value.  "true" if clasName is an class in 
   * 			roseCat.
   * @exception java.io.IOException If there are communications problems.
   * @exception com.linar.jintegra.AutomationException If the remote server throws an exception.
   */
public static boolean containClass (IRoseCategory roseCat, 
										 String clasName)  {
	try{									 	
		IRoseClass clasTemp =null;								 	
		IRoseClassCollection clasCol =roseCat.getAllClasses(); 	
	    for (short i = 1; i<= clasCol.getCount(); i++){
        	clasTemp=(IRoseClass)clasCol.getAt(i);
        	if (clasTemp.getName().equals(clasName))
				return true;
        }
	  	return false;
	} catch (Exception e)
	{
		System.err.println(e);
	  	return false;
	}
		
}
	
  /**
   * getClass. 
   *
   * @param     roseCat (in); the name of a rose category.
   * @param     clasName (in); rose calss name.
   * @return    return value.  the rose class whose name is clasName.
   * 			null, if there is no such class
   * @exception java.io.IOException If there are communications problems.
   * @exception com.linar.jintegra.AutomationException If the remote server throws an exception.
   */
public static IRoseClass getClass (IRoseCategory roseCat, 
										 String clasName)  {
	IRoseClass clasTemp =null;								 	
	try{									 	
		IRoseClassCollection clasCol =roseCat.getAllClasses(); 	
	    for (short i = 1; i<= clasCol.getCount(); i++){
        	clasTemp=(IRoseClass)clasCol.getAt(i);
        	if (clasTemp.getName().equals(clasName))
				return clasTemp;
        }
	  	return null;
	} catch (Exception e)
	{
		System.err.println(e);
	  	return null;
	}
		
}
	
  /**
   * getUseCase. 
   *
   * @param     roseCat (in); the name of a rose category.
   * @param     clasName (in); rose calss name.
   * @return    return value.  the rose class whose name is clasName.
   * 			null, if there is no such class
   * @exception java.io.IOException If there are communications problems.
   * @exception com.linar.jintegra.AutomationException If the remote server throws an exception.
   */
public static IRoseUseCase getUseCase (IRoseCategory roseCat, 
										 String ucName)  {
	IRoseUseCase ucTemp =null;								 	
	try{									 	
		IRoseUseCaseCollection ucCol =roseCat.getUseCases(); 	
	    for (short i = 1; i<= ucCol.getCount(); i++){
        	ucTemp=(IRoseUseCase)ucCol.getAt(i);
        	if (ucTemp.getName().equals(ucName))
				return ucTemp;
        }
	  	return null;
	} catch (Exception e)
	{
		System.err.println(e);
	  	return null;
	}
		
}
	
  /**
   * getScenDia. 
   *
   * @param     roseCat (in); the name of a rose category.
   * @param     clasName (in); rose calss name.
   * @return    return value.  the rose class whose name is clasName.
   * 			null, if there is no such class
   * @exception java.io.IOException If there are communications problems.
   * @exception com.linar.jintegra.AutomationException If the remote server throws an exception.
   */
public static IRoseScenarioDiagram getScenDia (IRoseCategory uc, 
										 String scenName)  {
	IRoseScenarioDiagram scenTemp =null;								 	
	try{									 	
		IRoseScenarioDiagramCollection scenCol =uc.getScenarioDiagrams(); 	
	    for (short i = 1; i<= scenCol.getCount(); i++){
        	scenTemp=(IRoseScenarioDiagram)scenCol.getAt(i);
        	if (scenTemp.getName().equals(scenName))
				return scenTemp;
        }
	  	return null;
	} catch (Exception e)
	{
		System.err.println(e);
	  	return null;
	}
}
		
}