/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package domainModel.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.util.*;
import java.lang.reflect.*;
import java.io.*;
import domainModel.*;
import taskModellingTool.*;


public class StyleDialog {
	private String _title = "Set Document Styles";	//default dialog box title
  	private DmManager _dMM=Manager.getXDM().getDmManager();	// default _dMM 
	private JFrame  _parent = null; //default parent
	private JOptionPane  _pane ;
	private JDialog _styleDialog;

	private boolean  _OkButtonPressed= false;
	private boolean  _CancelButtonPressed= false;

	//define labels to be used in the dialod box
	private static final String _can_modality = "Can Modality";
	private static final String _conjunction = "Conjunction";
	private static final String _purpose_first = "Purpose First";
	private static final String _how = "How";
	private static final String _step_by_step = "Step by step";
	private static final String _sentenceTitle = "Sentence Style";
	private static final String _structureTitle = "Structure Style";
	
	//tip text
	private static final String _canTip = "tick to enable \"Can Modality\"";
	private static final String _conjunctionTip = "tick to enable \"Conjunction\"";
	private static final String _purposeTip = "tick to enable \"Purpose First\"";
	private static final String _howTip = "tick to enable \"How\"";
	private static final String _stepTip = "tick to enable \"Step by step\"";

   	private JCheckBox _canC,_conjunctionC, _purposeC,_howC, _stepC;
   
	public StyleDialog(){
		super();
 
		_pane = new JOptionPane(getAllPanels(),
    		JOptionPane.PLAIN_MESSAGE,JOptionPane.OK_CANCEL_OPTION);
    		
		//create tool tips
		addToolTips();
	   	_styleDialog = _pane.createDialog(_parent, _title);
		_styleDialog.show();
		
		onButtonPress();
	}
	
	public StyleDialog(JFrame parent, String title){
		super();
		_parent =parent;
		_title =title;

		_pane = new JOptionPane(getAllPanels(),
    		JOptionPane.PLAIN_MESSAGE,JOptionPane.OK_CANCEL_OPTION);
		addToolTips();

		_styleDialog = _pane.createDialog(_parent, _title);
		_styleDialog.show();
				
		onButtonPress();			
	}

	private JComponent[] getAllPanels(){
		JComponent[]      components = new JComponent[3];
		components[0] = getSentencePanel();
		//components[1] = getDividerPanel();
		components[2] = getStructurePanel();
		return components;	
	}

	private JPanel getSentencePanel(){
		JPanel fieldsPanel= new JPanel();
      	fieldsPanel.setLayout(new GridLayout(3,2));
      	
      	//create titled border
      	TitledBorder title =BorderFactory.createTitledBorder(
      		BorderFactory.createEtchedBorder(),_sentenceTitle);
       	title.setTitleJustification(TitledBorder.RIGHT);
		fieldsPanel.setBorder(title);
      	
      	fieldsPanel.add(new JLabel(_can_modality));
    	_canC = new JCheckBox("",_dMM.isModalityCan());
      	fieldsPanel.add(_canC);
		     
      	fieldsPanel.add(new JLabel(_conjunction));
    	_conjunctionC = new JCheckBox("",_dMM.isConjunction());
      	fieldsPanel.add(_conjunctionC);
     
		     
      	fieldsPanel.add(new JLabel(_purpose_first));
    	_purposeC = new JCheckBox("",_dMM.isPurposeFirst());
      	fieldsPanel.add(_purposeC);
     
     	return fieldsPanel;	
		
	}
	
	private JPanel getStructurePanel(){
		JPanel structPanel= new JPanel();
		//Dimension structPanelD= new Dimension(400,100);
      	//structPanel.setPreferredSize(structPanelD);
      
      	structPanel.setLayout(new GridLayout(2,2));
      	//create titled border
      	TitledBorder title =BorderFactory.createTitledBorder(
      		BorderFactory.createEtchedBorder(),_structureTitle);
      	title.setTitleJustification(TitledBorder.RIGHT);
      	structPanel.setBorder(title);

      	structPanel.add(new JLabel(_how));
    	_howC = new JCheckBox("",_dMM.isStyleHow());
      	structPanel.add(_howC);
		     
      	structPanel.add(new JLabel(_step_by_step));
    	_stepC = new JCheckBox("",_dMM.isStepByStep());
      	structPanel.add(_stepC);
     
     	return structPanel;	
      
	}
	
/*	
	private JTabbedPane getDividerPanel(){
		JTabbedPane cardPane= new JTabbedPane();
		
     	return cardPane;	
      
	}
*/	
	private void onButtonPress(){
		
		Object selectedValue = _pane.getValue();
		if (selectedValue != null && selectedValue != JOptionPane.UNINITIALIZED_VALUE){
			Integer sv = (Integer)selectedValue;
			
			if( sv.intValue()  == JOptionPane.OK_OPTION) {
				//update _eCon	
				onOKBotton();
			}else onCancelB();
		}

	}
	
	private void onOKBotton(){
		_OkButtonPressed= true;
		_CancelButtonPressed= false;
		
		_dMM.setModalityCan(_canC.isSelected());
		_dMM.setConjunction(_conjunctionC.isSelected());
		_dMM.setPurposeFirst(_purposeC.isSelected());
		_dMM.setStyleHow(_howC.isSelected());
		_dMM.setStepByStep(_stepC.isSelected());
		
		return;

	}
	
	private void onCancelB(){
		_OkButtonPressed= false;
		_CancelButtonPressed= true;
		System.out.println( "\n Cancel button pressed");

	}
	
	public boolean isOKButton(){
		return _OkButtonPressed;
	}
	
	public boolean isCancelButton(){
		return _CancelButtonPressed;
	}
	
	private void addToolTips(){
		_canC.setToolTipText(_canTip);
		_conjunctionC.setToolTipText(_conjunctionTip);
		_purposeC.setToolTipText(_purposeTip);
		_howC.setToolTipText(_howTip);
		_stepC.setToolTipText(_stepTip);
	}
	
	
}