/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package domainModel.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import java.lang.reflect.*;
import java.io.*;
import domainModel.*;
import taskModellingTool.*;


public class EConceptEdit {
	private DmConcept _eCon;
	private String _title = "Edit Entity Concept";	//default dialog box title
	private JFrame  _parent = null; //default parent
	private JOptionPane  _pane ;
	private JDialog eConDialog;
	private	JPanel _englishCard;

	private boolean  _OkButtonPressed= false;
	private boolean  _CancelButtonPressed= false;

	//define labels to be used in the dialod box
	private static final String _name = "Name";
	private static final String _type = "Type";
	private static final String _dirty = "Dirty";
	private static final String _spelling = "Spelling";
	private static final String _mass = "Mass Noun";
	private static final String _plural = "Plural";
	private static final String _note = "Comment";
	
	// put all entity related concept types in _conTypes
	private static final String [] _conTypes = 
			ConceptType.getDefinedTypes();
   	private static final JComboBox _typteCm = new JComboBox(_conTypes);
 
   	//define editable components
	private JTextField _nameT,_EngSpellingT,_pluralT;

   	private JCheckBox _dirtyC,_massC;
   	private JTextArea _noteA;
   
	public EConceptEdit(DmConcept eCon){
		super();
		_eCon = eCon;

		_pane = new JOptionPane(getAllPanels(),
    		JOptionPane.PLAIN_MESSAGE,JOptionPane.OK_CANCEL_OPTION);
    		
	   eConDialog = _pane.createDialog(_parent, _title);
		eConDialog.show();
		
		onButtonPress();
	}
	
	public EConceptEdit(JFrame parent, String title, 
						 DmConcept eCon){
		super();
		_eCon = eCon;
		_parent =parent;
		_title =title;
		
		_pane = new JOptionPane(getAllPanels(),
    		JOptionPane.PLAIN_MESSAGE,JOptionPane.OK_CANCEL_OPTION);
    		
	   eConDialog = _pane.createDialog(_parent, _title);
		eConDialog.show();
		
		onButtonPress();
				
	}

	private JComponent[] getAllPanels(){
		JComponent[]      components = new JComponent[3];
		components[0] = getFieldsPanel();
		components[1] = getNotePanel();
		components[2] = getCardPane();
		return components;	
	}

	private JPanel getFieldsPanel(){
		JPanel fieldsPanel= new JPanel();
      fieldsPanel.setLayout(new GridLayout(3,2));
		
      fieldsPanel.add(new JLabel(_name));
     	_nameT = new JTextField(_eCon.getName());
      fieldsPanel.add(_nameT);
      
      fieldsPanel.add(new JLabel(_type));
     	//_typeT = new JTextField(_eCon.getType());
   	_typteCm.setSelectedItem(_eCon.getType());
      fieldsPanel.add(_typteCm);
     
      fieldsPanel.add(new JLabel(_dirty));
    	_dirtyC = new JCheckBox("",_eCon.getDirty());
      fieldsPanel.add(_dirtyC);
     
     	return fieldsPanel;	
		
	}
	
	private JPanel getNotePanel(){
		JPanel notePanel= new JPanel();
		Dimension notePanelD= new Dimension(400,100);
      notePanel.setPreferredSize(notePanelD);
      
      notePanel.setLayout(new BorderLayout());
							//new GridLayout(2,1));
		
      notePanel.add(new JLabel(_note),BorderLayout.NORTH);
     	_noteA = new JTextArea(_eCon.getNote());
     	_noteA.setRows(4);	//4 rows of text
      notePanel.add(_noteA, BorderLayout.CENTER);
     	return notePanel;	
      
	}
	
	
	private JTabbedPane getCardPane(){
		JTabbedPane cardPane= new JTabbedPane();
		// Add the different tabs 
		cardPane.addTab(DmConcept._ENGLISH, null, getEnglihCard());
		cardPane.addTab(DmConcept._FRENCH, null, 	getFrechCrad());
		cardPane.addTab(DmConcept._CHINESE, null, getChineseCard());
		
     	return cardPane;	
      
	}
	
	private JPanel getEnglihCard(){
		_englishCard= new JPanel();
		_englishCard.setLayout(new GridLayout(3,2));

      _englishCard.add(new JLabel(_spelling));
    	EnglishNoun engNoun =(EnglishNoun)_eCon.getCard(DmConcept._ENGLISH);
    	_EngSpellingT = new JTextField(engNoun.getSpelling());
    	_englishCard.add(_EngSpellingT);
     
      _englishCard.add(new JLabel(_mass));
    	_massC = new JCheckBox("",engNoun.isMassNoun());
    	_massC.addActionListener(new MassNounChange());
      _englishCard.add(_massC);
     
      _englishCard.add(new JLabel(_plural));
      _pluralT = new JTextField();
    	if (engNoun instanceof IrregularNoun){
    		_pluralT.setText(((IrregularNoun)engNoun).getPlural());
    	} else {
    		_pluralT.setText("");
    	}
      _englishCard.add(_pluralT);
      
      //disable plural if it is a mass noun
      updatePluralT();
     	return _englishCard;	
      
	}
	
	private void updatePluralT(){
      if (_massC.isSelected()) {		//isMassNoun
      	_pluralT.setText("");
       	_pluralT.setEditable(false);
      } else _pluralT.setEditable(true);
      
      _pluralT.paintImmediately(_englishCard.getBounds());

  	}
	
	private JPanel getFrechCrad(){
		JPanel frenchCard= new JPanel();
		frenchCard.add(new JLabel("French language information."));
     	return frenchCard;	
      
	}
	
	private JPanel getChineseCard(){
		JPanel chineseCard= new JPanel();
		chineseCard.add(new JLabel("Chinese language information."));
     	return chineseCard;	
      
	}
	
	private void onButtonPress(){
		
		Object selectedValue = _pane.getValue();
		if (selectedValue != null && selectedValue != JOptionPane.UNINITIALIZED_VALUE){
			Integer sv = (Integer)selectedValue;
			
			if( sv.intValue()  == JOptionPane.OK_OPTION) {
				//update _eCon	
				onOKBotton();
			}else onCancelB();
		}

	}
	
	private void onOKBotton(){
		_OkButtonPressed= true;
		_CancelButtonPressed= false;
		System.out.println( "\n Ok button pressed");

		// update concept attributes
     	_eCon.setName(_nameT.getText());
     	_eCon.setType((String)_typteCm.getSelectedItem());
     	_eCon.setDirty(_dirtyC.isSelected());
     	_eCon.setNote(_noteA.getText());
     	
     	// update English alnguage features
    	EnglishNoun engNoun =(EnglishNoun)_eCon.getCard(DmConcept._ENGLISH);
    	engNoun.setSpelling(_EngSpellingT.getText());
    	
     	//if it is a mass noun, then it can not be irregular
      	if (_massC.isSelected()) {		//isMassNoun
       		if (engNoun instanceof IrregularNoun){
       			engNoun= new EnglishNoun(_EngSpellingT.getText());
       			_eCon.setCard(DmConcept._ENGLISH,engNoun);
       		} 
       		engNoun.setMassNoun(true); 
      	} else {
        	String plur= _pluralT.getText();
        	if ( plur != null && plur != ""){ 	// it is irregular
      			if (!(engNoun instanceof IrregularNoun)){
	       			engNoun= new IrregularNoun(_EngSpellingT.getText());
	       			_eCon.setCard(DmConcept._ENGLISH,engNoun);
	       			DmManager _dMM=Manager.getXDM().getDmManager();
	       			_dMM.addEnglishN(engNoun);
       			}
       			((IrregularNoun)engNoun).setPlural(_pluralT.getText());

       		}
       		engNoun.setMassNoun(false); 
       	
      	}
      
	     //2001-2-14
	     // mark related task dirty
	     DmManager.getInstance().markTaskDirtyECon(_eCon);
	}
	
	private void onCancelB(){
		_OkButtonPressed= false;
		_CancelButtonPressed= true;
		System.out.println( "\n Cancel button pressed");

	}
	
	public boolean isOKButton(){
		return _OkButtonPressed;
	}
	
	public boolean isCancelButton(){
		return _CancelButtonPressed;
	}
	
	
	public class MassNounChange implements ActionListener{
		public void actionPerformed(ActionEvent e){
			EConceptEdit.this.updatePluralT();
			System.out.println( "\n massnoun changed");
		}
	}
	
	
}