/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package domainModel.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import java.io.*;
import domainModel.*;
import taskModellingTool.*;
import utility.*;

public class DmEdit {
	private JPanel _nonActInsP;
	private JPanel _ActInsP;
	private JPanel _conceptP;
	
  	private DmManager _dMM=Manager.getXDM().getDmManager();	// default _dMM 
 	private static DmRelation _dMRelat = DmRelation.getInstance();

	private String _title = "Edit Domain Model";	//default dialog box title
	private JFrame  _parent = null; //default parent
	private JOptionPane  _pane ;
	private JDialog _dmDialog;
	
	ConceptPane _conPanel;
	EntityPane _nonAct;
	ActionPane _actInsPanel;

	private boolean  _OkButtonPressed= false;
	private boolean  _CancelButtonPressed= false;

	//define labels to be used in the dialod box
	private static final String _name = "Name";
	private static final String _concept = "Concept";
	private static final String _dirty = "Dirty";
	private static final String _prem = "Premodifier";
	private static final String _postm = "Postmodifier";
	private static final String _relat = "Relations";
	private static final String _note = "Comment";
	
	// put all entity concepts(including User and System types in _concepts
   private JComboBox _conCm, _cardCm, _enInsCm;
 
   //define editable components
	private JTextField _nameT,_premT,_postmT;

   private JCheckBox _dirtyC;
   private JTextArea _noteA;
   
	public DmEdit(DmManager dmm ){
		super();
		_dMM =dmm;

		_pane = new JOptionPane(getAllPanel(),
    		JOptionPane.PLAIN_MESSAGE,JOptionPane.OK_CANCEL_OPTION);
    		
	    _dmDialog = _pane.createDialog(_parent, _title);
		_dmDialog.show();
		
		onButtonPress();
	}
	
	public DmEdit(JFrame parent, String title){
		super();
		_parent =parent;
		_title =title;
		//	_pane = new JOptionPane(getAllPanel(),
    	//	JOptionPane.PLAIN_MESSAGE,JOptionPane.OK_OPTION);
    	
    	String [] options = {"Close"};
		_pane= new JOptionPane(getAllPanel(), JOptionPane.PLAIN_MESSAGE, 
			JOptionPane.DEFAULT_OPTION, null, options,
 			options[0]);
    	
	   	_dmDialog = _pane.createDialog(_parent, _title);
		_dmDialog.show();
		
		onButtonPress();
				
	}

	private JPanel getAllPanel(){
		JPanel allPanel= new JPanel();
      	allPanel.setLayout(new GridLayout(1,3,35,0));	//horizontal gap 10
      	allPanel.add(getActInsPanel());
       	allPanel.add(getNonActPanel());
     	allPanel.add(getConPanel());

		return allPanel;	
	}

	private JPanel getNonActPanel(){
		_nonAct = new EntityPane(this);
		/*
		nonActPanel= new JPanel();
		Dimension nonActPanelD= new Dimension(200,100);
      	nonActPanel.setPreferredSize(nonActPanelD);
		nonActPanel.add(new JLabel("Non-Action Instance Panel"));
    	*/
    	return _nonAct;
      
	}
	
	//25-6-2002
	//change to public for update action-entity relations
	private JPanel getActInsPanel(){
		_actInsPanel = new ActionPane(this);
		/*
		JPanel actInsPanel= new JPanel();
		Dimension actInsPanelD= new Dimension(200,100);
      	actInsPanel.setPreferredSize(actInsPanelD);
		actInsPanel.add(new JLabel("Action Instance Panel"));
    	*/	
    	return _actInsPanel;
      
	}
	

	private JPanel getConPanel(){
		_conPanel = new ConceptPane(this);
		/*
		JPanel conPanel= new JPanel();
		Dimension conPanelD= new Dimension(200,100);
      	conPanel.setPreferredSize(conPanelD);
      	conPanel.add(new JLabel("Concept Panel"));
      	*/
     	return _conPanel;	
      
	}
	
	private void onButtonPress(){
		_conPanel.updateChange();
	 	_nonAct.updateChange();
	 	_actInsPanel.updateChange();
	}
	
	//19-10-2001
	/*	
	public void actFilter(ActionInstance ai){
		//first populate entity instance lists
		Collection col= ai.getRelIns();

		String typeUser =ConceptType.getDefaultUserType();
		String typeSystem =ConceptType.getDefaultSystemType();
		String typeEntity =ConceptType.getDefaultEntityType();
		
		_nonAct.resetThingList(_dMM.getEiSome(typeEntity, col));
		_nonAct.resetSystemList(_dMM.getEiSome(typeSystem, col));
		_nonAct.resetUserList(_dMM.getEiSome(typeUser, col));
		
		// then populate concept lists
		DmConcept con = ai.getConceptOf();
		_conPanel.resetActList(_dMM.getCollection1(con));
		
		//clear the following lists
		_conPanel.resetUserList( _dMM.getConFromIns(
			_dMM.getEiSome(typeUser, col)));
		_conPanel.resetThingList(_dMM.getConFromIns( 
			_dMM.getEiSome(typeEntity, col)));
		_conPanel.resetSystemList(_dMM.getConFromIns( 
			_dMM.getEiSome(typeSystem, col)));
		
		return;
	}
	public void conceptFilter(DmConcept con){
		if (con.getType().equals(ConceptType.getDefaultActionType())){
			_actInsPanel.setJlistContent(_dMM.findAInsACon(con));
			_nonAct.resetThingList(new ArrayList ());
			_nonAct.resetSystemList(new ArrayList ());
			_nonAct.resetUserList(new ArrayList ());
			_nonAct.resetInterfaceList(new ArrayList ());
			
		}else{
			//first populate entity instance lists
			Collection col =_dMM.findEInsECon(con);
			String typeUser =ConceptType.getDefaultUserType();
			String typeSystem =ConceptType.getDefaultSystemType();
			String typeEntity =ConceptType.getDefaultEntityType();
			String typeInterface =ConceptType.getInterfaceType();
			
			_nonAct.resetThingList(_dMM.getEiSome(typeEntity, col));
			_nonAct.resetSystemList(_dMM.getEiSome(typeSystem, col));
			_nonAct.resetUserList(_dMM.getEiSome(typeUser, col));
			_nonAct.resetInterfaceList(_dMM.getEiSome(typeInterface, col));
			//then populate action instance list
			_actInsPanel.setJlistContent(_dMM.findAInsRel(col));
		}
		
		return;
	}
	
*/
	public void actFilter(ActionInstance ai){
		//first populate entity instance lists
		Collection col= ai.getRelIns();

		String typeUser[] =ConceptType.getDefinedUserTypes();
		String typeSystem[]=ConceptType.getDefinedSystemTypes();
		String typeThing[] =ConceptType.getDefinedObjectTypes();
		String typeInterface[] =ConceptType.getDefinedInterfaceTypes();
	
		//related entity instances
		Collection colSystem=_dMM.getEiSome(typeSystem, col);
		Collection colUser=_dMM.getEiSome(typeUser, col);
		Collection colThing=_dMM.getEiSome(typeThing, col);
		Collection colInterface=_dMM.getEiSome(typeInterface, col);
		
		//populate instence lists
		_nonAct.resetThingList(colThing);
		_nonAct.resetSystemList(colSystem);
		_nonAct.resetUserList(colUser);
		_nonAct.resetInterfaceList(colInterface);

		// then populate concept lists
		DmConcept con = ai.getConceptOf();
		_conPanel.resetActList(_dMM.getCollection1(con));
		
		//clear the following lists
		_conPanel.resetUserList( _dMM.getConFromIns(colUser));
		_conPanel.resetThingList(_dMM.getConFromIns( colThing));
		_conPanel.resetSystemList(_dMM.getConFromIns( colSystem));
		_conPanel.resetInterfaceList(_dMM.getConFromIns( colInterface));
		return;
	}

	public void conceptFilter(DmConcept con){
		//first reset every lists
		_nonAct.resetThingList(new ArrayList ());
		_nonAct.resetSystemList(new ArrayList ());
		_nonAct.resetUserList(new ArrayList ());
		_nonAct.resetInterfaceList(new ArrayList ());
		if (ConceptType.isActionType(con.getType())){
				// populate action instance list with
				//actions related to the action concepts
			_actInsPanel.setJlistContent(_dMM.findAInsACon(con));
		}
		else{
			Collection col =_dMM.findEInsECon(con);
				//populate action list with actions related to 
				//the entity concept
			_actInsPanel.setJlistContent(_dMM.findAInsRel(col));
				//populate thing instance list
			if (ConceptType.isObjectType(con.getType())){
				_nonAct.resetThingList(col);
				//populate interface instance list
			}else if (ConceptType.isInterfaceType(con.getType())){				
				_nonAct.resetInterfaceList(col);
				//populate user instance list
			}else if (ConceptType.isUserType(con.getType())){				
				_nonAct.resetUserList(col);
				//populate system instance list
			}else {				
				_nonAct.resetSystemList(col);
			}
		}
		
		return;
	}

	
	public void insTFilter(EntityInstance ei){
		_actInsPanel.setJlistContent(_dMM.findAInsRel(ei));
		
		DmConcept con = ei.getConceptOf();
		_conPanel.resetThingList(_dMM.getCollection1(con));
		
		//clear the following lists
		_conPanel.resetSystemList( new ArrayList ());
		_conPanel.resetUserList( new ArrayList ());
		_conPanel.resetActList( new ArrayList ());
		return;
	}
	
	
	public void insUFilter(EntityInstance ei){
		_actInsPanel.setJlistContent(_dMM.findAInsRel(ei));
		
		DmConcept con = ei.getConceptOf();
		_conPanel.resetUserList(_dMM.getCollection1(con));
		
		//clear the following lists
		_conPanel.resetSystemList( new ArrayList ());
		_conPanel.resetThingList( new ArrayList ());
		_conPanel.resetActList( new ArrayList ());
		return;
	}
	
	
	public void insSFilter(EntityInstance ei){
		_actInsPanel.setJlistContent(_dMM.findAInsRel(ei));
		
		DmConcept con = ei.getConceptOf();
		_conPanel.resetSystemList(_dMM.getCollection1(con));
		
		//clear the following lists
		_conPanel.resetUserList( new ArrayList ());
		_conPanel.resetThingList( new ArrayList ());
		_conPanel.resetActList( new ArrayList ());
		return;
	}
	
	public void insIFilter(EntityInstance ei){
		_actInsPanel.setJlistContent(_dMM.findAInsRel(ei));
		
		DmConcept con = ei.getConceptOf();
		_conPanel.resetInterfaceList(_dMM.getCollection1(con));
		
		//clear the following lists
		_conPanel.resetUserList( new ArrayList ());
		_conPanel.resetSystemList( new ArrayList ());
		_conPanel.resetThingList( new ArrayList ());
		_conPanel.resetActList( new ArrayList ());
		return;
	}
	//25-6-2002
	//change to public for update action-entity relations
	public ActionPane getActPane(){
    		return (ActionPane)_actInsPanel;
      
	}
	
	/**
	 * @return void
	* test the class.
	*/
	public static void main(String args[]) {
    	
		DmEdit	de= new DmEdit(MainFrame.getMainFrame(),"Edit Domain Model");	
	}
	
}