/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package domainModel.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import java.io.*;
import domainModel.*;
import taskModellingTool.*;


public class ConceptPane extends JPanel {
	
  	private DmManager _dMM=Manager.getXDM().getDmManager();	// default _dMM 
 	private static DmRelation _dMRelat = DmRelation.getInstance();
	private DmConcept _con= null;
	private DmEdit _owner; 		//owner of this Jpanel
	private boolean _modified= false; 		//for monitoring user modification
	private boolean _typeModified= false; 		//for monitoring user modification

	private static int NUMBER_OF_ROWS = 8;	//used by the Jlists
	private static int CELL_WIDTH = 237;	//used by the Jlists
	
	//define labels to be used in the dialod box for entity concepts
	private static final JLabel _name =new JLabel( "Name");
	private static final JLabel _nameAct =new JLabel( "Name");
	private static final JLabel _type = new JLabel("Type");
	private static final JLabel _typeAct = new JLabel("Type");
	//private static final JLabel _dirty = new JLabel("Dirty");
	private static final JLabel _spelling = new JLabel("Spelling");
	private static final JLabel _spellingAct = new JLabel("Spelling");
	private static final JLabel _mass = new JLabel("Mass Noun");
	private static final JLabel _plural =new JLabel( "Plural");
	private static final JLabel _pluralAct =new JLabel( "Plural");
	private static final JLabel _note = new JLabel("Comment");
	private static final JLabel _noteAct = new JLabel("Comment");
	
	private static final JLabel _french = new JLabel("French language information.");
	private static final JLabel _chinese = new JLabel("Chinese language information.");
	private static final JLabel _frenchAct = new JLabel("French language information.");
	private static final JLabel _chineseAct = new JLabel("Chinese language information.");
	
	//define labels to be used in the dialod box for action concepts
	private static final JLabel _1stPerson = new JLabel("1st Person");
	private static final JLabel _3rdPerson =new JLabel( "3rd Person");
	private static final JLabel _ing = new JLabel("Ing");
	private static final JLabel _past = new JLabel("Past");
	private static final JLabel _pp = new JLabel("Past Participle");
	private static final JLabel _prop = new JLabel("Preposition");
	private static final JLabel _regular = new JLabel("Regular");

	// put all entity related concept types in _conTypes
	private static final String [] _conTypes = 
			ConceptType.getDefinedTypes();
	/*			{ConceptType.getDefaultEntityType(),
					ConceptType.getDefaultSystemType(),
					ConceptType.getDefaultUserType()
				};
				*/
   	private static final JComboBox _typeCm = new JComboBox();
   	
   	//2001-8-15
   	private static final JComboBox _actTypeCm = new JComboBox();
   	//2001-10-18
   	private static final JComboBox _interfaceTypeCm = new JComboBox();

   	private JLabel 	_mainLabel = new JLabel("Concept");

	private JPanel _userPanel, _systemPanel, _thingPanel,_actPanel,
		_insPanel,_actFieldPanel,_rootPanel,_fieldsPanel,_notePanel,
			_fieldsAct,_noteActPanel, _interfacePanel;
		
	private	JPanel _englishCard;	// for noun card 
	private	JPanel _englishV,_frenchV, _chineseV;		//for verb card 

	private	JPanel _englishIrreg;

	private JList _userL, _systemL, _thingL, _actL, _interfaceL;
	
	// put all entity concepts(including User and System types in _concepts
	private JTabbedPane _tabPane, _nounTab, _verbTab;
	
  	private HashMap _listModel= new HashMap(); 	//   HashMap for pairs of list and DefaultListModel 
  	private HashMap _listIndxID= new HashMap(); 	//   HashMap for pairs of list and Index-ID 
	
   	//define editable components
	private JTextField _nameT = new JTextField();
	private JTextField _EngSpellingT = new JTextField();
	private JTextField _EngSpellingVT = new JTextField();
	private JTextField _pluralT = new JTextField();
	private JTextField _pluralVerbT = new JTextField();
	private JTextField _1stPersonT = new JTextField();
	private JTextField _3rdPersonT = new JTextField();
	private JTextField _ingT = new JTextField();
	private JTextField _pastT = new JTextField();
	private JTextField _ppT = new JTextField();
	private JTextField _propT = new JTextField();
	private JTextField _nameActT = new JTextField();
	private JTextField _typeActT = new JTextField();

   	private JCheckBox _massC = new JCheckBox();
   	private JCheckBox _regularC= new JCheckBox();
   	
    private JTextArea _noteA = new JTextArea();
	private JTextArea _noteActA = new JTextArea();
   
   	//define popup menu	)
   	private JPopupMenu _popMenu = new JPopupMenu();
   	//private JPopupMenu _popList = new JPopupMenu();
   	private JMenuItem _actCon = new JMenuItem("Add New Action Concept");
 	private JMenuItem _userCon = new JMenuItem("Add New User Concept");
  	private JMenuItem _systemCon = new JMenuItem("Add New System Concept");
  	private JMenuItem _thingCon = new JMenuItem("Add New Object Concept");
  	private JMenuItem _interfaceCon = new JMenuItem("Add New Interface Concept");
  
  	private JMenuItem _updateCon = new JMenuItem("Update");
  	private JMenuItem _deleteCon = new JMenuItem("Delete");
  	private JMenuItem _reset = new JMenuItem("Reset");
   	private JMenuItem _filter = new JMenuItem("Filter");
    private JMenuItem _color = new JMenuItem("Set Color");
  	private JMenuItem _colorDefault = new JMenuItem("Change to Default Color");
  
	public ConceptPane(DmEdit owner){
		super();
        //_popMenu.add(_popNew);    
		_owner = owner;

		addMenuItemListener();	
		addModifyListener();
		add(getRootPanel());
		
		//initialise action concept panel
		_actFieldPanel= getActConPanel();
		getInsPanel();
		setTextColor(DmManager.getConColor());
		
		_actTypeCm.setEnabled(true);
		//_typeActT.setEnabled(false);
		_typeCm.setEnabled(false);
	}
	
	private void addMenuItemListener(){
	   _actCon.addActionListener(new java.awt.event.ActionListener() {
	      	public void actionPerformed(ActionEvent e) {
	        	_dMM.newACon();
				updateTab();
	      	}
	    });
    
	   _thingCon.addActionListener(new java.awt.event.ActionListener() {
	      	public void actionPerformed(ActionEvent e) {
	        	_dMM.newECon();
				updateTab();
	      	}
	    });
    
	   _systemCon.addActionListener(new java.awt.event.ActionListener() {
		    public void actionPerformed(ActionEvent e) {
		        _dMM.newSCon();
				updateTab();
		    }
	    });
    
	   _userCon.addActionListener(new java.awt.event.ActionListener() {
	      	public void actionPerformed(ActionEvent e) {
	        	_dMM.newUCon();
	        	updateTab();

	      	}
	    });
    
	   _interfaceCon.addActionListener(new java.awt.event.ActionListener() {
	      	public void actionPerformed(ActionEvent e) {
	        	_dMM.newICon();
	        	updateTab();

	      	}
	    });
    
	   _updateCon.addActionListener(new java.awt.event.ActionListener() {
	      	public void actionPerformed(ActionEvent e) {
				updateChange();
	      	}
	    });
    
	   _deleteCon.addActionListener(new java.awt.event.ActionListener() {
	      	public void actionPerformed(ActionEvent e) {
				deleteIns(_con);	      
	      	}
	    });
    
	   _reset.addActionListener(new java.awt.event.ActionListener() {
	      	public void actionPerformed(ActionEvent e) {
				resetTabs();
	      	}
	    });
	    
	   _filter.addActionListener(new java.awt.event.ActionListener() {
	      	public void actionPerformed(ActionEvent e) {
				_owner.conceptFilter(_con);
	      	}
	    });

		_color.addActionListener(new java.awt.event.ActionListener() {
	      	public void actionPerformed(ActionEvent e) {
				setColor();
	      	}
	    });

		_colorDefault.addActionListener(new java.awt.event.ActionListener() {
	      	public void actionPerformed(ActionEvent e) {
				setColorDefault();
	      	}
	    });
    
	}
	
/*
 _massC = new JCheckBox();
   	private JCheckBox _regularC*/
	
    private Collection getTextFileds(){
		ArrayList sv = new ArrayList ();
		sv.add(_nameT);
		sv.add(_EngSpellingT);

		sv.add(_EngSpellingVT);
		sv.add(_pluralT);
		sv.add(_pluralVerbT);
		sv.add(_1stPersonT);
		sv.add(_3rdPersonT);
		sv.add(_ingT);
		sv.add(_pastT);
		sv.add(_ppT);
		sv.add(_propT);
		sv.add(_nameActT);
		//sv.add(_actTypeCm);	//_typeActT);
		return sv;
    }
    
    private void addModifyListener(){
    	
		Iterator it = getTextFileds().iterator();
		JTextField jtf;
		while (it.hasNext()) {
			jtf= (JTextField)it.next();
			if ( jtf.equals(_nameT)) {			
				jtf.addKeyListener(new KeyAdapter() {
		      		public void keyReleased(KeyEvent ke) {
		      			setModified(true);
						updateName(_nameT.getText());
		      		}
				});
			}else if (jtf.equals(_nameActT)){
				jtf.addKeyListener(new KeyAdapter() {
		      		public void keyReleased(KeyEvent ke) {
		      			setModified(true);
						updateName(_nameActT.getText());
		      		}
				});
			}else {
				jtf.addKeyListener(new KeyAdapter() {
		      		public void keyReleased(KeyEvent ke) {
		      			setModified(true);
		
		      		}
				});
			}
		
		}
     	_noteA.addKeyListener(new KeyAdapter() {
      		public void keyReleased(KeyEvent ke) {
      			setModified(true);

      		}
		});
    	
    	
     	_noteActA.addKeyListener(new KeyAdapter() {
      		public void keyReleased(KeyEvent ke) {
      			setModified(true);

      		}
		});
     	_massC.addActionListener(new ActionListener() {
      		public void actionPerformed(ActionEvent e) {
      			setModified(true);

      		}
		});
     	_regularC.addActionListener(new ActionListener() {
      		public void actionPerformed(ActionEvent e) {
      			setModified(true);

      		}
		});
    	_typeCm.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
      			setModified(true);
      			_typeModified=true;
			}
		});
		
		//2001-8-15
    	_actTypeCm.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
      			setModified(true);
      			//_typeModified=true;
			}
		});

   }
    
    private void setModified(boolean bo){
    	_modified = bo;
    	return;
    }
    
	private void deleteIns(DmConcept con){
		_dMM.removeConcept(con); 
		
		//update list
		updateTab();
	}
	
	private void updateTab(){
		if (_tabPane.getSelectedComponent().equals(_thingPanel)){
			setJlistContent(_thingL,  _dMM.getObjectCons());

		}else if (_tabPane.getSelectedComponent().equals(_systemPanel)){
			setJlistContent(_systemL,  
				_dMM.getConceptSome(ConceptType.getDefaultSystemType()));
		}else if (_tabPane.getSelectedComponent().equals(_userPanel)){
			setJlistContent(_userL,  
				_dMM.getConceptSome(ConceptType.getDefaultUserType()));			
		}else if (_tabPane.getSelectedComponent().equals(_interfacePanel)){
			setJlistContent(_interfaceL,  
				_dMM.getConceptSome(ConceptType.getInterfaceType()));			
		} else {
			setJlistContent(_actL,_dMM.getActionCons());   
				//_dMM.getConceptSome(ConceptType.getDefaultActionType()));			
		}
	}
	
	private void editCon(){
		if (_con != null){
			EConceptEdit id = new EConceptEdit(MainFrame.getMainFrame(),
				"Edit Entity Instance",_con);
		}
	}
	
	private void resetTabs(){
		setJlistContent(_thingL, _dMM.getObjectCons());
				//getConceptSome(ConceptType.getDefaultEntityType()));
			
			_dMM.printConcept(_dMM.getConceptSome(ConceptType.getDefaultEntityType()));
		setJlistContent(_systemL,  
			_dMM.getConceptSome(ConceptType.getDefaultSystemType()));
		setJlistContent(_userL,  
			_dMM.getConceptSome(ConceptType.getDefaultUserType()));
		setJlistContent(_actL, _dMM.getActionCons()); 
			//_dMM.getConceptSome(ConceptType.getDefaultActionType()));
		setJlistContent(_interfaceL, _dMM.getInterfaceCons()); 
		//	_dMM.getConceptSome(ConceptType.getInterfaceType()));
	}
	
	public void resetThingList(Collection col){
		setJlistContent(_thingL,col);
		return;
	}
	
	public void resetSystemList(Collection col){
		setJlistContent(_systemL,col);
		return;
	}
	
	
	public void resetUserList(Collection col){
		setJlistContent(_userL,col);
		return;
	}
	
	
	public void resetActList(Collection col){
		setJlistContent(_actL,col);
		return;
	}
	
	public void resetInterfaceList(Collection col){
		setJlistContent(_interfaceL,col);
		return;
	}
	
	private JPanel getRootPanel(){
		_rootPanel= new JPanel();
		//Dimension PanelD= new Dimension(200,100);
		
       	_rootPanel.setLayout(new BorderLayout());
		_rootPanel.add(getTopPanel(),BorderLayout.NORTH);
     	_rootPanel.add(getActConPanel(),BorderLayout.CENTER);
    //	_rootPanel.add(getActConPanel(),BorderLayout.SOUTH);
      	_rootPanel.setPreferredSize(_rootPanel.getPreferredSize());
		return _rootPanel;	
	}
	private JPanel getTopPanel(){
		JPanel topP = new JPanel();
       	topP.setLayout(new BorderLayout());
		topP.add(_mainLabel,BorderLayout.NORTH);
     	topP.add(getTabPanel(),BorderLayout.CENTER);
     	return topP;
	}
	private JTabbedPane getTabPanel(){
		_tabPane= new JTabbedPane();
		// Add the different tabs 
		_tabPane.addTab("action",	//DmConcept.getDefaultActionConcept().getName(),
			null, getActTab());
		_tabPane.addTab(DmConcept.getDefaultEntityConcept().getName(),
			null, getEntityTab());
		_tabPane.addTab(DmConcept.getDefaultSystemConcept().getName(),
			null, 	getSystemTab());
		_tabPane.addTab(DmConcept.getDefaultUserConcept().getName(),
			null, getUserTab());
		_tabPane.addTab(DmConcept.getInterfaceConcept().getName(),
			null, getInterfaceTab());
			
		//add listener
		_tabPane.addChangeListener(tabListener);
		
     	return _tabPane;	
      
	}
	
	ChangeListener tabListener = new ChangeListener(){
		public void stateChanged(ChangeEvent e) {
			JPanel jp = (JPanel)_tabPane.getSelectedComponent();
			
			// save change, if any
			updateChange();
			swapPanel();
			if (jp.equals(_userPanel)){
				selectUser();
			}else if (jp.equals(_systemPanel)){
				selectSystem();
			}else if (jp.equals(_thingPanel)){
				selectThing();
			}else if (jp.equals(_interfacePanel)){
				selectInterface();
			}else {
				selectAct();
			}
        	setModified(false); 
			return;	
		}
	};	//
	
	private JPanel getUserTab(){
		_userPanel= new JPanel();
		_userL = new JList();
		_listIndxID.put(_userL, new HashMap());

		setJlistContent(_userL,  
			_dMM.getConceptSome(ConceptType.getDefaultUserType()));
			
		//_userPanel.add(_userL);
		
		JScrollPane scrollP= new JScrollPane(_userL);
     	scrollP.setHorizontalScrollBarPolicy(
          JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);	//	_NEVER);
     	scrollP.setVerticalScrollBarPolicy(
          JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
			
		_userPanel.add(scrollP);
		_userL.setVisibleRowCount(NUMBER_OF_ROWS);
		_userL.setFixedCellWidth(CELL_WIDTH);

		_userL.addListSelectionListener(userListener);
		
		_userL.addMouseListener(popupListener);		
		_userPanel.addMouseListener(popupListener);
		return _userPanel;	
	}
	
	ListSelectionListener userListener = new ListSelectionListener(){
		public void valueChanged(ListSelectionEvent e) {
			updateChange();
			selectUser();
        	setModified(false); 
      		_typeModified=false;
			return;	
		 }
	};
	
	//2001-4-10
	private JPanel getInterfaceTab(){
		_interfacePanel= new JPanel();
		_interfaceL = new JList();
		_listIndxID.put(_interfaceL, new HashMap());

		setJlistContent(_interfaceL,  
			_dMM.getInterfaceCons());
			
		//_userPanel.add(_userL);
		
		JScrollPane scrollP= new JScrollPane(_interfaceL);
     	scrollP.setHorizontalScrollBarPolicy(
          JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);	//	_NEVER);
     	scrollP.setVerticalScrollBarPolicy(
          JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
			
		_interfacePanel.add(scrollP);
		_interfaceL.setVisibleRowCount(NUMBER_OF_ROWS);
		_interfaceL.setFixedCellWidth(CELL_WIDTH);

		_interfaceL.addListSelectionListener(interfaceListener);
		
		_interfaceL.addMouseListener(popupListener);		
		_interfacePanel.addMouseListener(popupListener);
		return _interfacePanel;	
	}
	
	//2001-4-10
	ListSelectionListener interfaceListener = new ListSelectionListener(){
		public void valueChanged(ListSelectionEvent e) {
			updateChange();
			selectInterface();
        	setModified(false); 
      		_typeModified=false;
			return;	
		 }
	};
	
	MouseListener popupListener = new MouseAdapter(){
    	public void mousePressed(MouseEvent e) {
			updateChange();

	 		//enable right-mouse-button selection
    		JList jl= getList();
			int index = jl.locationToIndex(e.getPoint());
			jl.setSelectedIndex(index);
			
			if (jl.equals(_thingL))
				selectThing();
			else if (jl.equals(_userL))
				selectUser();
			else if (jl.equals(_systemL))
				selectSystem();
			else if (jl.equals(_interfaceL))
				selectInterface();
			else 
				selectAct();
			
			maybeShowPopup(e);
		}	
    	public void mouseClicked(MouseEvent e) {
			//if click more than once, invoke filter
			if (e.getClickCount() > 1)
				_owner.conceptFilter(_con);
			return;
		}	


		public void mouseReleased(MouseEvent e) {
		  	maybeShowPopup(e);
		}
		
		public void maybeShowPopup(MouseEvent e) {
			
			if (e.isPopupTrigger()) {
		      	//System.out.println( "\n right mouse button pressed");
				constructMenu();
		        _popMenu.show(e.getComponent(),
		        e.getX(), e.getY());
		    }
		}

	};
	
	private JList getList(){
		JPanel jp = (JPanel)_tabPane.getSelectedComponent();
		if (jp.equals(_userPanel)){
			return _userL;
		}else if (jp.equals(_systemPanel)){
			return _systemL;
		}else if (jp.equals(_thingPanel)){
			return _thingL;
		}else if (jp.equals(_interfacePanel)){
			return _interfaceL;
		}else{
			return _actL;
		}
		
	}
	
	
	private void constructMenu(){
		if (_tabPane.getSelectedComponent().equals(_thingPanel)){
			_popMenu.removeAll();    
			_popMenu.add(_thingCon);
			addCommonMenuItem();
		}else if (_tabPane.getSelectedComponent().equals(_systemPanel)){
			_popMenu.removeAll();    
			_popMenu.add(_systemCon);    
			addCommonMenuItem();
		}else if (_tabPane.getSelectedComponent().equals(_userPanel)){
			_popMenu.removeAll();    
			_popMenu.add(_userCon);    
			addCommonMenuItem();
		}else if (_tabPane.getSelectedComponent().equals(_interfacePanel)){
			_popMenu.removeAll();    
			_popMenu.add(_interfaceCon);    
			addCommonMenuItem();
		}else {
			_popMenu.removeAll();    
			_popMenu.add(_actCon);    
			addCommonMenuItem();
		}
		return;	
	}
	private void addCommonMenuItem(){
		if (_con == null){
	        _popMenu.add(new JPopupMenu.Separator());    
			_popMenu.add(_color);  
			_popMenu.add(_colorDefault);  
	        _popMenu.add(new JPopupMenu.Separator());  
			_popMenu.add(_reset);  
		
		}else{
	        _popMenu.add(new JPopupMenu.Separator());
	        if (_modified)
				_popMenu.add(_updateCon);
			_popMenu.add(_deleteCon);    
			_popMenu.add(_filter);
	        _popMenu.add(new JPopupMenu.Separator());    
			_popMenu.add(_color);  
			_popMenu.add(_colorDefault);  
	        _popMenu.add(new JPopupMenu.Separator());  
			_popMenu.add(_reset);  
		}
		return;
	}
	private void selectUser(){
		//String conName = (String)_userL.getSelectedValue();
		
		//updateECon(conName,ConceptType.getDefaultUserType());
		int i = _userL.getSelectedIndex();
		HashMap indexId = (HashMap)_listIndxID.get(_userL);
		String iD = (String)indexId.get(Integer.toString(i));
		updateECon(iD,ConceptType.getDefaultUserType());
				
		refresh();
	}
	
	private void selectSystem(){
		//String conName = (String)_systemL.getSelectedValue();
		//updateECon(conName,ConceptType.getDefaultSystemType());
		
		int i = _systemL.getSelectedIndex();
		HashMap indexId = (HashMap)_listIndxID.get(_systemL);
		String iD = (String)indexId.get(Integer.toString(i));
		updateECon(iD,ConceptType.getDefaultSystemType());
				
		refresh();
	}
	
	
	private void selectThing(){
		//String conName = (String)_thingL.getSelectedValue();
		//updateECon(conName,ConceptType.getDefaultEntityType());
		
		int i = _thingL.getSelectedIndex();
		HashMap indexId = (HashMap)_listIndxID.get(_thingL);
		String iD = (String)indexId.get(Integer.toString(i));
		updateECon(iD,ConceptType.getDefaultEntityType());
		
		refresh();
	}
	
	//2001-4-10
	private void selectInterface(){
		int i = _interfaceL.getSelectedIndex();
		HashMap indexId = (HashMap)_listIndxID.get(_interfaceL);
		String iD = (String)indexId.get(Integer.toString(i));
		updateECon(iD,ConceptType.getInterfaceType());
		
		refresh();
	}
	
	public void updateECon(String conID, String type){
		if (conID == null){
			setFieldsContent(null, type);
			setEngCardContent(null);
			_con = null;
		} else {
			//DmConcept con = 
			_con = _dMM.getConcept(conID);;
			setFieldsContent(_con, _con.getType());
			setEngCardContent(_con);
		}
		//refresh();
	}

/*	public void updateECon(String conName, String type){
		if (conName == null){
			setFieldsContent(null, type);
			setEngCardContent(null);
			_con = null;
		} else {
			DmConcept con = _dMM.getEConcept(conName, type);
			_con = con;
			setFieldsContent(con, type);
			setEngCardContent(con);
		}
		//refresh();
	}
*/
	private JPanel getSystemTab(){
		_systemPanel= new JPanel();
		_systemL = new JList();
		_listIndxID.put(_systemL, new HashMap());

		setJlistContent(_systemL,  
			_dMM.getConceptSome(ConceptType.getDefaultSystemType()));
			
		JScrollPane scrollP= new JScrollPane(_systemL);
     	scrollP.setHorizontalScrollBarPolicy(
          JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);	//	_NEVER);
     	scrollP.setVerticalScrollBarPolicy(
          JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
                   
		_systemPanel.add(scrollP);
		_systemL.setVisibleRowCount(NUMBER_OF_ROWS);
		_systemL.setFixedCellWidth(CELL_WIDTH);
		_systemL.addListSelectionListener(systemListener);
		
		_systemL.addMouseListener(popupListener);		
		_systemPanel.addMouseListener(popupListener);
		return _systemPanel;	
	}

	
	ListSelectionListener systemListener = new ListSelectionListener(){
		public void valueChanged(ListSelectionEvent e) {
			updateChange();
			selectSystem();
        	setModified(false); 
      		_typeModified=false;
		}
	};
	
	private JPanel getEntityTab(){
		_thingPanel= new JPanel();
		_thingL = new JList();
		_listIndxID.put(_thingL, new HashMap());

		setJlistContent(_thingL,  
			_dMM.getObjectCons());
			//getConceptSome(ConceptType.getDefaultEntityType()));
					
		JScrollPane scrollP= new JScrollPane(_thingL);
     	scrollP.setHorizontalScrollBarPolicy(
          JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);	//	_NEVER);
     	scrollP.setVerticalScrollBarPolicy(
          JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
          
		_thingPanel.add(scrollP);
		//	_thingL.setSize(_thingL.getMaximumSize());
		_thingL.setVisibleRowCount(NUMBER_OF_ROWS);
		_thingL.setFixedCellWidth(CELL_WIDTH);

		_thingL.addListSelectionListener(thingListener);
		
		_thingL.addMouseListener(popupListener);		
		_thingPanel.addMouseListener(popupListener);

		return _thingPanel;	
	}
	
	ListSelectionListener thingListener = new ListSelectionListener(){
		public void valueChanged(ListSelectionEvent e) {
			updateChange();
			selectThing();
        	setModified(false); 
      		//_typeModified=false;
			return;	
		}
	};
	
	private JPanel getActTab(){
		_actPanel= new JPanel();
		_actL = new JList();
		_listIndxID.put(_actL, new HashMap());
		

		setJlistContent(_actL, _dMM.getActionCons()); 
			//_dMM.getConceptSome(ConceptType.getDefaultActionType()));
			
		//_userPanel.add(_userL);
		
		JScrollPane scrollP= new JScrollPane(_actL);
     	scrollP.setHorizontalScrollBarPolicy(
          JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);	//	_NEVER);
     	scrollP.setVerticalScrollBarPolicy(
          JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
			
		_actPanel.add(scrollP);
		_actL.setVisibleRowCount(NUMBER_OF_ROWS);
		_actL.setFixedCellWidth(CELL_WIDTH);

		_actL.addListSelectionListener(actListener);
		
		_actL.addMouseListener(popupListener);		
		_actPanel.addMouseListener(popupListener);
	
		return _actPanel;	
	}
	
	ListSelectionListener actListener = new ListSelectionListener(){
		public void valueChanged(ListSelectionEvent e) {
			updateChange();
			selectAct();
        	setModified(false); 
      	//	_typeModified=false;
			return;	
		}
	};
	
	private void selectAct(){
		//String conName = (String)_actL.getSelectedValue();
		//updateACon(conName);
		
		int i = _actL.getSelectedIndex();
		HashMap indexId = (HashMap)_listIndxID.get(_actL);
		String iD = (String)indexId.get(Integer.toString(i));
		updateACon(iD);

		refresh();
	}
	
	/** remove all content for list if there is any,
	* then populate list with user clear
	*/
	public void setJlistContent(JList list, Collection user ){
		list.removeAll(); 
		if (user == null) return;
		
		Iterator it = user.iterator();
		DmConcept con;
		DefaultListModel model = new DefaultListModel();
		_listModel.put(list, model);
		
		HashMap indexID = (HashMap)_listIndxID.get(list);
		indexID.clear();
		int i =0;

		while (it.hasNext()){
			con = (DmConcept)it.next();
			model.addElement(con.getName());
			indexID.put(Integer.toString(i++),con.getID() );
		}
		list.setModel(model);
		return;	
	}

	private JPanel getInsPanel(){
		if (_insPanel != null) return _insPanel;
		
		_insPanel= new JPanel();
       	_insPanel.setLayout(new BorderLayout());
     	//insPanel.setLayout(new GridLayout(3,1));
       	_insPanel.add(getFieldsPanel(),BorderLayout.NORTH);
      	_insPanel.add(getCardPane(),BorderLayout.CENTER);
     	_insPanel.add(getNotePanel(),BorderLayout.SOUTH);
		return _insPanel;	
	}

	private JPanel getFieldsAct(){
		if (_fieldsAct != null)
			return _fieldsAct;
			
		_fieldsAct= new JPanel();
      	_fieldsAct.setLayout(new GridLayout(3,2));
	
      	//add an empty line
      	_fieldsAct.add(new JLabel());
      	_fieldsAct.add(new JLabel());

      	_fieldsAct.add(_nameAct);
     //	_nameActT = new JTextField(); 	//_con.getName());
      	_fieldsAct.add(_nameActT);
      
      	_fieldsAct.add(_typeAct);
     //	_typeActT = new JTextField(); 	//_con.getName());
      	_fieldsAct.add(_actTypeCm);	//_typeActT);

      	return _fieldsAct;	
		
	}
	private JPanel getFieldsPanel(){
		if (_fieldsPanel != null)
			return _fieldsPanel;
			
		_fieldsPanel= new JPanel();
      	_fieldsPanel.setLayout(new GridLayout(3,2));
	
      	//add an empty line
      	_fieldsPanel.add(new JLabel());
      	_fieldsPanel.add(new JLabel());

      	_fieldsPanel.add(_name);
     //	_nameT = new JTextField(); 	//_con.getName());
      	_fieldsPanel.add(_nameT);
      
      	_fieldsPanel.add(_type);
      	_fieldsPanel.add(_typeCm);
     
     	return _fieldsPanel;	
		
	}
	//setActContent
	public void setActContent(DmConcept con){
		if (con == null)
			clearActContent();
		else{
			//clearFieldsContent();
   			String name = con.getName();
   			if (name == null || name.equals(""))
				_nameActT.setText(" ");
			else 
				_nameActT.setText(name);
				
			DefaultComboBoxModel mod= new DefaultComboBoxModel(
			ConceptType.getDefinedActionTypes());
			_actTypeCm.setModel(mod);
		
   			String type = con.getType();
   			if (type == null || type.equals(""))
   				_actTypeCm.setSelectedItem("");
				//	_typeActT.setText(" ");
			else 
				_actTypeCm.setSelectedItem(type);
				//_typeActT.setText(type);
				
   			String note = con.getNote();
   			if (note == null || note.equals(""))
				_noteActA.setText(" ");
			else 
				_noteActA.setText(note);
		
		}
	}
	public void setFieldsContent(DmConcept con, String type){
		if (con == null)
			clearFieldsContent();
		else{
			//clearFieldsContent();
   			String name = con.getName();
   			if (name == null || name.equals(""))
				_nameT.setText(" ");
			else 
				_nameT.setText(name);
				
	 	System.out.println("display concept: "+ con.getName());
	 	System.out.println("display concept type: "+"\""+ type+"\"");
				
			//200-8-16
			DefaultComboBoxModel mod;
			if (ConceptType.isObjectType(type)){
				mod= new DefaultComboBoxModel(
					ConceptType.getDefinedObjectTypes());
				_typeCm.setEnabled(true);

			}else if (ConceptType.isInterfaceType(type)){
				mod= new DefaultComboBoxModel(
					ConceptType.getDefinedInterfaceTypes());
				_typeCm.setEnabled(true);
				System.out.println("yes it is interface: ");


			}else{
	   			//String type = con.getType();
				mod= new DefaultComboBoxModel(_conTypes);
				_typeCm.setEnabled(false);
			}
			_typeCm.setModel(mod);
			
   			if(! (type == null || type.equals("")))
	   	  		_typeCm.setSelectedItem(type);
			else 
				_typeCm.setSelectedItem("");
				
				
   			String note = con.getNote();
   			if (note == null || note.equals(""))
				_noteA.setText(" ");
			else 
				_noteA.setText(note);
		
		}
		setModified(false);

	}
	
	
	private void clearFieldsContent(){
		_nameT.setText(" ");
		DefaultComboBoxModel mod= new DefaultComboBoxModel();
		_typeCm.setModel(mod);
		_noteA.setText(" ");
	}
	private void clearActContent(){
		_nameActT.setText(" ");
		DefaultComboBoxModel mod= new DefaultComboBoxModel();
		_actTypeCm.setModel(mod);
		// _typeActT.setText(""); 	//(mod);
		_noteActA.setText("");
	}
	//
	private JPanel getNoteAct(){
		if (_noteActPanel != null)
			return _noteActPanel;
			
		 _noteActPanel= new JPanel();
		
		Dimension _notePanelD= new Dimension(200,105);
      	_noteActPanel.setPreferredSize(_notePanelD);
      
      	_noteActPanel.setLayout(new BorderLayout());
							//new GridLayout(2,1));
		
    	_noteActPanel.add(_noteAct,BorderLayout.NORTH);
     	_noteActA.setLineWrap(true);
     	
     	
     	JScrollPane scrollP= new JScrollPane(_noteActA);
     	scrollP.setHorizontalScrollBarPolicy(
          JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
     	scrollP.setVerticalScrollBarPolicy(
          JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
          
      	_noteActPanel.add(scrollP, BorderLayout.CENTER);
     	
      	//_notePanel.add(_noteA, BorderLayout.CENTER);
      	
     	return _noteActPanel;	
      
	}
	
	private JPanel getNotePanel(){
		if (_notePanel != null)
			return _notePanel;
			
		 _notePanel= new JPanel();
		
		Dimension _notePanelD= new Dimension(200,105);
      	_notePanel.setPreferredSize(_notePanelD);
      
      	_notePanel.setLayout(new BorderLayout());
							//new GridLayout(2,1));
		
    	_notePanel.add(_note,BorderLayout.NORTH);
     	_noteA.setLineWrap(true);
     	
     	
     	JScrollPane scrollP= new JScrollPane(_noteA);
     	scrollP.setHorizontalScrollBarPolicy(
          JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
     	scrollP.setVerticalScrollBarPolicy(
          JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
          
      	_notePanel.add(scrollP, BorderLayout.CENTER);
     	
      	//_notePanel.add(_noteA, BorderLayout.CENTER);
      	
     	return _notePanel;	
      
	}
	
	
	private JTabbedPane getCardPane(){
		if (_nounTab != null) return _nounTab;
		
		_nounTab= new JTabbedPane();
		// Add the different tabs 
		_nounTab.addTab(DmConcept._ENGLISH, null, getEnglihCard());
		_nounTab.addTab(DmConcept._FRENCH, null, 	getFrechCrad());
		_nounTab.addTab(DmConcept._CHINESE, null, getChineseCard());
		
     	return _nounTab;	
      
	}
	
	private JPanel getEnglihCard(){
		_englishCard= new JPanel();
		_englishCard.setLayout(new GridLayout(3,2));

      	_englishCard.add(_spelling);
    //	_EngSpellingT = new JTextField();
    	_englishCard.add(_EngSpellingT);
     
      	_englishCard.add(_mass);
    //	_massC = new JCheckBox();
    	_massC.addActionListener(new MassNounChange());
      	_englishCard.add(_massC);
     
      	_englishCard.add(_plural);
      //	_pluralT = new JTextField();
      	_englishCard.add(_pluralT);
      
      //disable plural if it is a mass noun
      //updatePluralT();
     	return _englishCard;	
      
	}
	
	private void setEngCardContent(DmConcept con){
		if(con == null)
			clearEngCardContent();
		else{
	    	EnglishNoun engNoun =(EnglishNoun)con.getCard(DmConcept._ENGLISH);
	    	_EngSpellingT.setText(engNoun.getSpelling());
	     
	    	_massC.setSelected(engNoun.isMassNoun());
	    	if (engNoun instanceof IrregularNoun){
	    		_pluralT.setText(((IrregularNoun)engNoun).getPlural());
	    	} else {
	    		_pluralT.setText("");
	    	}
	      
	      	//disable plural if it is a mass noun
	      	updatePluralT();
		}
     	return ;	
      
	}
	
	private void clearEngCardContent(){
		_EngSpellingT.setText("");
     
    	_massC.setSelected(false);
    	_pluralT.setText("");
      
      	//disable plural if it is a mass noun
      	updatePluralT();

		return;
	}
	private void updatePluralT(){
      if (_massC.isSelected()) {		//isMassNoun
      	_pluralT.setText("");
       	_pluralT.setEditable(false);
      } else _pluralT.setEditable(true);
      
      _pluralT.paintImmediately(_englishCard.getBounds());

  	}
	
	private JPanel getFrechCrad(){
		JPanel frenchCard= new JPanel();
		frenchCard.add(_french);
     	return frenchCard;	
      
	}
	
	private JPanel getChineseCard(){
		JPanel chineseCard= new JPanel();
		chineseCard.add(_chinese);
     	return chineseCard;	
      
	}
	
	public class MassNounChange implements ActionListener{
		public void actionPerformed(ActionEvent e){
			ConceptPane.this.updatePluralT();
			System.out.println( "\n massnoun changed");
		}
	}
	
	
	
	private void storeChange(){
		// update Enttity instance attributes
	//	if (_con == null || !(_modified)) return;
		//System.out.println("conctent changed");
		
		// update concept attributes
	 	_con.setName(_nameT.getText());
	 	System.out.println("concept: "+ _nameT.getText());
	 	System.out.println("concept type: "+ (String)_typeCm.
	 			getSelectedItem());

	 	_con.setType((String)_typeCm.getSelectedItem());
	 	//	_con.setDirty(_dirtyC.isSelected());
	 	_con.setNote(_noteA.getText());
	 	
	 	// update English alnguage features
		EnglishNoun engNoun =(EnglishNoun)_con.getCard(DmConcept._ENGLISH);
		engNoun.setSpelling(_EngSpellingT.getText());
		
	 	//if it is a mass noun, then it can not be irregular
	  	if (_massC.isSelected()) {		//isMassNoun
	       	if (engNoun instanceof IrregularNoun){
	       		_dMM.removeENoun(engNoun);
	       		engNoun= new EnglishNoun(_EngSpellingT.getText());
	       		_con.setCard(DmConcept._ENGLISH,engNoun);

	       		_dMM.addEnglishN(engNoun);
	       	} 
	       	engNoun.setMassNoun(true);
	  	} else {
        	String plur= _pluralT.getText();
        	if ( plur != null && plur != ""){ 	// it is irregular
      			if (!(engNoun instanceof IrregularNoun)){
      				_dMM.removeENoun(engNoun);

	       			engNoun= new IrregularNoun(_EngSpellingT.getText());
	       			_con.setCard(DmConcept._ENGLISH,engNoun);
	       			//DmManager _dMM=Manager.getXDM().getDmManager();
	       			_dMM.addEnglishN(engNoun);
       			}
       			((IrregularNoun)engNoun).setPlural(_pluralT.getText());

       		}
       		engNoun.setMassNoun(false); 
       	
	  	}
	  
	  	//2001-2-14
	  	// mark related task dirty
	  	DmManager.getInstance().markTaskDirtyECon(_con);
	  	
	  	//2001-3-30
	  	//reset lists contents if concept-type changed
	  /*	if (_typeModified){
			setJlistContent(_thingL,_dMM.getObjectCons());  
				//_dMM.getConceptSome(ConceptType.getDefaultEntityType()));
				
				_dMM.printConcept(_dMM.getObjectCons());
			setJlistContent(_systemL,  
				_dMM.getConceptSome(ConceptType.getDefaultSystemType()));
			setJlistContent(_userL,  
				_dMM.getConceptSome(ConceptType.getDefaultUserType()));
	  	}
	  	*/
	  	_modified = false;
	  	return;

	}
	

	private JPanel getActConPanel(){
		if (_actFieldPanel != null) return _actFieldPanel;
		
		_actFieldPanel= new JPanel();
       	_actFieldPanel.setLayout(new BorderLayout());
       	_actFieldPanel.add(getFieldsAct(),BorderLayout.NORTH);
      	_actFieldPanel.add(getActCardPane(),BorderLayout.CENTER);
     	_actFieldPanel.add(getNoteAct(),BorderLayout.SOUTH);
		return _actFieldPanel;	
	}
	
	private JTabbedPane getActCardPane(){
		if(_verbTab != null) return _verbTab;
		
		_verbTab= new JTabbedPane();
		// Add the different tabs 
	   	_verbTab.addTab(DmConcept._ENGLISH, null, getEnglihVerb());
		_verbTab.addTab(DmConcept._FRENCH, null, 	getFrechVerb());
		_verbTab.addTab(DmConcept._CHINESE, null, getChineseVerb());
		
     	return _verbTab;	
      
	}
	
	private JPanel getEnglihVerb(){
		if (_englishV != null) return _englishV;
		
		_englishV= new JPanel();
      	_englishV.setLayout(new BorderLayout());
		JPanel tempP= new JPanel();
		tempP.setLayout(new GridLayout(3,2));

      	tempP.add(_spellingAct);
    //	_EngSpellingVT = new JTextField();
    	tempP.add(_EngSpellingVT);
    	
      	tempP.add(_prop  );
    //	_propT  = new JTextField();
    	tempP.add(_propT );
	     
      	tempP.add(_regular);
    //	_regularC = new JCheckBox();
    	_regularC.addActionListener(new ReguarChange());
      	tempP.add(_regularC);
      
       	_englishV.add(tempP,BorderLayout.NORTH);
       	
       	addEnglihIrregNew();
     	return _englishV;	
      
	}
	
	
	private JPanel getFrechVerb(){
		if (_frenchV != null) return _frenchV;
				
		_frenchV= new JPanel();
		_frenchV.add(_frenchAct);
     	return _frenchV;	
      
	}
	
	private JPanel getChineseVerb(){
		if (_chineseV != null) return _chineseV;
		
		_chineseV= new JPanel();
		_chineseV.add(_chineseAct);
     	return _chineseV;	
	}
	
	
	public class ReguarChange implements ActionListener{
		public void actionPerformed(ActionEvent e){
			ConceptPane.this.updateRegularT();
			System.out.println( "\n regular changed");
		}
	}
	
	private void updateRegularT(){
		if (_con == null) return;
		
      	if (_regularC.isSelected()) {		//isreguar verb
			if (_englishV.getComponent(_englishV.getComponentCount()-1).
				equals(_englishIrreg))
					_englishV.remove(_englishIrreg);
      	} 	 else {	
	      	JPanel temP = (JPanel)_englishV.
	      		getComponent(_englishV.getComponentCount()-1);
	      	if (_englishIrreg == null ) 
	      		addEnglihIrregNew();
	      		
	   		if(!(temP.equals(_englishIrreg)))
					_englishV.add(_englishIrreg, BorderLayout.CENTER);
      	}
		// _pane.paintImmediately(_pane.getBounds()); 
		refresh();	

  	}
  	
	private void swapPanel(){
		if (_rootPanel == null) {
			return;
		}
			
		Component [] panels =_rootPanel.getComponents();
		boolean actF = false;
		for (int i = 0; i<_rootPanel.getComponentCount(); i++){
			//System.out.println("nth component: "+i);
			if (_actFieldPanel.equals(panels[i])){
				actF=true;
				break;
			}
		}
		
		JPanel jp = (JPanel)_tabPane.getSelectedComponent();
		if (jp.equals(_actPanel)){
			
			//23-7-2001
			setActConVisible(true);
			
			_rootPanel.remove(_insPanel);
			_rootPanel.add(_actFieldPanel,BorderLayout.SOUTH);
			

		}else{
			if (!actF) return;
			
			//23-7-2001
			setActConVisible(false);

			_rootPanel.remove(_actFieldPanel);
			_rootPanel.add(_insPanel,BorderLayout.SOUTH);
			
			setActConVisible(true);

		}
		refresh();

		
	}
	
	private void addEnglihIrregNew(){
		//if not build _englishIrreg JPanel
		if (_englishIrreg == null){
			_englishIrreg= new JPanel();

			_englishIrreg.setLayout(new GridLayout(7,2));
	
	      	_englishIrreg.add(_1stPerson );
	    //	_1stPersonT  = new JTextField();
	    	_englishIrreg.add(_1stPersonT );
	     
	      	_englishIrreg.add(_3rdPerson );
	    //	_3rdPersonT  = new JTextField();
	    	_englishIrreg.add(_3rdPersonT );
	     
	      	_englishIrreg.add(_pluralAct);
	    //  	_pluralVerbT = new JTextField();
	      	_englishIrreg.add(_pluralVerbT);
	      
	      	_englishIrreg.add(_ing);
	    //	_ingT  = new JTextField();
	    	_englishIrreg.add(_ingT );
	     
	     
	      	_englishIrreg.add(_past);
	    //	_pastT  = new JTextField();
	    	_englishIrreg.add(_pastT );
	     
	     
	      	_englishIrreg.add(_pp );
	    //	_ppT  = new JTextField();
	    	_englishIrreg.add(_ppT );
	     
	/*     
	      	_englishIrreg.add(new JLabel(_prop  ));
	    	_propT  = new JTextField();
	    	_englishIrreg.add(_propT );
	  */   
		}  
		
		if (!(_englishV.getComponent(_englishV.getComponentCount()-1).
			equals(_englishIrreg)))
				_englishV.add(_englishIrreg, BorderLayout.CENTER);
	}
	
	public void updateChange(){
		if (_con == null) return;
		else if (ConceptType.isActionType(_con.getType()))
			//(_con.getType().equals(ConceptType.getDefaultActionType()))
			storeChangeAct();
		else storeChange();
		return;
	}
	private void storeChangeAct(){
		
		if (_con == null || !(_modified)) return;
		//System.out.println("concept conctent changed");
		
		// update concept attributes
     	_con.setName(_nameActT.getText());
     	_con.setType((String)_actTypeCm.getSelectedItem());

     //	_con.setDirty(_dirtyC.isSelected());	getSelectedItem
     	_con.setNote(_noteActA.getText());
     	
     	
     	// update English language features
    	EnglishVerb engVerb =(EnglishVerb)_con.getCard(DmConcept._ENGLISH);
    	engVerb.setSpelling(_EngSpellingVT.getText());
       	String prop= _propT.getText();
       	if (prop != null)
       		engVerb.setProp(prop);
      	else 	engVerb.setProp("");
      	
     	//if it is a regular verb, then it can not be irregular
      	if (_regularC.isSelected()) {		
       		if (engVerb instanceof IrregularVerb){
       			_dMM.removeEVerb(engVerb);

       			engVerb= new EnglishVerb(_EngSpellingVT.getText());
       			_con.setCard(DmConcept._ENGLISH,engVerb);
       			_dMM.addEnglishV(engVerb);
       		} 
      	} else {
	       	if (!(engVerb instanceof IrregularVerb)){
	       		_dMM.removeEVerb(engVerb);

		       	engVerb= new IrregularVerb(_EngSpellingVT.getText());
		       	_con.setCard(DmConcept._ENGLISH,engVerb);
		       	_dMM.addEnglishV(engVerb);

	       	}
       	
	     		// update irregular verb features
	       	IrregularVerb irreg =(IrregularVerb)engVerb;
	       	String first= _1stPersonT.getText();
	       	if (first != null)
	       		irreg.set1stP(first);
	      	else 	irreg.set1stP("");
	      		
	       	String third= _3rdPersonT.getText();
	       	if (third != null)
	       		irreg.set3rdP(third);
	      	else 	irreg.set3rdP("");
	
	      	String plur= _pluralVerbT.getText();
	       	if (plur != null)
	       		irreg.setPlural(plur);
	      	else 	irreg.setPlural("");
	      	
	      		
	       	String ing= _ingT.getText();
	       	if (ing != null)
	       		irreg.setIng(ing);
	      	else 	irreg.setIng("");
	      	
	      		
	       	String past= _pastT.getText();
	       	if (past != null)
	       		irreg.setPast(past);
	      	else 	irreg.setPast("");
	      	
	      		
	       	String pp= _ppT.getText();
	       	if (pp != null)
	       		irreg.setPp(pp);
	      	else 	irreg.setPp("");
	      	
	      		
      }
      
      //2001-2-14
      // mark related task dirty
      DmManager.getInstance().markTaskDirtyACon(_con);
      _modified= false;
		return;
	}
	
	private void updateACon(String conID){
		if (conID == null){
			setActContent(null);
			setEngCardAct(null);
			_con = null;
		} else {
			DmConcept con = _dMM.getConcept(conID);
			_con = con;
			setActContent(con);
			setEngCardAct(con);
		}
	}
	
/*	private void updateACon(String conName){
		if (conName == null){
			setActContent(null);
			setEngCardAct(null);
			_con = null;
		} else {
			DmConcept con = _dMM.getAConcept(conName);
			_con = con;
			setActContent(con);
			setEngCardAct(con);
		}
	}
	
*/	
	private void setEngCardAct(DmConcept con){
		if(con == null)
			clearEngCardAct();
		else{
			//_englishCard= new JPanel();
	    	EnglishVerb engVerb =(EnglishVerb)con.getCard(DmConcept._ENGLISH);
	    	_EngSpellingVT.setText(engVerb.getSpelling());
	    	_propT.setText(engVerb.getProp());
    	
	     	//if irregular verb add extra attributes 
	      	if (engVerb instanceof IrregularVerb){
	    		_regularC.setSelected(false);
	     		updateEnglihIrreg((IrregularVerb)engVerb);
	      	} else  {
	      		_regularC.setSelected(true);
	      		updateRegularT();
	      	}
     		
		}
     	return ;	
      
	}
	
	private void clearEngCardAct(){
		_EngSpellingVT.setText("");
    	_propT.setText("");
	    _regularC.setSelected(false);
 
	    _1stPersonT.setText("");
    	_3rdPersonT.setText("");
     
      	_pluralVerbT.setText("");
    	_ingT.setText("");
    	_pastT.setText("");
    	_ppT.setText("");
		
		return;
	}
	
	private void updateEnglihIrreg(IrregularVerb engVerb){
		if (_englishIrreg == null) addEnglihIrregNew();
	/*
		EnglishVerb engV = (EnglishVerb)_con.getCard(DmConcept._ENGLISH);
		if (!(engV instanceof IrregularVerb)){
    		IrregularVerb irrVerb =new IrregularVerb(_con.getName());
    		engV=irrVerb;
		}
		
    	IrregularVerb engVerb = (IrregularVerb)engV;
    */	if (engVerb == null)
    		System.out.println(" null irregular verb::::::::::::");
    	if (_1stPersonT == null)
    		System.out.println(" null 1st person textfield::::::::::::");
    	_1stPersonT.setText(engVerb.get1stP());
    	_3rdPersonT.setText(engVerb.get3rdP());
     
      	_pluralVerbT.setText(engVerb.getPlural());
    	_ingT.setText(engVerb.getIng());
    	_pastT.setText(engVerb.getPast());
    	_ppT.setText(engVerb.getPp());
		
		if (!(_englishV.getComponent(_englishV.getComponentCount()-1).
			equals(_englishIrreg)))
				_englishV.add(_englishIrreg, BorderLayout.CENTER);
				
      	refresh();
				
		return;
	}
	
	private void refresh(){
		_englishCard.invalidate();
      	_englishCard.paintImmediately(_englishCard.getBounds());
      	
		_englishV.invalidate();
      	_englishV.paintImmediately(_englishV.getBounds());
      	
		_englishIrreg.invalidate();
      	_englishIrreg.paintImmediately(_englishIrreg.getBounds());
      	
 		 _nounTab.invalidate();
      	_nounTab.validate();
		_nounTab.paintImmediately(_nounTab.getBounds());
		
      	_verbTab.invalidate();
      	_verbTab.validate();
		_verbTab.paintImmediately(_verbTab.getBounds());
		
		//23-7-2001
		//to refresh the verb english tab properly
		int inx = _verbTab.getSelectedIndex();
		if (inx >= 1){
			_verbTab.setSelectedIndex(0);
			_verbTab.setSelectedIndex(inx);
		} else {
			_verbTab.setSelectedIndex(2);
			_verbTab.setSelectedIndex(inx);
		
		}
     	
		_actFieldPanel.invalidate();
       	_actFieldPanel.validate();
     	_actFieldPanel.paintImmediately(_actFieldPanel.getBounds());


		_fieldsPanel.invalidate();
		_fieldsPanel.paintImmediately(_fieldsPanel.getBounds());

		_fieldsAct.invalidate();
      	_fieldsAct.paintImmediately(_fieldsAct.getBounds());
      	
      	
		_rootPanel.invalidate();
      	_rootPanel.validate();
      	_rootPanel.setPreferredSize(_rootPanel.getPreferredSize());

      	_rootPanel.paintImmediately(_rootPanel.getBounds());
      	
	   // System.out.println(" conceptpane refreshed::::::::::::");
			
		return;
	}
    
    public void setTextColor(Color co){
    	DmManager.setConColor(co);
    	
		setLabelColor( co);
		setMenuItemColor( co);
		setTextFieldColor( co);
    	
    	//tabs
    	_tabPane.setForeground(co);
    	_nounTab.setForeground(co);
    	_verbTab.setForeground(co);
    	
    	//lists
  		_actL.setForeground(co);    
		_thingL.setForeground(co);    
 		_systemL.setForeground(co);    
 		_userL.setForeground(co);    
 		_interfaceL.setForeground(co);    
   	
 		//combo-box
		_typeCm.setForeground(co); 
		
		//check-boxes
		_massC.setForeground(co); 
		_regularC.setForeground(co); 

		//textareas
		_noteA.setForeground(co);    
		_noteActA.setForeground(co);  
		
		return;
    	
    }
    
    public void setLabelColor(Color co){
    	//labels
    	_mainLabel.setForeground(co);
    	_name.setForeground(co);
    	_nameAct.setForeground(co);
    	_type.setForeground(co);
    	_typeAct.setForeground(co);
    	_spelling.setForeground(co);
    	_spellingAct.setForeground(co);
    	_mass.setForeground(co);
    	_plural.setForeground(co);
    	_pluralAct.setForeground(co);
    	_note.setForeground(co);
    	_noteAct.setForeground(co);
    	_french.setForeground(co);
    	_frenchAct.setForeground(co);
    	_chinese.setForeground(co);
    	_chineseAct.setForeground(co);
    	_1stPerson.setForeground(co);
    	_3rdPerson.setForeground(co);
    	_ing.setForeground(co);
    	_past.setForeground(co);
    	_pp.setForeground(co);
    	_prop.setForeground(co);
    	_regular.setForeground(co);
		return;
    }
    public void setMenuItemColor(Color co){
		//popup meniItems
		_actCon.setForeground(co);    
		_userCon.setForeground(co);    
		_systemCon.setForeground(co);
		_thingCon.setForeground(co); 
		_interfaceCon.setForeground(co);    
		_updateCon.setForeground(co);    

		_deleteCon.setForeground(co);    
		_reset.setForeground(co);
		_filter.setForeground(co);    
		_color.setForeground(co);    
		_colorDefault.setForeground(co);
		return;
    }

    public void setTextFieldColor(Color co){
		//textfields
		_nameT.setForeground(co);    
		_EngSpellingT.setForeground(co);    
		_EngSpellingVT.setForeground(co);
		_pluralT.setForeground(co);    
		_pluralVerbT.setForeground(co);    
		_1stPersonT.setForeground(co);
		_3rdPersonT.setForeground(co);    
		_ingT.setForeground(co);    
		_pastT.setForeground(co);
		_ppT.setForeground(co);    
		_propT.setForeground(co);    
		_nameActT.setForeground(co);
		_actTypeCm.setForeground(co);

		//_typeActT.setForeground(co);
		
		return;
    }
    public void setColor(){
		Color color = JColorChooser.showDialog(MainFrame.getMainFrame(), 
			"Choose Color for Concept", DmManager.getConColor());  
		if (color == null)
   			return;
   			
    	setTextColor(color);
   		return;
    }
    
    public void setColorDefault(){
    	setTextColor(DmManager.CONCEPT_COLOR);
   		return;
    }
    
    private void updateName(String name){
    	JList jl= getList();
		int i = jl.getSelectedIndex();
		
		((DefaultListModel)_listModel.get(jl)).set(i, name);
   	
    }
    
    private void setActConVisible(boolean b){
      	 
 		 _actFieldPanel.setVisible(b);  
  		 refresh();
    /*	
 		_verbTab.setVisible(b);  
  		_englishIrreg.setVisible(b);
  		_nameAct.setVisible(b);  	
		 _typeAct.setVisible(b);  	
		 _spellingAct.setVisible(b);  
		 _prop.setVisible(b);

		 _verbTab.setVisible(b);  
		 _nameActT.setVisible(b);  	
		 _typeActT.setVisible(b);  	
		 _nameAct.setVisible(b);  	
		 _typeAct.setVisible(b);  	
		 _spellingAct.setVisible(b);  
		 _prop.setVisible(b);
	*/	 
		 
    }
    
	
}