/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package domainModel.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import java.util.*;
import java.lang.reflect.*;
import java.io.*;
import domainModel.*;
//import taskModellingTool.*;


public class AConceptEdit {
	private DmConcept _aCon;
	private String _title = "Edit Action Concept";	//default dialog box title
	private JFrame  _parent = null; //default parent
	private JOptionPane  _pane ;
	private JDialog _aConDialog;
	private	JPanel _englishCard;
	private	JPanel _englishIrreg;


	private boolean  _OkButtonPressed= false;
	private boolean  _CancelButtonPressed= false;

	//define labels to be used in the dialod box
	private static final String _name = "Name";
//	private static final String _type = "Type";
	private static final String _dirty = "Dirty";
	private static final String _spelling = "Spelling";
	private static final String _plural = "Plural";
	private static final String _note = "Comment";
	private static final String _1stPerson = "1st Person";
	private static final String _3rdPerson = "3rd Person";
	private static final String _ing = "Ing";
	private static final String _past = "Past";
	private static final String _pp = "Past Participle";
	private static final String _prop = "Preposition";
	private static final String _regular = "Regular";

 
   //define editable components
	private JTextField _nameT,_EngSpellingT,_pluralT,
		_1stPersonT,_3rdPersonT,_ingT, _pastT, _ppT,_propT;

   private JCheckBox _dirtyC,_regularC;
   private JTextArea _noteA;
   
	public AConceptEdit(DmConcept aCon){
		super();
		_aCon = aCon;

		_pane = new JOptionPane(getAllPanels(),
    		JOptionPane.PLAIN_MESSAGE,JOptionPane.OK_CANCEL_OPTION);
    		
		createDia();
	}
	
	public AConceptEdit(JFrame parent, String title, 
						 DmConcept aCon){
		super();
		_aCon = aCon;
		_parent =parent;
		_title =title;
		
		_pane = new JOptionPane(getAllPanels(),
    		JOptionPane.PLAIN_MESSAGE,JOptionPane.OK_CANCEL_OPTION);
    		
		createDia();
				
	}

	private JComponent[] getAllPanels(){
		JComponent[]      components = new JComponent[3];
		components[0] = getFieldsPanel();
		components[1] = getNotePanel();
		components[2] = getCardPane();
		return components;	
	}

	private JPanel getFieldsPanel(){
		JPanel fieldsPanel= new JPanel();
      fieldsPanel.setLayout(new GridLayout(2,2));
		
      fieldsPanel.add(new JLabel(_name));
     	_nameT = new JTextField(_aCon.getName());
      fieldsPanel.add(_nameT);
      
      fieldsPanel.add(new JLabel(_dirty));
    	_dirtyC = new JCheckBox("",_aCon.getDirty());
      fieldsPanel.add(_dirtyC);
     
     	return fieldsPanel;	
		
	}
	
	private JPanel getNotePanel(){
		JPanel notePanel= new JPanel();
		Dimension notePanelD= new Dimension(400,120);
      notePanel.setPreferredSize(notePanelD);
      
      notePanel.setLayout(new BorderLayout());
							//new GridLayout(2,1));
		
      notePanel.add(new JLabel(_note),BorderLayout.NORTH);
     	_noteA = new JTextArea(_aCon.getNote());
     	_noteA.setRows(4);	//4 rows of text
      notePanel.add(_noteA, BorderLayout.CENTER);
     	return notePanel;	
      
	}
	
	
	private JTabbedPane getCardPane(){
		JTabbedPane cardPane= new JTabbedPane();
		// Add the different tabs 
	   cardPane.addTab(DmConcept._ENGLISH, null, getEnglihCard());
		cardPane.addTab(DmConcept._FRENCH, null, 	getFrechCrad());
		cardPane.addTab(DmConcept._CHINESE, null, getChineseCard());
		
     	return cardPane;	
      
	}
	
	private JPanel getEnglihCard(){
		_englishCard= new JPanel();
		//	_englishCard.setLayout(new GridLayout(2,2));
      	_englishCard.setLayout(new BorderLayout());
		JPanel tempP= new JPanel();
		tempP.setLayout(new GridLayout(3,2));

      	tempP.add(new JLabel(_spelling));
    	EnglishVerb engVerb =(EnglishVerb)_aCon.getCard(DmConcept._ENGLISH);
    	_EngSpellingT = new JTextField(engVerb.getSpelling());
    	tempP.add(_EngSpellingT);
    	
      	tempP.add(new JLabel(_prop  ));
    	_propT  = new JTextField(engVerb.getProp());
    	tempP.add(_propT );
	     
     
      	tempP.add(new JLabel(_regular));
    	_regularC = new JCheckBox();
    	_regularC.addActionListener(new ReguarChange());
      	tempP.add(_regularC);
      
       _englishCard.add(tempP,BorderLayout.NORTH);
     	//if irregular verb add extra attributes
      	if (engVerb instanceof IrregularVerb){
    		_regularC.setSelected(false);
     		addEnglihIrreg();
      	} else  _regularC.setSelected(true);
     		
     	return _englishCard;	
      
	}
	
	private void addEnglihIrreg(){
		//if not build _englishIrreg JPanel
		if (_englishIrreg == null){
			_englishIrreg= new JPanel();

			_englishIrreg.setLayout(new GridLayout(7,2));
	
	      _englishIrreg.add(new JLabel(_1stPerson ));
	    	IrregularVerb engVerb =(IrregularVerb)_aCon.getCard(DmConcept._ENGLISH);
	    	_1stPersonT  = new JTextField(engVerb.get1stP());
	    	_englishIrreg.add(_1stPersonT );
	     
	      _englishIrreg.add(new JLabel(_3rdPerson ));
	    	_3rdPersonT  = new JTextField(engVerb.get3rdP());
	    	_englishIrreg.add(_3rdPersonT );
	     
	      _englishIrreg.add(new JLabel(_plural));
	      _pluralT = new JTextField(engVerb.getPlural());
	      _englishIrreg.add(_pluralT);
	      
	      _englishIrreg.add(new JLabel(_ing  ));
	    	_ingT  = new JTextField(engVerb.getIng());
	    	_englishIrreg.add(_ingT );
	     
	     
	      _englishIrreg.add(new JLabel(_past  ));
	    	_pastT  = new JTextField(engVerb.getPast());
	    	_englishIrreg.add(_pastT );
	     
	     
	      _englishIrreg.add(new JLabel(_pp  ));
	    	_ppT  = new JTextField(engVerb.getPp());
	    	_englishIrreg.add(_ppT );
	     
	     
		}  
		
		if (!(_englishCard.getComponent(_englishCard.getComponentCount()-1).
			equals(_englishIrreg)))
				_englishCard.add(_englishIrreg, BorderLayout.CENTER);
	}
	
	private void updateRegularT(){
      if (_regularC.isSelected()) {		//isreguar verb
			if (_englishCard.getComponent(_englishCard.getComponentCount()-1).
				equals(_englishIrreg))
					_englishCard.remove(_englishIrreg);
      } else {	
      	JPanel temP = (JPanel)_englishCard.getComponent(_englishCard.getComponentCount()-1);
      	if (_englishIrreg == null ) 
      		addEnglihIrregNew();
      		
   		if(!(temP.equals(_englishIrreg)))
				_englishCard.add(_englishIrreg, BorderLayout.CENTER);
      	
      }
		// _pane.paintImmediately(_pane.getBounds()); 
      _englishCard.invalidate();
      _aConDialog.resize(_aConDialog.getPreferredSize());
      _aConDialog.validate();
      _aConDialog.repaint(10); //repaint in 10 mili-seconds
	

  	}
	
	private JPanel getFrechCrad(){
		JPanel frenchCard= new JPanel();
		frenchCard.add(new JLabel("French language information."));
     	return frenchCard;	
      
	}
	
	private JPanel getChineseCard(){
		JPanel chineseCard= new JPanel();
		chineseCard.add(new JLabel("Chinese language information."));
     	return chineseCard;	
      
	}
	
	private void onButtonPress(){
		
		Object selectedValue = _pane.getValue();
		if (selectedValue != null && selectedValue != JOptionPane.UNINITIALIZED_VALUE){
			Integer sv = (Integer)selectedValue;
			
			if( sv.intValue()  == JOptionPane.OK_OPTION) {
				//update _aCon	
				onOKBotton();
			}else onCancelB();
		}

	}
	
	private void onOKBotton(){
		_OkButtonPressed= true;
		_CancelButtonPressed= false;
		System.out.println( "\n Ok button pressed");
		
		// update concept attributes
     	_aCon.setName(_nameT.getText());
     	_aCon.setDirty(_dirtyC.isSelected());
     	_aCon.setNote(_noteA.getText());
     	
     	// update English language features
    	EnglishVerb engVerb =(EnglishVerb)_aCon.getCard(DmConcept._ENGLISH);
    	engVerb.setSpelling(_EngSpellingT.getText());
      		
       	String prop= _propT.getText();
       	if (prop != null)
       		engVerb.setProp(prop);
      	else 	engVerb.setProp("");
    	
     	//if it is a regular verb, then it can not be irregular
      if (_regularC.isSelected()) {		
       	if (engVerb instanceof IrregularVerb){
       		engVerb= new EnglishVerb(_EngSpellingT.getText());
       		_aCon.setCard(DmConcept._ENGLISH,engVerb);
       	} 
      } else {
       	if (!(engVerb instanceof IrregularVerb)){
	       	engVerb= new IrregularVerb(_EngSpellingT.getText());
	       	_aCon.setCard(DmConcept._ENGLISH,engVerb);
       	}
       	
     		// update irregular verb features
       	IrregularVerb irreg =(IrregularVerb)engVerb;
       	String first= _1stPersonT.getText();
       	if (first != null)
       		irreg.set1stP(first);
      	else 	irreg.set1stP("");
      		
       	String third= _3rdPersonT.getText();
       	if (third != null)
       		irreg.set1stP(third);
      	else 	irreg.set3rdP("");

      	String plur= _pluralT.getText();
       	if (plur != null)
       		irreg.setPlural(plur);
      	else 	irreg.setPlural("");
      	
      		
       	String ing= _ingT.getText();
       	if (ing != null)
       		irreg.set3rdP(ing);
      	else 	irreg.set3rdP("");
      	
      		
       	String past= _pastT.getText();
       	if (past != null)
       		irreg.setPast(past);
      	else 	irreg.setPast("");
      	
      		
       	String pp= _ppT.getText();
       	if (pp != null)
       		irreg.setPp(pp);
      	else 	irreg.setPp("");
      	
      	
      }
      
      //2001-2-14
      // mark related task dirty
      DmManager.getInstance().markTaskDirtyACon(_aCon);
	}
	
	private void onCancelB(){
		_OkButtonPressed= false;
		_CancelButtonPressed= true;
		System.out.println( "\n Cancel button pressed");

	}
	
	public boolean isOKButton(){
		return _OkButtonPressed;
	}
	
	public boolean isCancelButton(){
		return _CancelButtonPressed;
	}
	
	
	public class ReguarChange implements ActionListener{
		public void actionPerformed(ActionEvent e){
			AConceptEdit.this.updateRegularT();
			System.out.println( "\n regular changed");
		}
	}
	
	private void addEnglihIrregNew(){
		//if not build _englishIrreg JPanel
		if (_englishIrreg == null){
			_englishIrreg= new JPanel();

			_englishIrreg.setLayout(new GridLayout(7,2));
	
	      _englishIrreg.add(new JLabel(_1stPerson ));
	    	IrregularVerb engVerb =new IrregularVerb(_aCon.getName());
	    	_aCon.setCard(DmConcept._ENGLISH,engVerb);
	    	_1stPersonT  = new JTextField(engVerb.get1stP());
	    	_englishIrreg.add(_1stPersonT );
	     
	      _englishIrreg.add(new JLabel(_3rdPerson ));
	    	_3rdPersonT  = new JTextField(engVerb.get3rdP());
	    	_englishIrreg.add(_3rdPersonT );
	     
	      _englishIrreg.add(new JLabel(_plural));
	      _pluralT = new JTextField(engVerb.getPlural());
	      _englishIrreg.add(_pluralT);
	      
	      _englishIrreg.add(new JLabel(_ing  ));
	    	_ingT  = new JTextField(engVerb.getIng());
	    	_englishIrreg.add(_ingT );
	     
	     
	      _englishIrreg.add(new JLabel(_past  ));
	    	_pastT  = new JTextField(engVerb.getPast());
	    	_englishIrreg.add(_pastT );
	     
	     
	      _englishIrreg.add(new JLabel(_pp  ));
	    	_ppT  = new JTextField(engVerb.getPp());
	    	_englishIrreg.add(_ppT );
	     
	     
	      _englishIrreg.add(new JLabel(_prop  ));
	    	_propT  = new JTextField(engVerb.getProp());
	    	_englishIrreg.add(_propT );
	     
		}  
		
		if (!(_englishCard.getComponent(_englishCard.getComponentCount()-1).
			equals(_englishIrreg)))
				_englishCard.add(_englishIrreg, BorderLayout.CENTER);
	}
	
	private void createDia(){
    		
		_aConDialog = _pane.createDialog(_parent, _title);
		_aConDialog.show();
		
		onButtonPress();
		return;			
		
	}
}