/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package domainModel;


import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.*;
import taskModellingTool.*;

import org.w3c.dom.*;
import com.ibm.xml.parsers.*;

/** 
* XAction.java, it acts as a agent for communication
* between the ActionInstance class and DOM DmAction element
* as defined by the NewDTDFile3.dtd
* ;
*/
public class XAction
{
	private Document doc = null;
	private static DmManager dM = DmManager.getInstance();
	public XAction(Document aDoc){
		doc = aDoc;	
	}

	
	/**  
	* setDoc(),
	* @PARAM: aDoc, the DOM doc 
	* @return void
	*/
	public void setDoc(Document aDoc)
  	{
		doc = aDoc;

  	} //setDoc()
	
	/**  
	* getDoc(),
	* @return Document
	*/
	public Document getDoc()
  	{
		return doc;

  	} //getDoc()

  	
  	/** 
  	* actToEle, to get a ActionInstance object as input 
  	* and return a DOM DmAction element. 
  	* 
  	*/
	public  Element actToEle(ActionInstance aAct){
		if (aAct == null) return null;
		Element elem = null;		
		try {
			String actTag= XDmTag.getActionT(); //"DmAction";
			
			// create the DmAction element with the right attributes
	  		elem = doc.createElement(actTag);
		    elem.setAttribute(XDmTag.getDmIdT(), aAct.getID());
		    String sTemp =aAct.getName();
		    sTemp = XMLUtility.convertForEntities(sTemp);
		      
		    elem.setAttribute(XDmTag.getDmNameT(), sTemp);	//aAct.getName());
	
		    if (aAct.getConceptOf() != null)
		      	elem.setAttribute(XDmTag.getConceptOfT(), aAct.getConceptOf().getID());
		    //shijian 2001-1-15
		    if (aAct.getDirty() )
		      	elem.setAttribute(XDmTag.getDirtyT(), XManager._XML_YES);
		    else
		      	elem.setAttribute(XDmTag.getDirtyT(), XManager._XML_NO);
		      	
		    if (aAct.getPreModifier() != null){
		      	sTemp =aAct.getPreModifier();
		      	sTemp = XMLUtility.convertForEntities(sTemp);
	
		      	elem.setAttribute(XDmTag.getPremodifierT(),sTemp); 	// aAct.getPreModifier());
		    }
		    if (aAct.getPostModifier() != null){
		      	sTemp =aAct.getPostModifier();
		      	sTemp = XMLUtility.convertForEntities(sTemp);
	
		      	elem.setAttribute(XDmTag.getPostmodifierT(),sTemp);	// aAct.getPostModifier());
		    }
		      //create the act-entityRelations for the DmAction
			TreeMap relationInstances = aAct.getActionRelations();
			if(relationInstances.size() != 0){
		    Element elemARel = doc.createElement(XDmTag.getARelT());
				elem.appendChild(elemARel);
				//create specific ARelationInstances
				DmRelation relM = DmRelation.getInstance();
				String allEnRle[] = relM.getAllActionRelations();
				String relName,insID=null;
				DmInstance inst = null;
				for (int i = 0; i < allEnRle.length; i++) {
					relName=allEnRle[i];
					inst = (DmInstance) relationInstances.get(relName);
		
					if (inst != null){
						insID = inst.getID();
						System.out.println("     "+relName+" Instance: " +
		    				inst.getName());
		    			if(relName.equals(DmRelation.getActor())){
	      					elemARel.setAttribute(XDmTag.getActorT(), insID);
		    			}
		    			else if(relName.equals(DmRelation.getActee())){
	      					elemARel.setAttribute(XDmTag.getActeeT(), insID);
		    			}
		    			else if(relName.equals(DmRelation.getSource())){
	      					elemARel.setAttribute(XDmTag.getSourceT(), insID);
		    			}
		    			else if(relName.equals(DmRelation.getDestination())){
	      					elemARel.setAttribute(XDmTag.getDestiT(), insID);
		    			}
		    			else if(relName.equals(DmRelation.getInstrument())){
	      					elemARel.setAttribute(XDmTag.getInstruT(), insID);
		    			}
		    			else{
		      				Element elemNewR = doc.createElement(XDmTag.getNewARelT());
		      				elemNewR.setAttribute(XDmTag.getARNameT(), relName);
		      				elemNewR.setAttribute(XDmTag.getARValueT(), insID);
		      				elemARel.appendChild(elemNewR);
		    				
		    				
		    			}
					}
		    		
		    }
				
	  //18-1-2002
	  //write contextaul types
	  TreeMap contextTypePairs = aAct.getEContextTypes();
	  Element elemContexts = doc.createElement(XDmTag.getAEContextTypeT());
	  elem.appendChild(elemContexts);
	  String contextType;
	  
	  //26-6-2002, write actual contextual relations rather than predefined
	  //ones
	  Iterator iter = contextTypePairs.keySet().iterator();
	  while(iter.hasNext()){
	  		relName = (String)iter.next(); 
	  		contextType=(String)contextTypePairs.get(relName);
		if(relName.equals(DmRelation.getActor())){
			elemContexts.setAttribute(XDmTag.getActorT(), contextType);
		}
		else if(relName.equals(DmRelation.getActee())){
			elemContexts.setAttribute(XDmTag.getActeeT(), contextType);
		}
		else if(relName.equals(DmRelation.getSource())){
			elemContexts.setAttribute(XDmTag.getSourceT(), contextType);
		}
		else if(relName.equals(DmRelation.getDestination())){
			elemContexts.setAttribute(XDmTag.getDestiT(), contextType);
		}
		else if(relName.equals(DmRelation.getInstrument())){
			elemContexts.setAttribute(XDmTag.getInstruT(), contextType);
		}
		else{
			Element elemNewR = doc.createElement(XDmTag.getNewContextT());
			elemNewR.setAttribute(XDmTag.getARNameT(), relName);
			elemNewR.setAttribute(XDmTag.getContextT(), contextType);
			elemContexts.appendChild(elemNewR);
			
			
		}
	  }
	  
	 /** 
	  for (int i = 0; i < allEnRle.length; i++) {
		relName=allEnRle[i];
		contextType = (String) contextTypePairs.get(relName);
		inst = (DmInstance) relationInstances.get(relName);
		if (inst != null){
			System.out.println("     "+relName+" Instance: " +
  				inst.getName()+ " " +contextType);
  			if(relName.equals(DmRelation.getActor())){
  					elemContexts.setAttribute(XDmTag.getActorT(), contextType);
  			}
  			else if(relName.equals(DmRelation.getActee())){
  					elemContexts.setAttribute(XDmTag.getActeeT(), contextType);
  			}
  			else if(relName.equals(DmRelation.getSource())){
  					elemContexts.setAttribute(XDmTag.getSourceT(), contextType);
  			}
  			else if(relName.equals(DmRelation.getDestination())){
  					elemContexts.setAttribute(XDmTag.getDestiT(), contextType);
  			}
  			else if(relName.equals(DmRelation.getInstrument())){
  					elemContexts.setAttribute(XDmTag.getInstruT(), contextType);
  			}
  			else{
    				Element elemNewR = doc.createElement(XDmTag.getNewContextT());
    				elemNewR.setAttribute(XDmTag.getARNameT(), relName);
    				elemNewR.setAttribute(XDmTag.getContextT(), contextType);
    				elemContexts.appendChild(elemNewR);
  				
  				
  			}
		}
  		
  		

        }
        **/
		}
			
		      //create the act-actRelations for the DmAction
			relationInstances = aAct.getActionActRelations();
			if(relationInstances.size() != 0){
		     	Element elemARel = doc.createElement(XDmTag.getAARelT());
				elem.appendChild(elemARel);
				
				//create specific Act-act Relation Instances
				DmRelation relM = DmRelation.getInstance();
				String allEnRle[] = relM.getAllActionActRelations();
				String relName,insID=null;
				DmInstance inst = null;
				for (int i = 0; i < allEnRle.length; i++) {
					relName=allEnRle[i];
					inst = (DmInstance) relationInstances.get(relName);
		
					if (inst != null){
						insID = inst.getID();
						System.out.println("     "+relName+" Instance: " +
		    				inst.getName());
		    			if(relName.equals(DmRelation.getPurposeRequest())){
	      					elemARel.setAttribute(XDmTag.getPurposeRequestT(), insID);
		    			}
		    			else{
		      				Element elemNewR = doc.createElement(XDmTag.getNewARelT());
		      				elemNewR.setAttribute(XDmTag.getARNameT(), relName);
		      				elemNewR.setAttribute(XDmTag.getARValueT(), insID);
		      				elemARel.appendChild(elemNewR);
		    				
		    				
		    			}
					}
		    		
		       }
			
			}
			/*
		String allAARle[] = _dMRelat.getAllActionActRelations();
      	int numberAARel =allAARle.length; 

			*/
			
		    //create Note element 
			if (aAct.getNote() != null && (!aAct.getNote().trim().equals(""))){
				sTemp =aAct.getNote();
		      	sTemp = XMLUtility.convertForEntities(sTemp);
	
		      	Element elemNote = doc.createElement(XDmTag.getDmNoteT());
		      	elemNote.appendChild(doc.createTextNode(sTemp));	//aAct.getNote()));
		      	elem.appendChild(elemNote);
			}
	      
		}
		catch (Exception e)
		{
			System.err.println(e);
		}
		return elem;
  	}//actToEle()
  	  	
  	/** 
  	* eleToAct, is get a DOM DmAction element as input 
  	* and return a ActionInstance object. 
  	* 
  	*/
	public  ActionInstance eleToAct(Element ele){
		if (ele == null) return null;
		ActionInstance aAct = null;
		//System.out.println("element tag: "+ele.getTagName() + "\"");
		//System.out.println("defined tag; \""+ XDmTag.getEntityT()+ "\"");



		if (ele.getTagName().equals(XDmTag.getActionT())){	// if it is a ActionInstance element
			try{
				
				// retrieve action attributes
				String actId= ele.getAttribute(XDmTag.getDmIdT());
				if (actId == null || actId == "") System.out.println("no ID");

				String actName= ele.getAttribute(XDmTag.getDmNameT());
				String conceptOf= ele.getAttribute(XDmTag.getConceptOfT());
				String dirty= ele.getAttribute(XDmTag.getDirtyT());
				String premodifier= ele.getAttribute(XDmTag.getPremodifierT());
				String postModifier= ele.getAttribute(XDmTag.getPostmodifierT());
				
				//retrieve "ARelations" - action-entity relation
				String actor = null;
				String actee =  null;
				String source =  null;
				String destination =  null;
				String instrument =  null;

				NodeList children = ele.getElementsByTagName(XDmTag.getARelT());
	         if (children != null && children.getLength() >0 ) {
				//	System.out.println("partOf tag: \""+((Element)children.item(0)).getTagName() + "\"");
	         		Element aRel = (Element)children.item(0); 
		         	
					actor = aRel.getAttribute(XDmTag.getActorT());
					actee = aRel.getAttribute(XDmTag.getActeeT());
					source = aRel.getAttribute(XDmTag.getSourceT());
					destination = aRel.getAttribute(XDmTag.getDestiT());
					instrument = aRel.getAttribute(XDmTag.getInstruT());
	         }
	         
	         TreeMap newRel= new TreeMap();
	         String newRelName, newRelValue;
	         children = ele.getElementsByTagName(XDmTag.getNewARelT());
	         if (children != null && children.getLength() >0 ) {
	         	for (int i = 0; i< children.getLength(); i++){
	         		newRelName = ((Element)children.item(i)).getAttribute(XDmTag.getARNameT());
	         		newRelValue = ((Element)children.item(i)).getAttribute(XDmTag.getARValueT());
	         		newRel.put(newRelName,newRelValue);
	         	}
	         	
	         }
	     //18-1-2002		
	     //retrieve "contextual types", 
		String actorContext = null;
		String acteeContext =  null;
		String sourceContext =  null;
		String destinationContext =  null;
		String instrumentContext =  null;
		
		String contextType = null;
		Element aconRel=null;
		children = ele.getElementsByTagName(XDmTag.getAEContextTypeT());
         if (children != null && children.getLength() >0 ) {
			//	System.out.println("partOf tag: \""+((Element)children.item(0)).getTagName() + "\"");
         		aconRel = (Element)children.item(0); 
			actorContext = aconRel.getAttribute(XDmTag.getActorT());
			acteeContext = aconRel.getAttribute(XDmTag.getActeeT());
			sourceContext = aconRel.getAttribute(XDmTag.getSourceT());
			destinationContext = aconRel.getAttribute(XDmTag.getDestiT());
			instrumentContext = aconRel.getAttribute(XDmTag.getInstruT());
         }
         
         TreeMap newConRel= new TreeMap();
         if (aconRel != null){
	         children = aconRel.getElementsByTagName(XDmTag.getNewContextT());
	         if (children != null && children.getLength() >0 ) {
	         	for (int i = 0; i< children.getLength(); i++){
	         		newRelName = ((Element)children.item(i)).getAttribute(XDmTag.getARNameT());
	         		newRelValue = ((Element)children.item(i)).getAttribute(XDmTag.getContextT());
	         		newConRel.put(newRelName,newRelValue);
	         	}
	         	
	         }
         }
			//retrieve "AARelations", action-action relations
			String purposeRequest = null;
			Element aaRel=null;
			children = ele.getElementsByTagName(XDmTag.getAARelT());
	         if (children != null && children.getLength() >0 ) {
				//	System.out.println("partOf tag: \""+((Element)children.item(0)).getTagName() + "\"");
	         		aaRel = (Element)children.item(0); 
		         	
					purposeRequest = aaRel.getAttribute(XDmTag.getPurposeRequestT());
	         }
	         
	         TreeMap newAARel= new TreeMap();
	         //String newRelName, newRelValue;
	         if (aaRel != null){
		         children = aaRel.getElementsByTagName(XDmTag.getNewARelT());
		         if (children != null && children.getLength() >0 ) {
		         	for (int i = 0; i< children.getLength(); i++){
		         		newRelName = ((Element)children.item(i)).getAttribute(XDmTag.getARNameT());
		         		newRelValue = ((Element)children.item(i)).getAttribute(XDmTag.getARValueT());
		         		newAARel.put(newRelName,newRelValue);
		         	}
		         	
		         }
	         }
	         
	         //retrieve "note"
				String actNote = null;
	         children = ele.getElementsByTagName(XDmTag.getDmNoteT());
	         if (children != null && children.getLength() >0 ) 
	         	if(children.item(0)!= null)
	         		if (children.item(0).getFirstChild() != null)
	         			if (children.item(0).getFirstChild().getNodeValue()!= null)
	         				actNote =children.item(0).getFirstChild().getNodeValue(); 
	         
	         // create the ActionInstance object
			if ( actId == null ||actId.trim() == "" ||
						actName == null || actName.trim() == "") return null;
				
			actName= XMLUtility.checkAndConvertForEntities(actName);
			aAct = new ActionInstance(actId,actName);

	        if (actNote != null && actNote.trim() != ""){
	        	actNote= XMLUtility.checkAndConvertForEntities(actNote);
	         	aAct.setNote(actNote);
	        }
	         //2001-8-17
	         //should not create a separate copy of concept 
	         // should use the concept ID to refer the concept
	         // created before 
	         DmConcept con= null;
	         if (conceptOf != null){
	         	con = DmManager.getInstance().getConcept(conceptOf.trim());
	        	//if (conceptOf != null && conceptOf.trim() != ""){
	         		//XConcept xCon= new XConcept(getDoc());
	        		//	aAct.setConceptOf(xCon.eleToCon(getDoc().getElementById(conceptOf.trim())));
	        }
	         if (con == null)
	         	con = DmConcept.getDefaultActionConcept();
	         aAct.setConceptOf(con);

	         if (dirty.equals(XManager._XML_YES) )
	        		aAct.setDirty(true);
	        	else
	        		aAct.setDirty(false);
	        if (premodifier != null && premodifier.trim() != ""){
	        	premodifier= XMLUtility.checkAndConvertForEntities(premodifier);
	         	aAct.setPreModifier(premodifier);
	        }
	        if (postModifier != null && postModifier.trim() != ""){
	        	postModifier= XMLUtility.checkAndConvertForEntities(postModifier);
	         	aAct.setPostModifier(postModifier);
	        }
	         
	        //set action-entity relations
	        XEntity xEn = new XEntity(getDoc());
	        if (actor != null && actor.trim() != "")
	        		aAct.setActionRelation(DmRelation.getActor(),
	        			xEn.eleToEn(getDoc().getElementById(actor.trim())));
	         if (actee != null && actee.trim() != "")
	        		aAct.setActionRelation(DmRelation.getActee(),
	        			xEn.eleToEn(getDoc().getElementById(actee.trim())));
	         if (source != null && source.trim() != "")
	        		aAct.setActionRelation(DmRelation.getSource(),
	        			xEn.eleToEn(getDoc().getElementById(source.trim())));
	         if (destination != null&& destination.trim() != "")
	         	aAct.setActionRelation(DmRelation.getDestination(),
	        			xEn.eleToEn(getDoc().getElementById(destination.trim())));
	         if (instrument != null && instrument.trim() != "")
	        		aAct.setActionRelation(DmRelation.getInstrument(),
	        			xEn.eleToEn(getDoc().getElementById(instrument.trim())));
        	if (newRel != null && newRel.size() > 0 ){
        		Iterator it = newRel.keySet().iterator();	
        		while ( it.hasNext()){
        			newRelName = (String)it.next(); 	
        			newRelValue = (String)newRel.get(newRelName); 	
        			
        		aAct.setActionRelation(newRelName,
        			xEn.eleToEn(getDoc().getElementById(newRelValue)));
        		}
        	}
	         //18-1-2002
	        //set contextual types
	        if (actorContext != null && actorContext.trim() != "")
	        		aAct.setEntityContextType(DmRelation.getActor(),
	        			actorContext);
	         if (acteeContext != null && acteeContext.trim() != "")
	        		aAct.setEntityContextType(DmRelation.getActee(),
	        			acteeContext);
	         if (sourceContext != null && sourceContext.trim() != "")
	        		aAct.setEntityContextType(DmRelation.getSource(),
	        			sourceContext);
	         if (destinationContext != null&& destinationContext.trim() != "")
	         	aAct.setEntityContextType(DmRelation.getDestination(),
	        			destinationContext);
	         if (instrumentContext != null && instrumentContext.trim() != "")
	        		aAct.setEntityContextType(DmRelation.getInstrument(),
	        			instrumentContext);
        	if (newConRel != null && newConRel.size() > 0 ){
        		Iterator it = newConRel.keySet().iterator();	
        		while ( it.hasNext()){
        			newRelName = (String)it.next(); 	
        			newRelValue = (String)newConRel.get(newRelName); 	
        			
        			aAct.setEntityContextType(newRelName,newRelValue);
        		}
        	}
	         
	        //set action-action relations
	        XAction xAct = new XAction(getDoc());
	        ActionInstance aiTemp;
	        if (purposeRequest != null && purposeRequest.trim() != ""){
	        	if (dM.getAInstance(purposeRequest) != null)
	        		aiTemp =dM.getAInstance(purposeRequest);
	        	else
	        		aiTemp =xAct.eleToAct(getDoc().
	        			getElementById(purposeRequest.trim()));
	        			
        		aAct.setActionActRelation(DmRelation.getPurposeRequest(),
        			aiTemp);
	        }
        	if (newAARel != null && newAARel.size() > 0 ){
        		Iterator it = newAARel.keySet().iterator();	
        		while ( it.hasNext()){
        			newRelName = (String)it.next(); 	
        			newRelValue = (String)newAARel.get(newRelName); 	

		        	if (dM.getAInstance(newRelValue) != null)
		        		aiTemp =dM.getAInstance(newRelValue);
		        	else
		        		aiTemp =xAct.eleToAct(getDoc().
	        				getElementById(newRelValue.trim()));
        			aAct.setActionActRelation(newRelName,aiTemp);
        		}
        	}
	 	         
			}
			catch (Exception e)
			{
				System.err.println(e);
			}
			
		}
		return aAct;
	}//eleToAct()
  	
  	
  	/** 
  	* add(), add an DmAction element to the doc. it 
  	*  simply append to 
  	* the Domain_model's children list. If Domain_model element
  	* is not present, the element is not added.
  	*/
  	public boolean add(Element ele){
		if (getDoc() == null || ele == null) return false;
		if (!(XManager.append(getDoc(), ele))) return false;
	 	return true;
  	}//add()
  	
  	/** 
  	* remove(), remove an element from Domain_model's chidren 
  	* list if it exists. 
  	*/
  	public void remove(String iD){
		if (doc == null || iD == null) return;
		try {
	      //get the Domain_model element.
	      Element theE = doc.getElementById(iD);
	    	if (theE != null)
	    	{	
	         theE.getParentNode().removeChild(theE);
	    	}
		}
		catch (Exception e)
		{
			System.err.println(e);
		}
  		
  	}//remove()
  	
  	
  	

  	/** 
  	* Main program entry point.
  	*/
  public static void main(String argv[]) 
  {
    if (argv.length == 0)
    {
      System.out.println("Usage:  java XAction uri");
      System.out.println("   where uri is the URI of the XML document you want to print.");
      System.out.println("   Sample:  java XAction dmTest3.xml");
      System.exit(1);
    }
    
		//testing xConcept
    	XConcept d1 = new XConcept(XManager.parse(argv[0]));
    	DmConcept dia = new DmConcept("dialog", "entity type");
    	DmConcept win = new DmConcept("window", "entity type");
	 	win.setNote("this is a test for adding concept with DOM");
	 
  		XManager.insertBAction(d1.getDoc(),d1.conToEle(win));
  		XManager.insertBEntity(d1.getDoc(),d1.conToEle(dia));
  	
  		Element c1 = d1.getDoc().getElementById("dmC1");
  		if (c1 == null) System.out.println("no element");
  		XManager.remove(d1.getDoc(),"dmC1");
  		if (d1.eleToCon(c1) == null) System.out.println("no concept");
  		XManager.insertBEntity(d1.getDoc(),d1.conToEle(d1.eleToCon(c1)));

		//testing XEntity 
    	XEntity e1 = new XEntity(d1.getDoc());
    	
    	EntityInstance ei1= new EntityInstance ("main");
		ei1.setConceptOf(win);	
		
		EntityInstance ei2= new EntityInstance ("save");
		ei2.setConceptOf(dia);
		ei2.setEntityRelation(DmRelation.getPartOf(),ei1);
		
  		XManager.insertBAction(e1.getDoc(),e1.enToEle(ei1));
  		XManager.append(e1.getDoc(),e1.enToEle(ei2));
  		
  		Element ele = e1.getDoc().getElementById("dmE1");
  		
  		XManager.remove(e1.getDoc(),"dmE1");
  		if (e1.eleToEn(ele) == null) System.out.println("no entity");
  		XManager.append(e1.getDoc(),e1.enToEle(e1.eleToEn(ele)));

  		
  		//testing XAction
  		XAction xAct = new XAction(d1.getDoc());
		ActionInstance clerkKlick1= new ActionInstance ("clerk click save button");
  		
    	DmConcept klick = new DmConcept("click", "action type");
    	DmConcept button = new DmConcept("button", "entity type");
    	
    	d1.add(d1.conToEle(klick));
    	d1.add(d1.conToEle(button));

    	EntityInstance clerk= new EntityInstance ("clerk");
		clerk.setConceptOf(d1.eleToCon(e1.getDoc().getElementById("dmC1")));	
     	EntityInstance save= new EntityInstance ("save");
		save.setConceptOf(button);	
		
  		if (!(XManager.hasElement(xAct.getDoc(),e1.enToEle(clerk)))) System.out.println("Clerk is not there yet.");
     	e1.add(e1.enToEle(clerk));
    	e1.add(e1.enToEle(save));
		
		clerkKlick1.setConceptOf(klick);	
		clerkKlick1.setActionRelation("actor", clerk);
		clerkKlick1.setActionRelation("actee", save);

		xAct.add(xAct.actToEle(clerkKlick1));
		
		//testing XAction.eleToAct()
  		Element actEle = xAct.getDoc().getElementById("dmSelect2");
  		if (XManager.hasElement(xAct.getDoc(),actEle)) System.out.println("yes, it has the action element");
  		XManager.remove(xAct.getDoc(),"dmSelect2");
  		if (xAct.eleToAct(actEle) == null) System.out.println("no Action");
  	//	XManager.append(xAct.getDoc(),xAct.actToEle(xAct.eleToAct(actEle)));
		xAct.add(xAct.actToEle(xAct.eleToAct(actEle)));

  		XManager.printDOMTree(e1.getDoc());


  }//main()
}//class: XAction