/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

//Source file: C:/Data/Isolde/Tamot3/Current/domainModel/IrregularVerb.java

package domainModel;


/**
 * The root class for all language IrregularVerbs
 * @author 
 */
public class IrregularVerb extends EnglishVerb 
{
	private String _1stPerson;
	private String _3rdPerson;
	private String _plural;
	private String _ing;
	private String _past;
	private String _pp;

	private static final String _ING = "ing";
	private static final String _ED = "ed";
	private static final String _S = "s";

	public IrregularVerb() 
	{
	
	}

	public IrregularVerb(String na) 
	{
		super(na);
		set1stP(na);
		set3rdP(na + _S);
		setPlural(na);
		setIng(na+_ING);
		setPast(na+_ED);
		setPp(na+_ED);
	}
	
	public IrregularVerb(String id,String na) 
	{
		super( id,na);	//.toLowerCase().trim();
		set1stP(na);
		set3rdP(na + _S);
		setPlural(na);
		setIng(na+_ING);
		setPast(na+_ED);
		setPp(na+_ED);
		
	}
/**
* Access method for the _1stPerson property.
* @return   the current value of the _1stPerson property
*/
	public String get1stP() {
		return _1stPerson;
	}
	
/**
 * @return void
 * Sets the value of the _1stPerson property.
 * @param aName the new value of the _1stPerson property
	 */
	public void set1stP(String p) {
		_1stPerson = p;
	}

/**
* Access method for the _3rdPerson property.
* @return   the current value of the _3rdPerson property
*/
	public String get3rdP() {
		return _3rdPerson;
	}
	
/**
 * @return void
 * Sets the value of the _3rdPerson property.
 * @param aName the new value of the _3rdPerson property
	 */
	public void set3rdP(String p) {
		_3rdPerson = p;
	}
	
/**
* Access method for the _plural property.
* @return   the current value of the _plural property
*/
	public String getPlural() {
		return _plural;
	}
	
/**
 * @return void
 * Sets the value of the _plural property.
 * @param aName the new value of the _plural property
	 */
	public void setPlural(String p) {
		_plural = p;
	}

/**
* Access method for the _ing property.
* @return   the current value of the _ing property
*/
	public String getIng() {
		return _ing;
	}
	
/**
 * @return void
 * Sets the value of the _ing property.
 * @param aName the new value of the _ing property
	 */
	public void setIng(String p) {
		_ing = p;
	}

/**
* Access method for the _past property.
* @return   the current value of the _past property
*/
	public String getPast() {
		return _past;
	}
	
/**
 * @return void
 * Sets the value of the _past property.
 * @param aName the new value of the _past property
	 */
	public void setPast(String p) {
		_past = p;
	}

/**
* Access method for the _pp property.
* @return   the current value of the _pp property
*/
	public String getPp() {
		return _pp;
	}
	
/**
 * @return void
 * Sets the value of the _pp property.
 * @param p the new value of the _pp property
 */
	public void setPp(String p) {
		_pp = p;
	}

	public static void main(String args[]) {
    	
		IrregularVerb d1 = new IrregularVerb("do");
		System.out.println( d1.getSpelling()+ "  " + d1.get1stP()
					+ "  " + d1.get3rdP()	+ "  " + d1.getPlural()
					+ "  " + d1.getPast()	+ "  " + d1.getPp());

	//	d1.setPlural("media");
	//	System.out.println( d1.getSpelling() + "  " + d1.isMassNoun() 
	//			+ "  " + d1.getPlural());
    }
}