/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

//Source file: C:/Data/Isolde/Tamot2/Current/domainModel/DmInstance.java

package domainModel;


/**
 * @author 
 */
public abstract class DmInstance extends DmClass 
{
  private DmConcept conceptOf;
  private String iconFileName;          // image of the instance's icon - kvlinden, 10jan2001
  private String preModifier, postModifier; // canned pre/post modifiers - kvlinden, 8jan2001

  public DmInstance(String na) 
  {
    super(na);
  }
	
  public DmInstance(String iD,String na) 
  {
    super(iD, na);
  }
  /**
   * @exception 
   * @author 
   * Access method for the conceptOf property.
   *
   * @return   the current value of the conceptOf property
   */
  public DmConcept getConceptOf() {
    return conceptOf;
  }
	
  /**
   * @return void
   * @exception 
   * @author 
   * Sets the value of the conceptOf property.
   *
   * @param aConceptOf the new value of the conceptOf property
   */
  public  boolean setConceptOf(DmConcept aConceptOf) {
    conceptOf = aConceptOf;
    return true;
  }

  // accessor functions for the pre/post modifiers - kvlinden, 8jan2001
  public String getPreModifier() {
    return preModifier;
  }
  public boolean setPreModifier(String value) {
    preModifier = value;
    return true;
  }
  public String getPostModifier() {
    return postModifier;
  }
  public boolean setPostModifier(String value) {
    postModifier = value;
    return true;
  }
  
  // accessor functions for the icon image file - kvlinden, 10jan2001
  public String getIconFileName() {
    return iconFileName;
  }
  public boolean setIconFileName(String value) {
    iconFileName = value;
    return true;
  }
  
  /**
   * @return void
   * @exception 
   * @author 
   * Sets the value of the conceptOf property.
   *
   * @param aConceptOf the new value of the conceptOf property
   */
  public abstract void removeConceptOf() ;
  //	DmConcept temp = getConceptOf();
  // remove this instance from the DmConcept temp's
  //instances list
  //}
	

  /**
   * establish a conceptOf and instance Attachment 
   * @param aConcept, the Concept to be conceptOf. If aConcept == null,
   * anInstance will be still be removed from its original concept's 
   * instance collection
   * @param anInstance, the instance to be added to aConcept's instance 
   * collection. If aChild == null,
   * nothing will be done
   */
  public static void setCIAttachment(DmConcept aConcept, DmInstance anInstance) {
    if (anInstance!= null){
      DmConcept oldC = anInstance.getConceptOf();
      if (oldC != null) {
	oldC.removeInstance(anInstance);
      }
        	
      if (aConcept != null) aConcept.addInstance(anInstance);
      anInstance.setConceptOf(aConcept);
    }
  } // setPCHierarchy()

	

} //class: DmInstance
