/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

//Source file: C:/Data/Isolde/Tamot2/Current/domainModel/DmClass.java

package domainModel;


/**
 * The root class for all domain model elements
 * @author 
 */
public class DmClass extends Object
{
	private final static long SMALLEST_ID = 0;
	private final static String ID_PREFIX  = "dm_";
		
	private static long ID = SMALLEST_ID; // keep track object ID
	private String dmID;
	private String name;
	private String note;	// store comments
//	private String lexItem;  //shijian 2001-1-15
	private boolean dirty;
	
	public DmClass() 
	{
	
	}

	public DmClass(String na) 
	{
		this( makeNewID(),na);
		
	}
	
	public DmClass(String iD,String na) 
	{
		dmID = iD;
		name = na.toLowerCase().trim();	// use lower-case for names
	//	lexItem = na; //shijian 2001-1-15

		dirty= true;
	}
	

	/**
	* makeNewID() 
	* 
	* 
	* @return   a new ID for DmClass object
	*/
	private static String makeNewID() {
		
		return ID_PREFIX + Long.toString(++ID);
	}
	
		/**
	* getID() 
	* 
	* Access method for the dmID property.
	*
	* @return   the ID of the object
	*/
	public String getID() {
		
		return dmID;
	}
	
	void setID(String st) {
		if (st != null)
		 	dmID= st;
		return;
	}
	
		/**
	* getOldID() 
	* 
	* Access method for the ID property.
	*
	* @return   the ID of the class
	*/
	public static long getLargestID() {
		
		return ID;
	}
	
		/**
	* getIdDigits() 
	* 
	* if the dmID field startsWith String "dm_"
	* and what follows are a number then that number
	* is returned, otherwise, -1 is returned
	*/
	public long getIdDigits() {
		String temp = getID();
		if (!(temp.startsWith(ID_PREFIX)))
			return -1;
			
		String temp2 = temp.substring(ID_PREFIX.length());
		try {
			
			return Long.parseLong(temp2); 
			
		}
		catch (NumberFormatException e)
		{
	      //System.err.println("Sorry, an error occurred: " + e);
	      return -1;
		}
	
	} //getIdDigits()


/**
* @exception 
* @author 
* Access method for the name property.
*
* @return   the current value of the name property
*/
	public String getName() {
		return name;}
	
	/**
	 * @return void
	 * @exception 
	 * @author 
* Sets the value of the name property.
*
* @param aName the new value of the name property
	 */
	public void setName(String aName) {
		name = aName.toLowerCase().trim();
	}
	
	/**
	 * @exception 
	 * @author 
* Access method for the lexItem property.
*
* @return   the current value of the lexItem property
	 */
	//public String getLexItem() {	//shijian 2001-1-15

	//	return lexItem;
	//}
	
	/**
	 * @return void
	 * @exception 
	 * @author 
* Sets the value of the lexItem property.
*
* @param aLexItem the new value of the lexItem property
	 */
	//public void setLexItem(String aLexItem) {
	//	lexItem = aLexItem;
	//}
	
	/**
	 * @exception 
	 * @author 
* Access method for the dirty property.
*
* @return   the current value of the dirty property
	 */
	public boolean getDirty() {
		return dirty;
	}
	
	/**
	 * @return void
	 * @exception 
	 * @author 
* Sets the value of the dirty property.
*
* @param aDirty the new value of the dirty property
	 */
	public void setDirty(boolean aDirty) {
		dirty = aDirty;
	}
	
	/**
	 * setNewId
	 * Sets the value of the ID property.
	 */
	public static void setNewId(long aNum) {
		ID = aNum;
	}//setNewId

	/**
	 * 
* Sets the value of the note property.
*
* @param aNote the new value of the note property
	 */
	public void setNote(String aNote) {
		note = aNote;
	}
	
	/**
	 * 
* Add more comment to the note property.
*
* @param moreNote, the new comment to add 
	 */
	public void appendNote(String moreNote) {
		note += moreNote;
	}
	
	/**
*
* @return   the current value of the note property
	 */
	public String getNote() {
		return note;
	}
	
	/**
	 * @return void
* test the class.
*
* 
*/
	public static void main(String args[]) {
    	
		DmClass d1 = new DmClass("dMObject1");
		DmClass d2 = new DmClass("dMObject2");
		DmClass d3 = new DmClass("dMObject3");
		DmClass d4 = new DmClass("dMObject4");
		DmClass d5 = new DmClass("roseId_1","dMObject4");
		DmClass d6 = new DmClass("new dmClass");

		
		System.out.println(d1.getID()+ " " + d1.getName() + " "+ " "+ d1.getDirty());
		System.out.println(d2.getID()+ " " + d2.getName() + " ");
		System.out.println(d3.getID()+ " " + d3.getName() + " ");
		System.out.println(d4.getID()+ " " + d4.getName() + " ");
		System.out.println(d5.getID()+ " " + d5.getName() + " ");
		System.out.println(d6.getID()+ " " + d6.getName() + " ");
    	
    }
}