/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

package domainModel;

import java.util.ArrayList;

/**
 * This class implements the Singleton pattern 
 * so that only one Concept-Type object can be created.
 * It manages the Concept-types. 
 */
public class ContextualType {
	private final static String _normalType= "normal"; 
	private final static String _12DType= "1-2d";
	private final static String _3DType= "3d"; 
	
	private final static String predefinedTypes[] 
		= {	_normalType, 		//normal entity-instance type
			_12DType, 		//1 or 2 D contextaul entity-instance type
			_3DType};		// 3 D contextaul entity-instance type
			
			
	private static ArrayList allTypes; // types collection: storing all known concept types
	 	private static ContextualType cTInstance
	    = new ContextualType();
	  
	 	//static initialisation
	 	static {
	  		allTypes = new ArrayList(5);	
	  		for (int i = 0; i < predefinedTypes.length; i++) {	// add predefined types to the 
	  			allTypes.add(predefinedTypes[i]);				// collection
	     		}

   		}

    /**
     * This private constructor is defined so the compiler won't
     * generate a default public constructor.
     */
 private ContextualType() { 
 }
        
    /**
     * Return a reference to the only instance of this class.
     */
 public static ContextualType getInstance() {
     return cTInstance;
 } // getInstance()

    /**
     * Check if the given string is a defined Contextual-type 
     * @param type, the string to be checked
     */
 public static boolean isContextualType(String type) {
      	if (allTypes.contains(type)){
        		return true;
      	}else return false;
    	
 } // isContextualType()

    /**
     * retrun all known concept-types 
     */
    public String[] getAllTypes() {
    	//String types[] = allTypes.toArray();
        return predefinedTypes;
    } // getAllTypes()
    
    /**
     * retrun number of all known concept-types 
     */
    public int getCount() {
    	return allTypes.size();
    } // getCount()
    
    /**
     * retrun 1 or 2 D concept-type 
     */
    public static String getNormal() {
    	return _normalType;
    } // getD12Type()

    /**
     * retrun 1 or 2 D concept-type 
     */
    public static String get12DType() {
    	return _12DType;
    } // getD12Type()

//2001-8=21
    /**
     * retrun 3 D concept-type 
     */
    public static String get3DType() {
    	return _3DType;
    } // getD3Type()
    

    /**
	 * @return void
	* test the class.
	*
	* 
	*/
	public static void main(String args[]) {
    	
		ContextualType d1 = ContextualType.getInstance();		
		System.out.println("nO of concept-types: " + d1.getCount());

		String types[] = d1.getAllTypes();
		for (int i = 0; i < types.length; i++) {
    		System.out.println("contextual-types: " + types[i]);				
       	}  
       	
       	System.out.println();
		String d2type = d1.get12DType();
    		System.out.println("12d-types: " + d2type);				
       	
       	System.out.println();
		String d3type = d1.get3DType();
    		System.out.println("3d-types: " + d3type);				
       	
       	
       	String inter= " 3D interface type";
       	if (d1.isContextualType(inter))
       		System.out.println("yes, it is contextual");
       	else 
       		System.out.println("no, it is not contextual");
				
    } //main()


} // class ConceptType