/*
   Tamot --- Task Modelling Editor 
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

//Source file: C:/Data/Isolde/Tamot2/Current/domainModel/ActionInstance.java


package domainModel;
import utility.*;
import java.util.*;

/**
 * @author 
 */
public class ActionInstance extends DmInstance 
{
	private DmRelation actionRelation = DmRelation.getInstance();
	private TreeMap instanceRelation; 
	private TreeMap actInstanceRelation; 
	
	//16-1-2002
	//add contextual-types for entity instance relations
  private TreeMap _contextualTypes; 
  private ContextualType _contextType = ContextualType.getInstance();

	public ActionInstance(String na) 
	{
		super(na);

		super.setConceptOf(DmConcept.getDefaultActionConcept());
		DmConcept.getDefaultActionConcept().addInstance(this);
		
    //initialise act-act Relations
		initActEntityRel();
		
    //initialise contextual types for act-entity Relations
		initContextTypes();
		
		//initialise act-act Relations
		initActRel();
		
	}
		
	public ActionInstance(String iD, String na) 
	{
		super(iD,na);

		super.setConceptOf(DmConcept.getDefaultActionConcept());
		DmConcept.getDefaultActionConcept().addInstance(this);
				
    //initialise act-act Relations
    initActEntityRel();
		
    //initialise contextual types for act-entity Relations
    initContextTypes();
		
		//initialise act-act Relations
		initActRel();
	}
	
	/**
	 * set the conceptOf to the specified Dmconcept.
	 * it check the type of aCOncept is of DefaultEntityType
	 * if yes, the conceptOf is changed and true is returned.
	 * if no, a message is printed and false is returned
	 * @param aConceptOf: the new value of the conceptOf property
	 */
	/*public boolean setConceptOf(DmConcept aConceptOf){
	//	removeConceptOf();
		DmConcept temp = getConceptOf();
		if (aConceptOf == null) {
			super.setConceptOf(aConceptOf);
			if (temp != null) temp.removeInstance(this);
			return true;

		}
		if (aConceptOf.getType().equals(ConceptType.getDefaultActionType())){
			super.setConceptOf(aConceptOf);
			aConceptOf.addInstance(this);
			if (temp != null) temp.removeInstance(this);
			return true;
		}else{
			System.out.println("DmConcept " + aConceptOf.getName()+ " is wrong type!!");
			return false;
		}
	} //setConceptOf()
*/
	/**
	 * remove this instance from its DmConcept's
	 * instances list
	 * 
	 */
	public void removeConceptOf() {		
	//	if (!(temp.equals(temp.getDefaultEntityConcept()))){
	//		setConceptOf(DmConcept.getDefaultEntityConcept());
	//		DmConcept.getDefaultEntityConcept().addInstance(this);
	//	}else setConceptOf(null);
		
	}//removeConceptOf()
	
	
	/**
	* Add action-relation object.
	* If the relation previously contained an instance, the old 
	* instance is replaced
	* @param rel,  the name of the relation 
	* @param aInstance, the instance to which the relation applies
	*/
	public boolean setActionRelation(String rel, DmInstance aInstance) {
		String goodRel=actionRelation.getActionRelation(rel);
		if (!(goodRel == null)){
			instanceRelation.put(goodRel, aInstance);
			return true;
		} else return false;
		//may need to check , or restrict aInstance to be of class
		// EntityInstance
	}
	
	/**
	* Get all act-entityRelations .
	*/
	public TreeMap getActionRelations() {
		return instanceRelation;
	}
	
	public Collection getRelIns() {
		Collection eiCol = getActionRelations().values();
		SortArrayList sv = new SortArrayList (new DmClassCompare());

		Iterator it2 = eiCol.iterator();
		EntityInstance eiTemp;
		while (it2.hasNext()){
			eiTemp = (EntityInstance)it2.next();
			if (eiTemp != null)
				sv.add(eiTemp);
		}
		sv.sort();
		return Collections.unmodifiableCollection(sv);
	}
	
	//14-11-2001
	//initialize actInstanceRelations
	private void initActRel(){
		actInstanceRelation= new TreeMap();
		String aRaltion[] = actionRelation.getAllActionActRelations();
		for (int i = 0; i< aRaltion.length; i++){
			actInstanceRelation.put(aRaltion[i], null);
		}
	}
	/**
	* Get all act-act Relations .
	*/
	public TreeMap getActionActRelations() {
		return actInstanceRelation;
	}
	
	public Collection getActActRelIns() {
		Collection aiCol = getActionActRelations().values();
		SortArrayList sv = new SortArrayList (new DmClassCompare());

		Iterator it2 = aiCol.iterator();
		ActionInstance aiTemp;
		while (it2.hasNext()){
			aiTemp = (ActionInstance)it2.next();
			if (aiTemp != null)
				sv.add(aiTemp);
		}
		sv.sort();
		return Collections.unmodifiableCollection(sv);
	}
	
	/**
	* Add action-act relation object.
	* If the relation previously contained an instance, the old 
	* instance is replaced
	* @param rel,  the name of the relation 
	* @param aInstance, the instance to which the relation applies
	*/
	public boolean setActionActRelation(String rel, ActionInstance aInstance) {
		String goodRel=actionRelation.getActionActRelation(rel);
		if (!(goodRel == null)){
			actInstanceRelation.put(goodRel, aInstance);
			return true;
		} else return false;
		//may need to check , or restrict aInstance to be of class
		// EntityInstance
	}
	
//16-1-2002
//initialize act-entity Instance Relations 
private void initActEntityRel(){
    //initialise act-entity Relations
    instanceRelation= new TreeMap();

    String aRaltion[] = actionRelation.getAllActionRelations();
    
    for (int i = 0; i< aRaltion.length; i++){
	instanceRelation.put(aRaltion[i], null);
     }
}
		
//16-1-2002
//initialize contextual types act-entity Instance Relations  
private void initContextTypes(){
    _contextualTypes= new TreeMap();	//16-1-2002

    String aRaltion[] = actionRelation.getAllActionRelations();
    String contexTypeNormal= _contextType.getNormal();
    
    for (int i = 0; i< aRaltion.length; i++){
	_contextualTypes.put(aRaltion[i], contexTypeNormal);
    }
    
    	//26-2-2002, initialise process, it is used to instore 
	// non-imparative verb-form, 
	_contextualTypes.put(DmRelation.ACTION_PROCESS, "");
	

}
	
/**
* Get all contextual-types for act-entityRelations .
*/
public TreeMap getEContextTypes() {
	return _contextualTypes;
}

	
/**
* Add action-relation object.
* If the relation previously contained an instance, the old 
* instance is replaced
* @param rel,  the name of the relation 
* @param aInstance, the instance to which the relation applies
*/
public boolean setEntityContextType(String rel, String type) {
	//26-2-2002, if it is process, it is used to instore 
	// non-imparative verb-form, then no need to do futher check
	if (rel.equals(DmRelation.ACTION_PROCESS))
	_contextualTypes.put(rel, type);
	
	
	String goodRel=actionRelation.getActionRelation(rel);
	if (!(goodRel == null)){
		if (_contextType.isContextualType(type)){
			_contextualTypes.put(goodRel, type);
			//System.out.println(type+"  is contaxt type");
		}//else 
			//System.out.println(type+"  is not contaxt type");
		//System.out.println(rel+"  is a good relation");
		return true;
	} else {
		//System.out.println(rel+"  is a bad relation");
		return false;
	}

}
	

	/**
	 * @return void
	* test the class.
	*/
	public static void main(String args[]) {
    	
		DmConcept dc1= new DmConcept("menu");
		dc1.setType("entity type");
		DmConcept dc2= new DmConcept("menuitem");
		dc2.setType("entity type");

		EntityInstance ei1= new EntityInstance ("file");
		ei1.setConceptOf(dc1);	
		
		EntityInstance ei2= new EntityInstance ("new");
		ei2.setConceptOf(dc2);
		ei2.setEntityRelation("part of",ei1);
		
		EntityInstance ei3= new EntityInstance ("open");
		ei3.setConceptOf(dc2);
		ei3.setEntityRelation("part of",ei1);
		
		EntityInstance ei4= new EntityInstance ("save");
		dc2.addInstance(ei4);
		ei4.setEntityRelation("part of",ei1);
		
		EntityInstance ei5= new EntityInstance ("somthing");
		EntityInstance ei6= new EntityInstance ("new thing");
		ei6.setConceptOf(dc1);
			
		System.out.println("DmConcept: " + DmConcept.getDefaultEntityConcept().getName()+ " of type "+ dc1.getType()+" has the following instance:");
		DmInstance dc5In[]= DmConcept.getDefaultEntityConcept().getAllInstances();
		for (int i = 0; i < dc5In.length; i++) {
    		System.out.println("     "+i+"Instance: " + dc5In[i].getName() + " " + dc5In[i].getConceptOf().getName());				
       	}  
			
			
		System.out.println("DmConcept: " + dc1.getName()+ " of type "+ dc1.getType()+" has the following instance:");
		DmInstance dc1In[]= dc1.getAllInstances();
		for (int i = 0; i < dc1In.length; i++) {
    		System.out.println("     "+i+"Instance: " + dc1In[i].getName());				
       	}  
			
		System.out.println("DmConcept: " + dc2.getName()+ " of type "+ dc2.getType()+" has the following instance:");
		DmInstance dc2In[]= dc2.getAllInstances();
		for (int i = 0; i < dc2In.length; i++) {
    		System.out.println("     "+i+"Instance: " + dc2In[i].getName()+ " " + dc2In[i].getConceptOf().getName());
    		DmRelation relM = DmRelation.getInstance();

    		String allEnRle[] = relM.getAllEntityRelations();
			TreeMap reInstances = ((EntityInstance)dc2In[i]).getEntityRelations();    
			for (int j = 0; j < allEnRle.length; j++) {
    			System.out.println("     "+allEnRle[j]+" Instance: " 
    			+((DmInstance) reInstances.get(allEnRle[j])).getName());				
       		}  

       	}  
		
		System.out.println("entity insteance: " + ei3.getName() + " of concept " + ei3.getConceptOf().getName()+ " has relations: ");
		TreeMap relationInstances = ei3.getEntityRelations();
		DmRelation relM = DmRelation.getInstance();
		String allEnRle[] = relM.getAllEntityRelations();
		for (int i = 0; i < allEnRle.length; i++) {
    		System.out.println("     "+allEnRle[i]+" Instance: " 
    			+((DmInstance) relationInstances.get(allEnRle[i])).getName());				
       	}  
       	
       	// test dm-action related stuff
       	
		DmConcept user1= new DmConcept("user");
		user1.setType("user type");
		DmConcept select1= new DmConcept("select");
		select1.setType("action type");

		EntityInstance editor= new EntityInstance ("editor");
		editor.setConceptOf(user1);	
		
		ActionInstance editorSelect1= new ActionInstance ("user select new from file menu");
		editorSelect1.setConceptOf(select1);	
		editorSelect1.setActionRelation("actor", editor);
		editorSelect1.setActionRelation("actee", ei2);
		editorSelect1.setActionRelation("source", ei1);

		ActionInstance editorSelect2= new ActionInstance ("user select save from file menu");
		select1.addInstance(editorSelect2);	
		editorSelect2.setActionRelation("actor", editor);
		editorSelect2.setActionRelation("actee", ei4);
		editorSelect2.setActionRelation("source", ei1);
		editorSelect2.setEntityContextType("source", "3d");
		
		ActionInstance ai1= new ActionInstance ("this is just a test");
		editorSelect2.setActionActRelation("purpose request",ai1);		
		// print out action related stuff
		System.out.println("action related stuff!! \n");
					
		System.out.println("DmConcept: " + DmConcept.getDefaultActionConcept().getName()+ " of type "+ " has the following instance:");
		DmInstance actionIn1[]= DmConcept.getDefaultActionConcept().getAllInstances();
		for (int i = 0; i < actionIn1.length; i++) {
    		System.out.println("     "+i+"Instance: " + actionIn1[i].getName() + " " + actionIn1[i].getConceptOf().getName());				
       	}  
		
//       	select1.setLexItem("chooSe"); 
		System.out.println("DmConcept: " + select1.getName());
		System.out.println("         : of type "+ select1.getType());
//		System.out.println("         lexical root: " + select1.getLexItem()+" has the following instance:");
		DmInstance selectIn1[]= select1.getAllInstances();
		System.out.println("     "+selectIn1.length);
    
		for (int k = 0; k < selectIn1.length; k++) {
    		System.out.println("     "+k+"Instance: " + selectIn1[k].getName());
    	
    		String allActRle[] = relM.getAllActionRelations();
		TreeMap reActInstances = ((ActionInstance)selectIn1[k]).getActionRelations();    
		TreeMap contexttypes = ((ActionInstance)selectIn1[k]).getEContextTypes();    
			for (int j = 0; j < allActRle.length; j++) {
				if (reActInstances.get(allActRle[j]) != null){
    				System.out.println("     "+allActRle[j]+" Instance: " 
    					+((DmInstance) reActInstances.get(allActRle[j])).getName()+
					"    "+ ((String)contexttypes.get(allActRle[j])));				
				}
       		}  
    		
       	}  
    		
       	String allActRle[] = relM.getAllActionActRelations();
		TreeMap actActInstances = editorSelect2.getActionActRelations();    
		for (int j = 0; j < allActRle.length; j++) {
			if (actActInstances.get(allActRle[j]) != null){
				System.out.println("     "+allActRle[j]+" Instance: " 
					+((DmInstance) actActInstances.get(allActRle[j])).getName());				
			}
   		}
   		
		long l=1000;
		//String sr=l;
		String st=Long.toString(l);
		System.out.println("   "+ st);
				
    } //main()
} //calss: ActionInstance