/*
   Tamot --- Task Modelling Editor
   Copyright (C) 2000 Commonwealth Scientific and Industrial Research Organisation
   (CSIRO), Australia. All rights reserved. 

   The Software, owned by CSIRO Australia, has been developed by the CSIRO 
   Intelligent Interactive Technology group. 
   For more information, please see http://www.cmis.csiro.au/iit/.

   The Software is a beta-test version for internal research and evaluation purposes 
   by the Licensee. The Software is still at a development stage. 
   It has not undergone complete testing and may have inherent errors,
   bugs or deficiencies that can affect the operation of the Software. 

   We encourage your feedback and suggestions. Any bugs / suggestions found please email to
   Shijian.Lu@cmis.csiro.au and Thomas.Lo@cmis.csiro.au. 

   After you have signed the Beta-Test Software License Agreement with the CSIRO,
   CSIRO grants you a non-exclusive, non-transferable license to use it only for your 
   personal, non-commercial and lawful end use. Implied licenses are negated. 

   Warranty Disclaimer : 

   CSIRO supplies the Software on an "as is" basis and makes no warranties that use of
   the Software by the Licensee will not infringe any third partys 
   Intellectual Property Rights nor that the Software will be of merchantable quality,
   or suitable for a particular purpose. CSIRO excludes all terms, conditions and
   warranties implied by custom, the general law or statute in relation to the
   Software.
*/

/* a patched version of a link listener taken from JavaWorld, Jan, 1999
   (http://www.idg.net/crd_browser_68453.html).

   kvlinden, 10Feb00
*/

/*
 * SimpleLinkListener.java
 * A hyperlink listener for use with JEditorPane.  This
 * listener will change the cursor over hotspots based on enter/exit
 * events and also load a new page when a valid hyperlink is clicked.
 */

package TV;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;

import taskModellingTool.Manager;

public class SimpleLinkListener implements HyperlinkListener 
{

    private JEditorPane pane;       // The pane we're using to display HTML

    private JTextField  urlField;   // An optional textfield for showing
    // the current URL being displayed

    private JLabel statusBar;       // An option label for showing where
    // a link would take you

    public SimpleLinkListener(JEditorPane jep, JTextField jtf, JLabel jl) {
	pane = jep;
	urlField = jtf;
	statusBar = jl;
    }

    public SimpleLinkListener(JEditorPane jep) {
	this(jep, null, null);
    }

    public void hyperlinkUpdate(HyperlinkEvent he) {

	HyperlinkEvent.EventType type = he.getEventType();

	// Ok.  Decide which event we got...
	if (type == HyperlinkEvent.EventType.ENTERED) {
	    // Enter event.  Go the the "hand" cursor and fill in the status bar
	    if (he.getDescription().startsWith("action:") ||
		he.getDescription().startsWith("text:"))
		pane.setCursor(Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
	    else
		pane.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
	    statusBar.setText("click to edit " + he.getDescription());
	}
	else if (type == HyperlinkEvent.EventType.EXITED) {
	    // Exit event.  Go back to the default cursor and clear the status bar
	    pane.setCursor(Cursor.getDefaultCursor());
	    statusBar.setText(" ");
	}
	else {
	    // Jump event.  Get the url, and if it's not null, switch to that
	    // page in the main editor pane and update the "site url" label.
	    try {
		System.out.println(he.getDescription());
		// deal with isolde protocols first - kvlinden, 10feb00
		if (he.getDescription().startsWith("action:")){
		    // This should edit the DM object he.getDescription().substring(7)
			String ObjAction= he.getDescription();
			System.out.println(ObjAction.substring(7));
			String dmAction=ObjAction.substring(7).toLowerCase();
			String dmAction1=replaceDashSpace1(dmAction);
			Manager.dmManager.editActionFromHTMLview(dmAction1);

			//	Manager.dmManager.editActionFromHTMLview(ObjAction.substring(7));
		    //Manager.domainDialog();
		} else if (he.getDescription().startsWith("text:"))
		    // This should edit the DM object he.getDescription().substring(5)
		    Manager.domainDialog();
		else
		    try {
			pane.setPage(he.getURL());
			if (urlField != null) {
			    urlField.setText(he.getURL().toString());
			}
		    } catch(Exception e) {
			statusBar.setText("Could not find file " + he.getURL());
		    }
	    }
	    catch (Exception e) {
		e.printStackTrace();
	    }
	}
    }
    
    /** 
    * this method replaces the first occurence of dash (-),
    * in the string "input" with a space ( ). And return the resulting string
    *
    *
    */
	public String replaceDashSpace1(String input){
		StringBuffer sBuff= new StringBuffer(input.length()) ;
		char sp=' ';
		int counter=0, counterM=1; 	// count how many dash to be replaced
		for (int i=0; i<input.length(); i++){
			char c=input.charAt(i);
			sBuff.append(c);
			if (c =='-' &&  counter < counterM) {
				sBuff.setCharAt(i,sp);
				counter++;
			}
			
			
		}
		return ((String)sBuff.toString());
	}
	

}