/*
 * Decompiled with CFR 0.152.
 */
package jwnl.util;

import java.util.Hashtable;
import jwnl.util.Cache;

public class LRUCache
implements Cache {
    protected int capacity;
    protected Hashtable map;
    protected Hashtable keys;
    protected Hashtable ages;
    protected int oldest = 0;
    protected int youngest = 0;

    public LRUCache(int capacity) {
        this.capacity = capacity;
        this.keys = new Hashtable(capacity);
        this.ages = new Hashtable(capacity);
        this.map = new Hashtable(capacity);
    }

    public synchronized void put(Object key, Object value) {
        if (this.map.containsKey(key)) {
            this.makeMostRecentlyUsed(key);
        } else {
            this.removeLeastUsed();
            this.map.put(key, value);
            Integer age = new Integer(++this.youngest);
            this.keys.put(key, age);
            this.ages.put(age, key);
        }
    }

    public synchronized Object get(Object key) {
        Object value = this.map.get(key);
        if (value != null) {
            this.makeMostRecentlyUsed(key);
        }
        return value;
    }

    protected synchronized void makeMostRecentlyUsed(Object key) {
        Integer age = this.getAgeOf(key);
        if (age != null) {
            this.ages.remove(age);
        }
        age = new Integer(++this.youngest);
        this.keys.put(key, age);
        this.ages.put(age, key);
    }

    protected synchronized void removeLeastUsed() {
        if (this.isFull()) {
            try {
                this.remove(this.getOldestKey());
            }
            catch (NullPointerException ex) {
                this.repair();
            }
        }
    }

    protected void repair() {
        if (this.oldest == 0 && this.youngest == 0) {
            this.clear();
        } else if (this.oldest > this.youngest) {
            this.resetOldest(0);
        }
    }

    public boolean isEmpty() {
        return this.oldest == 0 && this.youngest == 0 || this.oldest > this.youngest;
    }

    public boolean isFull() {
        return this.map.size() >= this.capacity;
    }

    public synchronized void remove(Object key) {
        this.map.remove(key);
        this.keys.remove(key);
        Integer age = this.getAgeOf(key);
        if (age != null) {
            this.ages.remove(age);
        }
        this.resetOldest();
    }

    public synchronized void clear() {
        this.keys.clear();
        this.ages.clear();
        this.map.clear();
        this.youngest = 0;
        this.oldest = 0;
    }

    public synchronized Object getOldest() {
        Object key = this.getOldestKey();
        if (key == null) {
            return null;
        }
        return this.get(key);
    }

    public synchronized Object getOldestKey() {
        return this.resetOldest();
    }

    protected synchronized Object resetOldest() {
        return this.resetOldest(this.oldest);
    }

    protected synchronized Object resetOldest(int start) {
        Object key = null;
        this.oldest = start;
        while (key == null && this.oldest <= this.youngest) {
            key = this.ages.get(new Integer(++this.oldest));
        }
        return key;
    }

    public synchronized Object getYoungest() {
        Object key = this.getYoungestKey();
        if (key == null) {
            return null;
        }
        return this.get(key);
    }

    public synchronized Object getYoungestKey() {
        return this.ages.get(new Integer(this.youngest));
    }

    protected synchronized Integer getAgeOf(Object key) {
        return (Integer)this.keys.get(key);
    }
}

