/*
 * Decompiled with CFR 0.152.
 */
package jwnl.dictionary.flatfile;

import java.io.IOException;
import java.io.RandomAccessFile;
import jwnl.dictionary.file.DictionaryCatalogSet;
import jwnl.dictionary.file.random_access.RandomAccessDictionaryCatalogSet;
import jwnl.dictionary.file.random_access.RandomAccessDictionaryFile;
import jwnl.dictionary.flatfile.FileManagerInterface;
import jwnl.util.SystemInfo;

public class FileManager
implements FileManagerInterface {
    protected RandomAccessDictionaryCatalogSet files;

    public FileManager() {
        this(SystemInfo.getWNSearchDir());
    }

    public FileManager(String searchDirectory) {
        this.files = new RandomAccessDictionaryCatalogSet(searchDirectory);
        this.files.open();
    }

    public RandomAccessDictionaryFile getFile(Object catKey, Object fileKey) {
        return (RandomAccessDictionaryFile)this.files.getDictionaryFile(catKey, fileKey);
    }

    public void close() {
        this.files.close();
    }

    public DictionaryCatalogSet getFiles() {
        return this.files;
    }

    /*
     * WARNING - void declaration
     */
    protected String readLine(RandomAccessFile stream) throws IOException {
        if (SystemInfo.isMetrowerksVM()) {
            int c;
            StringBuffer input = new StringBuffer();
            while ((c = stream.read()) != -1 && c != 10 && c != 13) {
                void var3_3;
                input.append((char)var3_3);
            }
            if (c == -1 && input.length() == 0) {
                return null;
            }
            return input.toString();
        }
        return stream.readLine();
    }

    protected void skipLine(RandomAccessFile stream) throws IOException {
        int c;
        while ((c = stream.read()) != -1 && c != 10 && c != 13) {
        }
        c = stream.read();
        if (c != 10 && c != 13) {
            stream.seek(stream.getFilePointer() - 1L);
        }
    }

    public String readLineAt(Object catKey, Object fileKey, long offset) throws IOException {
        RandomAccessFile stream;
        RandomAccessDictionaryFile file = this.getFile(catKey, fileKey);
        RandomAccessFile randomAccessFile = stream = file.getFile();
        synchronized (randomAccessFile) {
            stream.seek(offset);
            String line = this.readLine(stream);
            long nextOffset = stream.getFilePointer();
            if (line == null) {
                nextOffset = -1L;
            }
            file.setNextLineOffset(offset, nextOffset);
            String string = line;
            return string;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected String readLineWord(RandomAccessFile stream) throws IOException {
        int c;
        StringBuffer input = new StringBuffer();
        while ((c = stream.read()) != -1 && c != 10 && c != 13 && c != 32) {
            void var3_3;
            input.append((char)var3_3);
        }
        return input.toString();
    }

    public long getNextLinePointer(Object catKey, Object fileKey, long offset) throws IOException {
        RandomAccessFile stream;
        RandomAccessDictionaryFile file = this.getFile(catKey, fileKey);
        RandomAccessFile randomAccessFile = stream = file.getFile();
        synchronized (randomAccessFile) {
            if (file.matchingOffset(offset)) {
                long l = file.getNextOffset();
                return l;
            }
            stream.seek(offset);
            this.skipLine(stream);
            long l = stream.getFilePointer();
            return l;
        }
    }

    public long getMatchingLinePointer(Object catKey, Object fileKey, long offset, String substring) throws IOException {
        RandomAccessFile stream;
        RandomAccessDictionaryFile file = this.getFile(catKey, fileKey);
        RandomAccessFile randomAccessFile = stream = file.getFile();
        synchronized (randomAccessFile) {
            stream.seek(offset);
            while (true) {
                String line = this.readLineWord(stream);
                long nextOffset = stream.getFilePointer();
                if (line == null) {
                    long l = -1L;
                    return l;
                }
                file.setNextLineOffset(offset, nextOffset);
                if (line.indexOf(substring) >= 0) {
                    long l = offset;
                    return l;
                }
                offset = nextOffset;
            }
        }
    }

    public long getIndexedLinePointer(Object catKey, Object fileKey, String target) throws IOException {
        RandomAccessDictionaryFile file = this.getFile(catKey, fileKey);
        RandomAccessFile stream = file.getFile();
        if (stream.length() == 0L) {
            return -1L;
        }
        RandomAccessFile randomAccessFile = stream;
        synchronized (randomAccessFile) {
            long start = 0L;
            long stop = stream.length();
            long offset = start;
            while (true) {
                String word;
                long midpoint = (start + stop) / 2L;
                stream.seek(midpoint);
                stream.readLine();
                offset = stream.getFilePointer();
                if (stop == offset) {
                    stream.seek(start);
                    offset = stream.getFilePointer();
                    while (offset != stop) {
                        word = this.readLineWord(stream);
                        if (word.equals(target)) {
                            long l = offset;
                            return l;
                        }
                        stream.readLine();
                        offset = stream.getFilePointer();
                    }
                    long l = -1L;
                    return l;
                }
                word = this.readLineWord(stream);
                int compare = word.compareTo(target);
                if (compare == 0) {
                    long l = offset;
                    return l;
                }
                if (compare > 0) {
                    stop = offset;
                    continue;
                }
                start = offset;
            }
        }
    }
}

