/*
 * Decompiled with CFR 0.152.
 */
package jwnl.dictionary.flatfile;

import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import jwnl.data.Exc;
import jwnl.data.IndexWord;
import jwnl.data.POS;
import jwnl.data.Synset;
import jwnl.dictionary.DictionaryDatabase;
import jwnl.dictionary.DictionaryLookupException;
import jwnl.dictionary.flatfile.FileLookaheadEnumeration;
import jwnl.dictionary.flatfile.FileManager;
import jwnl.dictionary.flatfile.FileManagerInterface;
import jwnl.util.LookaheadEnumeration;

public class FileBackedDictionary
extends DictionaryDatabase {
    protected static final Integer INDEX = new Integer(0);
    protected static final Integer SYNSET = new Integer(1);
    protected static final Integer EXCEPTION = new Integer(2);
    protected final FileManagerInterface db;

    public FileBackedDictionary(FileManagerInterface fileManager, boolean enableCaching) {
        super(enableCaching);
        this.db = fileManager;
    }

    public FileBackedDictionary(FileManagerInterface fileManager) {
        this(fileManager, true);
    }

    public FileBackedDictionary() {
        this(new FileManager());
    }

    public FileBackedDictionary(boolean enableCaching) {
        this(new FileManager(), enableCaching);
    }

    public FileBackedDictionary(String searchDirectory) {
        this(new FileManager(searchDirectory));
    }

    public void close() {
        this.db.close();
    }

    public FileManagerInterface getFileManager() {
        return this.db;
    }

    protected IndexWord getIndexWordAt(POS pos, long offset) {
        String line;
        try {
            line = this.db.readLineAt(pos, INDEX, offset);
        }
        catch (IOException e) {
            throw new DictionaryLookupException(e.toString());
        }
        IndexWord word = IndexWord.parseIndexWord(this, line);
        if (this.cachingEnabled()) {
            this.cacheIndexWord(new DictionaryDatabase.DatabaseKey(pos, new Long(offset)), word);
        }
        return word;
    }

    public Synset getSynsetAt(POS pos, long offset, String line) {
        Synset synset = null;
        DictionaryDatabase.DatabaseKey key = null;
        if (this.cachingEnabled()) {
            key = new DictionaryDatabase.DatabaseKey(pos, new Long(offset));
            synset = this.lookupCachedSynset(key);
        }
        if (synset == null) {
            if (line == null) {
                try {
                    line = this.db.readLineAt(pos, SYNSET, offset);
                }
                catch (IOException e) {
                    throw new DictionaryLookupException(e.toString());
                }
            }
            synset = Synset.parseSynset(this, line);
            if (this.cachingEnabled()) {
                this.cacheSynset(key, synset);
            }
        }
        return synset;
    }

    public Synset getSynsetAt(POS pos, long offset) {
        return this.getSynsetAt(pos, offset, null);
    }

    public IndexWord lookupIndexWord(POS pos, String string) {
        IndexWord word = null;
        DictionaryDatabase.DatabaseKey key = null;
        if (this.cachingEnabled()) {
            key = new DictionaryDatabase.DatabaseKey(pos, string);
            word = this.lookupCachedIndexWord(key);
        }
        if (word == null) {
            long offset;
            try {
                offset = this.db.getIndexedLinePointer(pos, INDEX, string.toLowerCase().replace(' ', '_'));
            }
            catch (IOException e) {
                throw new DictionaryLookupException(e.toString());
            }
            if (offset >= 0L) {
                word = this.getIndexWordAt(pos, offset);
            }
            if (word != null && this.cachingEnabled()) {
                this.cacheIndexWord(key, word);
            }
        }
        return word;
    }

    public Exc lookupExceptions(POS pos, String derivation) {
        Exc exc = new Exc(derivation);
        try {
            String line;
            long offset = this.db.getIndexedLinePointer(pos, EXCEPTION, derivation.toLowerCase().replace(' ', '_'));
            if (offset >= 0L && (line = this.db.readLineAt(pos, EXCEPTION, offset)) != null) {
                StringTokenizer st = new StringTokenizer(line.substring(line.indexOf(32) + 1));
                while (st.hasMoreTokens()) {
                    String temp = st.nextToken().replace('_', ' ');
                    exc.add(temp);
                }
            }
        }
        catch (IOException e) {
            throw new DictionaryLookupException(e.toString());
        }
        return exc;
    }

    public Enumeration searchIndexWords(final POS pos, final String substring) {
        return new LookaheadEnumeration(new Enumeration(){
            protected long nextOffset = 0L;

            public boolean hasMoreElements() {
                return true;
            }

            public Object nextElement() {
                try {
                    long offset = FileBackedDictionary.this.db.getMatchingLinePointer(pos, INDEX, this.nextOffset, substring);
                    if (offset >= 0L) {
                        IndexWord value = null;
                        if (FileBackedDictionary.this.cachingEnabled()) {
                            value = FileBackedDictionary.super.lookupCachedIndexWord(new DictionaryDatabase.DatabaseKey(pos, new Long(offset)));
                        }
                        if (value == null) {
                            value = FileBackedDictionary.this.getIndexWordAt(pos, offset);
                        }
                        this.nextOffset = FileBackedDictionary.this.db.getNextLinePointer(pos, INDEX, offset);
                        return value;
                    }
                    throw new NoSuchElementException();
                }
                catch (IOException e) {
                    throw new DictionaryLookupException(e.toString());
                }
            }
        });
    }

    public Enumeration indexWords(POS pos) {
        final FileBackedDictionary dict = this;
        return new FileLookaheadEnumeration(pos, INDEX, this.db){

            protected Object parseLine(long offset, String line) {
                return IndexWord.parseIndexWord(dict, line);
            }
        };
    }

    public Enumeration synsets(final POS pos) {
        return new FileLookaheadEnumeration(pos, SYNSET, this.db){

            protected Object parseLine(long offset, String line) {
                return FileBackedDictionary.this.getSynsetAt(pos, offset, line);
            }
        };
    }

    public Enumeration exceptions(POS pos) {
        return new FileLookaheadEnumeration(pos, EXCEPTION, this.db){

            protected Object parseLine(long offset, String line) {
                String testLine;
                StringTokenizer tokenizer = new StringTokenizer(line);
                String lemma = tokenizer.nextToken().replace('_', ' ');
                String exception = tokenizer.nextToken().replace('_', ' ');
                Exc exc = new Exc(lemma);
                exc.add(exception);
                while ((testLine = this.readLine()) != null) {
                    tokenizer = new StringTokenizer(testLine);
                    String testLemma = tokenizer.nextToken().replace('_', ' ');
                    String testException = tokenizer.nextToken().replace('_', ' ');
                    if (!lemma.equals(testLemma)) break;
                    exc.add(testException);
                    this.nextOffset();
                }
                return exc;
            }
        };
    }
}

