/*
 * Decompiled with CFR 0.152.
 */
package jwnl.dictionary.file.random_access;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import jwnl.data.POS;
import jwnl.dictionary.file.DefaultDictionaryFile;
import jwnl.dictionary.file.DictionaryFileException;

public class RandomAccessDictionaryFile
extends DefaultDictionaryFile {
    protected RandomAccessFile file = null;
    protected long previousOffset;
    protected long nextOffset;

    public RandomAccessDictionaryFile(POS pos, int fileType) {
        super(pos, fileType);
    }

    public RandomAccessFile getFile() {
        return this.file;
    }

    public String readLine() throws IOException {
        if (this.isOpen()) {
            return this.file.readLine();
        }
        throw new DictionaryFileException("File is not open for reading.");
    }

    public void seek(long pos) throws IOException {
        this.file.seek(pos);
    }

    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    public boolean isOpen() {
        return this.file != null;
    }

    public void close() {
        try {
            this.file.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.file = null;
    }

    protected void openFile(String path, Object obj) throws FileNotFoundException {
        this.file = new RandomAccessFile(path, "rw");
    }

    public void setNextLineOffset(long previousOffset, long nextOffset) {
        this.previousOffset = previousOffset;
        this.nextOffset = nextOffset;
    }

    public boolean matchingOffset(long offset) {
        return this.previousOffset == offset;
    }

    public long getNextOffset() {
        return this.nextOffset;
    }
}

