/*
 * Decompiled with CFR 0.152.
 */
package jwnl.dictionary.file;

import java.io.FileNotFoundException;
import jwnl.data.POS;
import jwnl.dictionary.file.DictionaryFileException;
import jwnl.util.SystemInfo;

public abstract class DictionaryFile {
    protected POS pos;
    protected String filename;
    protected int fileType;
    protected int size;

    public DictionaryFile(POS pos, int fileType) {
        this(pos, fileType, -1);
    }

    public DictionaryFile(POS pos, int fileType, int size) {
        this.pos = pos;
        this.fileType = fileType;
        this.size = size;
        this.filename = this.makeFilename(pos, fileType);
    }

    public abstract String makeFilename(POS var1, int var2);

    public abstract void close();

    public abstract boolean isOpen();

    protected abstract void openFile(String var1, Object var2) throws FileNotFoundException;

    public Object getKey() {
        return new Integer(this.fileType);
    }

    public POS getPOS() {
        return this.pos;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int s) {
        this.size = s;
    }

    public int getFileType() {
        return this.fileType;
    }

    public void open(String path, Object obj) {
        if (!this.isOpen()) {
            if (!path.equals("") && !path.endsWith(SystemInfo.getFileSeparator())) {
                path = path + SystemInfo.getFileSeparator();
            }
            try {
                this.openFile(path + this.getFilename(), obj);
            }
            catch (Throwable t) {
                throw new DictionaryFileException(t.toString());
            }
        }
    }

    public void open(String path) {
        this.open(path, null);
    }
}

