/*
 * Decompiled with CFR 0.152.
 */
package jwnl.data.relationship;

import java.util.Vector;
import jwnl.data.relationship.Relationship;

public class RelationshipList {
    protected Vector relationships = new Vector();
    protected int shallowestIndex = -1;
    protected int deepestIndex = -1;

    public synchronized void add(Relationship r) {
        if (r.getDepth() < this.shallowestIndex) {
            this.shallowestIndex = this.relationships.size();
        }
        if (r.getDepth() > this.deepestIndex) {
            this.deepestIndex = this.relationships.size();
        }
        this.relationships.addElement(r);
    }

    public int size() {
        return this.relationships.size();
    }

    public Relationship get(int index) {
        return (Relationship)this.relationships.elementAt(index);
    }

    public Relationship getShallowest() {
        if (this.shallowestIndex >= 0) {
            return this.get(this.shallowestIndex);
        }
        return null;
    }

    public Relationship getDeepest() {
        if (this.deepestIndex >= 0) {
            return this.get(this.deepestIndex);
        }
        return null;
    }

    public Relationship[] toArray() {
        Object[] r = new Relationship[this.relationships.size()];
        this.relationships.copyInto(r);
        return r;
    }

    public void remove(int index) {
        this.relationships.remove(index);
    }
}

