/*
 * Decompiled with CFR 0.152.
 */
package jwnl.data.relationship;

import java.util.Vector;
import jwnl.data.IndexWord;
import jwnl.data.PointerTarget;
import jwnl.data.PointerType;
import jwnl.data.Synset;
import jwnl.data.list.pointer_target.PointerTargetList;
import jwnl.data.list.pointer_target.PointerTargetListNode;
import jwnl.data.list.pointer_target.PointerTargetTree;
import jwnl.data.list.pointer_target.PointerTargetTreeListOperation;
import jwnl.data.list.pointer_target.PointerTargetTreeNode;
import jwnl.data.relationship.RelationshipList;

public class Relationship {
    public static final int INFINITY = Integer.MAX_VALUE;
    protected PointerTargetList nodes;
    protected int commonParentIndex;
    protected IndexWord sourceWord;
    protected IndexWord targetWord;
    protected int sourceSense;
    protected int targetSense;
    protected int relativeTargetDepth = Integer.MAX_VALUE;
    protected int absoluteTargetDepth = Integer.MAX_VALUE;
    public static final int DEFAULT_ASYMMETRIC_SEARCH_DEPTH = Integer.MAX_VALUE;
    public static final int DEFAULT_SYMMETRIC_SEARCH_DEPTH = 2;

    public Relationship(PointerTargetList nodes, int commonParentIndex, IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense) {
        this.nodes = nodes;
        this.commonParentIndex = commonParentIndex;
        if (nodes != null) {
            this.relativeTargetDepth = this.calculateRelativeTargetDepth();
            this.absoluteTargetDepth = this.calculateAbsoluteTargetDepth();
        }
        this.sourceWord = sourceWord;
        this.targetWord = targetWord;
        this.sourceSense = sourceSense;
        this.targetSense = targetSense;
    }

    public Relationship(Relationship r) {
        this(r.getNodeList(), r.getCommonParentIndex(), r.getSourceWord(), r.getSourceSense(), r.getTargetWord(), r.getTargetSense());
    }

    public Relationship(PointerTargetList nodes, int commonParentIndex, Relationship r) {
        this(nodes, commonParentIndex, r.getSourceWord(), r.getSourceSense(), r.getTargetWord(), r.getTargetSense());
    }

    public Relationship(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense) {
        this(null, 0, sourceWord, sourceSense, targetWord, targetSense);
    }

    public Relationship(PointerTargetList nodes, int commonParentIndex) {
        this(nodes, commonParentIndex, null, 0, null, 0);
    }

    protected int calculateRelativeTargetDepth() {
        int distSourceToParent = this.commonParentIndex;
        int distParentToTarget = this.nodes.size() - 1 - this.commonParentIndex;
        return distParentToTarget - distSourceToParent;
    }

    protected int calculateAbsoluteTargetDepth() {
        return this.nodes.size() - 1;
    }

    public PointerTargetList getNodeList() {
        return this.nodes;
    }

    public PointerTarget getSourcePointerTarget() {
        return this.nodes.getFirst().getPointerTarget();
    }

    public PointerTarget getTargetPointerTarget() {
        return this.nodes.getLast().getPointerTarget();
    }

    public int getCommonParentIndex() {
        return this.commonParentIndex;
    }

    public void print() {
        this.nodes.print();
    }

    public int getDepth() {
        return this.getAbsoluteTargetDepth();
    }

    public int getRelativeTargetDepth() {
        return this.relativeTargetDepth;
    }

    public int getAbsoluteTargetDepth() {
        return this.absoluteTargetDepth;
    }

    public IndexWord getSourceWord() {
        return this.sourceWord;
    }

    public IndexWord getTargetWord() {
        return this.targetWord;
    }

    public int getSourceSense() {
        return this.sourceSense;
    }

    public int getTargetSense() {
        return this.targetSense;
    }

    public static RelationshipList findHypernymRelationships(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense) {
        return Relationship.findHypernymRelationships(sourceWord, sourceSense, targetWord, targetSense, Integer.MAX_VALUE);
    }

    public static RelationshipList findHypernymRelationships(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense, int depth) {
        return Relationship.findAsymmetricRelationships(sourceWord, sourceSense, targetWord, targetSense, PointerType.HYPERNYM, depth);
    }

    public static RelationshipList findHyponymRelationships(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense) {
        return Relationship.findHyponymRelationships(sourceWord, sourceSense, targetWord, targetSense, Integer.MAX_VALUE);
    }

    public static RelationshipList findHyponymRelationships(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense, int depth) {
        return Relationship.findAsymmetricRelationships(sourceWord, sourceSense, targetWord, targetSense, PointerType.HYPONYM, depth);
    }

    public static RelationshipList findEntailmentRelationships(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense) {
        return Relationship.findEntailmentRelationships(sourceWord, sourceSense, targetWord, targetSense, Integer.MAX_VALUE);
    }

    public static RelationshipList findEntailmentRelationships(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense, int depth) {
        return Relationship.findAsymmetricRelationships(sourceWord, sourceSense, targetWord, targetSense, PointerType.ENTAILMENT, depth);
    }

    public static RelationshipList findEntailedByRelationships(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense) {
        return Relationship.findEntailedByRelationships(sourceWord, sourceSense, targetWord, targetSense, Integer.MAX_VALUE);
    }

    public static RelationshipList findEntailedByRelationships(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense, int depth) {
        return Relationship.findAsymmetricRelationships(sourceWord, sourceSense, targetWord, targetSense, PointerType.ENTAILED_BY, depth);
    }

    public static RelationshipList findSynonymRelationships(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense) {
        return Relationship.findSynonymRelationships(sourceWord, sourceSense, targetWord, targetSense, 2);
    }

    public static RelationshipList findSynonymRelationships(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense, int depth) {
        return Relationship.findSymmetricRelationships(sourceWord, sourceSense, targetWord, targetSense, PointerType.SIMILAR_TO, depth);
    }

    public static RelationshipList findAntonymRelationships(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense) {
        return Relationship.findAntonymRelationships(sourceWord, sourceSense, targetWord, targetSense, 2);
    }

    public static RelationshipList findAntonymRelationships(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense, int depth) {
        return Relationship.findSymmetricRelationships(sourceWord, sourceSense, targetWord, targetSense, PointerType.ANTONYM, depth);
    }

    public static int getImmediateRelationship(IndexWord sourceWord, IndexWord targetWord) {
        Synset[] senses = sourceWord.getSenses();
        String lemma = targetWord.getLemma();
        int i = 0;
        while (i < senses.length) {
            if (senses[i].containsWord(lemma)) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    public static RelationshipList findAsymmetricRelationships(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense, PointerType type) {
        return Relationship.findAsymmetricRelationships(sourceWord, sourceSense, targetWord, targetSense, type, Integer.MAX_VALUE);
    }

    public static RelationshipList findAsymmetricRelationships(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense, PointerType type, int depth) {
        PointerTargetList[] sourceRelations = sourceWord.makeTree(sourceSense, type, null, depth).reverse();
        PointerTargetList[] targetRelations = targetWord.makeTree(targetSense, type, null, depth).reverse();
        PointerTargetListNode[][] sourceRelationNodes = new PointerTargetListNode[sourceRelations.length][];
        PointerTargetListNode[][] targetRelationNodes = new PointerTargetListNode[targetRelations.length][];
        int i = 0;
        while (i < sourceRelations.length) {
            sourceRelationNodes[i] = sourceRelations[i].toArray();
            ++i;
        }
        i = 0;
        while (i < targetRelations.length) {
            targetRelationNodes[i] = targetRelations[i].toArray();
            ++i;
        }
        RelationshipList relationships = new RelationshipList();
        Relationship commonVals = new Relationship(sourceWord, sourceSense, targetWord, targetSense);
        i = 0;
        while (i < sourceRelations.length) {
            int j = 0;
            while (j < targetRelations.length) {
                Relationship relationship = Relationship.findAsymmetricRelationship(sourceRelationNodes[i], targetRelationNodes[j], commonVals, type);
                if (relationship != null) {
                    relationships.add(relationship);
                }
                ++j;
            }
            ++i;
        }
        return relationships;
    }

    public static Relationship findAsymmetricRelationship(PointerTargetListNode[] sourceNodes, PointerTargetListNode[] targetNodes, Relationship r, PointerType type) {
        PointerTargetList relationship = null;
        if (sourceNodes[0].getSynset().equals(targetNodes[0].getSynset())) {
            relationship = new PointerTargetList();
            int i = 1;
            while (i < sourceNodes.length && i < targetNodes.length && sourceNodes[i].getSynset().equals(targetNodes[i].getSynset())) {
                ++i;
            }
            int commonParentIndex = i - 1;
            if (i >= sourceNodes.length) {
                int j = commonParentIndex;
                while (j < targetNodes.length) {
                    targetNodes[j].setType(type.getSymmetricType());
                    relationship.add(targetNodes[j]);
                    ++j;
                }
            } else {
                int j = sourceNodes.length - 1;
                while (j >= commonParentIndex) {
                    relationship.add(sourceNodes[j]);
                    --j;
                }
                if (i < targetNodes.length) {
                    j = i;
                    while (j < targetNodes.length) {
                        targetNodes[j].setType(type.getSymmetricType());
                        relationship.add(targetNodes[j]);
                        ++j;
                    }
                }
            }
            return new Relationship(relationship, commonParentIndex, r);
        }
        return null;
    }

    public static RelationshipList findSymmetricRelationships(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense, PointerType type) {
        return Relationship.findSymmetricRelationships(sourceWord, sourceSense, targetWord, targetSense, type, 2);
    }

    public static RelationshipList findSymmetricRelationships(IndexWord sourceWord, int sourceSense, IndexWord targetWord, int targetSense, PointerType type, int depth) {
        PointerTargetTree tree = sourceWord.makeTree(sourceSense, type, null, depth, false);
        final Synset target = targetWord.getSense(targetSense);
        PointerTargetTreeListOperation opr = new PointerTargetTreeListOperation(){

            public Object execute(PointerTargetTreeNode testNode) {
                if (target.equals(testNode.getPointerTarget())) {
                    return testNode;
                }
                return null;
            }
        };
        Vector v = tree.getAllMatches(opr);
        RelationshipList list = new RelationshipList();
        Relationship r = new Relationship(sourceWord, sourceSense, targetWord, targetSense);
        int i = 0;
        while (i < v.size()) {
            list.add(Relationship.findSymmetricRelationship((PointerTargetTreeNode)v.elementAt(i), r));
            ++i;
        }
        return list;
    }

    public static Relationship findSymmetricRelationship(PointerTargetTreeNode node, Relationship r) {
        PointerTargetList list = new PointerTargetList();
        Relationship.buildSymmetricRelationshipList(list, node);
        return new Relationship(list.reverseList(), 0, r);
    }

    public static void buildSymmetricRelationshipList(PointerTargetList list, PointerTargetTreeNode node) {
        if (node != null) {
            list.add(node);
            Relationship.buildSymmetricRelationshipList(list, node.getParent());
        }
    }
}

