/*
 * Decompiled with CFR 0.152.
 */
package jwnl.data.list.pointer_target;

import java.util.Vector;
import jwnl.data.list.pointer_target.FindOperation;
import jwnl.data.list.pointer_target.PointerTargetList;
import jwnl.data.list.pointer_target.PointerTargetTreeList;
import jwnl.data.list.pointer_target.PointerTargetTreeListItr;
import jwnl.data.list.pointer_target.PointerTargetTreeListOperation;
import jwnl.data.list.pointer_target.PointerTargetTreeNode;

public class PointerTargetTree {
    protected PointerTargetTreeNode rootNode;

    public PointerTargetTree(PointerTargetTreeNode rootNode) {
        this.rootNode = rootNode;
    }

    public PointerTargetTreeNode getRootNode() {
        return this.rootNode;
    }

    public Object getFirstMatch(PointerTargetTreeListOperation opr) {
        Object obj = opr.execute(this.rootNode);
        if (obj == null && this.rootNode.hasValidChildTreeList()) {
            obj = this.rootNode.getChildTreeList().getFirstMatch(opr);
        }
        return obj;
    }

    public Vector getAllMatches(PointerTargetTreeListOperation opr) {
        Vector<PointerTargetTreeNode> v = new Vector<PointerTargetTreeNode>();
        if (opr.execute(this.rootNode) != null) {
            v.addElement(this.rootNode);
        }
        if (this.rootNode.hasValidChildTreeList()) {
            this.rootNode.getChildTreeList().getAllMatches(opr, v);
        }
        return v;
    }

    public PointerTargetTreeNode findFirst(PointerTargetTreeNode node) {
        Object obj = this.getFirstMatch(new FindOperation(node));
        return obj == null ? null : (PointerTargetTreeNode)obj;
    }

    public PointerTargetTreeNode[] findAll(PointerTargetTreeNode node) {
        Vector v = this.getAllMatches(new FindOperation(node));
        return v.toArray(new PointerTargetTreeNode[v.size()]);
    }

    public void print() {
        if (this.rootNode != null) {
            System.out.println(this.rootNode.getPointerTarget() + " " + this.rootNode.getType());
            this.rootNode.getChildTreeList().print(2);
        }
    }

    public PointerTargetList[] reverse() {
        PointerTargetList[] lists = this.toList();
        if (lists != null) {
            PointerTargetList[] reversedLists = new PointerTargetList[lists.length];
            int i = 0;
            while (i < lists.length) {
                reversedLists[i] = lists[i].reverseList();
                ++i;
            }
            return reversedLists;
        }
        return null;
    }

    public PointerTargetList[] toList() {
        return this.toList(this.rootNode, new PointerTargetList());
    }

    protected PointerTargetList[] toList(PointerTargetTreeNode node, PointerTargetList list) {
        Object[] lists;
        if (this.rootNode == null) {
            return null;
        }
        list.add(node.getPointerTarget(), node.getType());
        if (node.hasValidChildTreeList()) {
            PointerTargetTreeList childTreeList = node.getChildTreeList();
            if (childTreeList.size() == 1) {
                return this.toList(childTreeList.getFirst(), list.getCopy());
            }
            PointerTargetTreeListItr itr = childTreeList.getIterator();
            Vector<Object> v = new Vector<Object>();
            while (itr.hasNext()) {
                lists = this.toList(itr.next(), list.getCopy());
                int i = 0;
                while (i < lists.length) {
                    v.addElement(lists[i]);
                    ++i;
                }
            }
            lists = new PointerTargetList[v.size()];
            v.copyInto(lists);
        } else {
            lists = new PointerTargetList[]{list};
        }
        return lists;
    }
}

