/*
 * Decompiled with CFR 0.152.
 */
package jwnl.data.list.pointer_target;

import jwnl.data.PointerTarget;
import jwnl.data.PointerType;
import jwnl.data.Synset;
import jwnl.data.Word;
import jwnl.data.list.Node;

public class PointerTargetListNode
implements Node {
    protected PointerTarget target;
    protected PointerType type;

    public PointerTargetListNode(PointerTarget target) {
        this(target, null);
    }

    public PointerTargetListNode(PointerTarget target, PointerType type) {
        this.target = target;
        this.type = type;
    }

    public void setType(PointerType type) {
        this.type = type;
    }

    public PointerType getType() {
        return this.type;
    }

    public PointerTarget getPointerTarget() {
        return this.target;
    }

    public boolean isLexical() {
        return this.target instanceof Word;
    }

    public Synset getSynset() {
        if (this.isLexical()) {
            return ((Word)this.target).getSynset();
        }
        return (Synset)this.target;
    }

    public Word getWord() {
        if (this.isLexical()) {
            return (Word)this.target;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (object instanceof PointerTargetListNode) {
            PointerTargetListNode node = (PointerTargetListNode)object;
            return this.getPointerTarget().equals(node.getPointerTarget()) && this.getType() == node.getType();
        }
        return false;
    }

    public String toString() {
        return "[" + this.getPointerTarget() + ", " + this.getType() + "]";
    }

    public int hashCode() {
        return this.getPointerTarget().hashCode() ^ this.getType().hashCode();
    }
}

