/*
 * Decompiled with CFR 0.152.
 */
package jwnl.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;
import jwnl.data.DictionaryElement;
import jwnl.data.POS;
import jwnl.data.Pointer;
import jwnl.data.PointerTarget;
import jwnl.data.PointerType;
import jwnl.data.SynsetException;
import jwnl.data.VerbFrame;
import jwnl.data.Word;
import jwnl.dictionary.DictionaryDatabase;
import jwnl.dictionary.file.object.DictionaryObjectInputStream;
import jwnl.util.TokenizerParser;

public class Synset
implements PointerTarget,
DictionaryElement {
    protected POS pos;
    protected long offset;
    protected boolean isAdjectiveCluster;
    protected Word[] words;
    protected Pointer[] pointers;
    protected String gloss;
    protected DictionaryDatabase db;

    public Synset(DictionaryDatabase db) {
        this.db = db;
    }

    Synset initializeFrom(String line) {
        if (line == null || line.equals("")) {
            throw new SynsetException("Cannot initialize a Synset from a null or zero-length string");
        }
        TokenizerParser tokenizer = new TokenizerParser(line, " ");
        this.offset = tokenizer.nextLong();
        tokenizer.nextToken();
        String ss_type = tokenizer.nextToken();
        this.isAdjectiveCluster = false;
        if (ss_type.equals("s")) {
            ss_type = "a";
            this.isAdjectiveCluster = true;
        }
        this.pos = POS.lookup(ss_type);
        int wordCount = tokenizer.nextHexInt();
        this.words = new Word[wordCount];
        int i = 0;
        while (i < wordCount) {
            String lemma = tokenizer.nextToken();
            int id = tokenizer.nextHexInt();
            int flags = 0;
            if (lemma.charAt(lemma.length() - 1) == ')' && lemma.indexOf(40) > 0) {
                int lparen = lemma.indexOf(40);
                String marker = lemma.substring(lparen + 1, lemma.length() - 1);
                lemma = lemma.substring(0, lparen - 1);
                if (marker.equals("p")) {
                    flags |= 1;
                } else if (marker.equals("a")) {
                    flags |= 2;
                } else if (marker.equals("ip")) {
                    flags |= 4;
                } else {
                    throw new RuntimeException("unknown syntactic marker " + marker);
                }
            }
            this.words[i] = new Word(this, i, lemma.replace('_', ' '), flags);
            ++i;
        }
        int pointerCount = tokenizer.nextInt();
        this.pointers = new Pointer[pointerCount];
        int i2 = 0;
        while (i2 < pointerCount) {
            this.pointers[i2] = Pointer.parsePointer(this, i2, tokenizer);
            ++i2;
        }
        if (this.pos == POS.VERB) {
            int f_cnt = tokenizer.nextInt();
            int i3 = 0;
            while (i3 < f_cnt) {
                tokenizer.nextToken();
                int f_num = tokenizer.nextInt();
                int w_num = tokenizer.nextHexInt();
                if (w_num > 0) {
                    this.words[w_num - 1].setVerbFrameFlag(f_num);
                } else {
                    int j = 0;
                    while (j < this.words.length) {
                        this.words[j].setVerbFrameFlag(f_num);
                        ++j;
                    }
                }
                ++i3;
            }
        }
        this.gloss = null;
        int index = line.indexOf(124);
        if (index > 0) {
            this.gloss = line.substring(index + 2).trim();
        }
        return this;
    }

    public static Synset parseSynset(DictionaryDatabase db, String line) {
        try {
            return new Synset(db).initializeFrom(line);
        }
        catch (Exception e) {
            throw new SynsetException("Error while parsing line " + line + ": " + e.toString());
        }
    }

    public void removeUnapplicablePointers(String lemma) {
        Vector<Pointer> p = new Vector<Pointer>();
        int i = 0;
        while (i < this.pointers.length) {
            if (!this.pointers[i].isLexical() || lemma == ((Word)this.pointers[i].getSource()).getLemma()) {
                p.addElement(this.pointers[i]);
            }
            ++i;
        }
        p.copyInto(this.pointers);
    }

    public boolean equals(Object object) {
        return object instanceof Synset && ((Synset)object).pos.equals(this.pos) && ((Synset)object).offset == this.offset;
    }

    public int hashCode() {
        return this.pos.hashCode() ^ (int)this.offset;
    }

    public String toString() {
        return "[Synset " + this.offset + "@" + this.pos + ": \"" + this.getDescription() + "\"]";
    }

    public boolean containsWord(String lemma) {
        int i = 0;
        while (i < this.words.length) {
            if (this.words[i].getLemma().equals(lemma)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public POS getPOS() {
        return this.pos;
    }

    public String getGloss() {
        return this.gloss;
    }

    public Word[] getWords() {
        return this.words;
    }

    public Word getWord(int index) {
        return this.words[index];
    }

    public long getOffset() {
        return this.offset;
    }

    public DictionaryDatabase getDictionary() {
        return this.db;
    }

    public void setDictionary(DictionaryDatabase db) {
        this.db = db;
    }

    public Object getKey() {
        return new Long(this.offset);
    }

    public String[] getVerbFrames() {
        long l = 0L;
        int i = 0;
        while (i < this.words.length) {
            l |= this.words[i].getVerbFrameFlags();
            ++i;
        }
        return VerbFrame.getFrames(l);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object obj;
        in.defaultReadObject();
        if (in instanceof DictionaryObjectInputStream && (obj = ((DictionaryObjectInputStream)in).getObject()) instanceof DictionaryDatabase) {
            this.db = (DictionaryDatabase)obj;
        }
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.words.length) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(this.words[i].lemma);
            ++i;
        }
        return buffer.toString();
    }

    public String getLongDescription() {
        String description = this.getDescription();
        String gloss = this.getGloss();
        if (gloss != null) {
            description = description + " -- (" + gloss + ")";
        }
        return description;
    }

    protected static PointerTarget[] collectTargets(Pointer[] pointers) {
        PointerTarget[] targets = new PointerTarget[pointers.length];
        int i = 0;
        while (i < pointers.length) {
            targets[i] = pointers[i].getTarget();
            ++i;
        }
        return targets;
    }

    public Pointer[] getPointers() {
        return this.pointers;
    }

    public int getNumPointers() {
        return this.pointers.length;
    }

    public Pointer[] getPointers(PointerType type) {
        Vector<Pointer> vector = new Vector<Pointer>(this.pointers.length);
        int i = 0;
        while (i < this.pointers.length) {
            Pointer pointer = this.pointers[i];
            if (pointer.getType().equals(type)) {
                vector.addElement(pointer);
            }
            ++i;
        }
        return vector.toArray(new Pointer[vector.size()]);
    }

    public PointerTarget[] getTargets() {
        return Synset.collectTargets(this.getPointers());
    }

    public PointerTarget[] getTargets(PointerType type) {
        return Synset.collectTargets(this.getPointers(type));
    }
}

