/*
 * Decompiled with CFR 0.152.
 */
package jwnl.data;

import java.io.Serializable;
import java.util.NoSuchElementException;
import jwnl.data.POS;
import jwnl.util.ArrayUtilities;

public class PointerType
implements Serializable {
    protected static final int N = 1;
    protected static final int V = 2;
    protected static final int ADJ = 4;
    protected static final int ADV = 8;
    protected static final int LEXICAL = 16;
    protected static final POS[] CATS = new POS[]{POS.NOUN, POS.VERB, POS.ADJECTIVE, POS.ADVERB};
    protected static final int[] POS_MASK = new int[]{1, 2, 4, 8};
    public static final PointerType ANTONYM = new PointerType("antonym", "!", 31);
    public static final PointerType HYPERNYM = new PointerType("hypernym", "@", 3);
    public static final PointerType HYPONYM = new PointerType("hyponym", "~", 3);
    public static final PointerType ATTRIBUTE = new PointerType("attribute", "=", 5);
    public static final PointerType SEE_ALSO = new PointerType("also see", "^", 23);
    public static final PointerType ENTAILMENT = new PointerType("entailment", "*", 2);
    public static final PointerType ENTAILED_BY = new PointerType("entailed by", "?", 2);
    public static final PointerType CAUSE = new PointerType("cause", ">", 2);
    public static final PointerType VERB_GROUP = new PointerType("verb group", "$", 2);
    public static final PointerType MEMBER_HOLONYM = new PointerType("member holonym", "#m", 1);
    public static final PointerType SUBSTANCE_HOLONYM = new PointerType("substance holonym", "#s", 1);
    public static final PointerType PART_HOLONYM = new PointerType("part holonym", "#p", 1);
    public static final PointerType MEMBER_MERONYM = new PointerType("member meronym", "%m", 1);
    public static final PointerType SUBSTANCE_MERONYM = new PointerType("substance meronym", "%s", 1);
    public static final PointerType PART_MERONYM = new PointerType("part meronym", "%p", 1);
    public static final PointerType SIMILAR_TO = new PointerType("similar", "&", 4);
    public static final PointerType PARTICIPLE_OF = new PointerType("participle of", "<", 20);
    public static final PointerType DERIVED = new PointerType("derived", "\\", 28);
    public static final PointerType[] TYPES = new PointerType[]{ANTONYM, HYPERNYM, HYPONYM, ATTRIBUTE, SEE_ALSO, ENTAILMENT, ENTAILED_BY, CAUSE, VERB_GROUP, MEMBER_MERONYM, SUBSTANCE_MERONYM, PART_MERONYM, MEMBER_HOLONYM, SUBSTANCE_HOLONYM, PART_HOLONYM, SIMILAR_TO, PARTICIPLE_OF, DERIVED};
    protected String label;
    protected String key;
    protected int flags;
    protected PointerType symmetricType;

    protected static void setSymmetric(PointerType a, PointerType b) {
        a.symmetricType = b;
        b.symmetricType = a;
    }

    public static boolean isSymmetric(PointerType a) {
        return a.symmetricTo(a);
    }

    static PointerType parseKey(String key) {
        int i = 0;
        while (i < TYPES.length) {
            PointerType type = TYPES[i];
            if (type.key.equals(key)) {
                return type;
            }
            ++i;
        }
        throw new NoSuchElementException("unknown link type " + key);
    }

    protected PointerType(String label, String key, int flags) {
        this.label = label;
        this.key = key;
        this.flags = flags;
    }

    public String toString() {
        return this.label + " " + this.key + " " + this.flags;
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public boolean appliesTo(POS pos) {
        return (this.flags & POS_MASK[ArrayUtilities.indexOf(CATS, pos)]) != 0;
    }

    public boolean symmetricTo(PointerType type) {
        return this.symmetricType != null && this.symmetricType.equals(type);
    }

    public PointerType getSymmetricType() {
        return this.symmetricType;
    }

    public boolean equals(Object obj) {
        PointerType p;
        return obj instanceof PointerType && (p = (PointerType)obj).getKey().equals(this.key);
    }

    static {
        PointerType.setSymmetric(ANTONYM, ANTONYM);
        PointerType.setSymmetric(HYPERNYM, HYPONYM);
        PointerType.setSymmetric(MEMBER_MERONYM, MEMBER_HOLONYM);
        PointerType.setSymmetric(SUBSTANCE_MERONYM, SUBSTANCE_HOLONYM);
        PointerType.setSymmetric(PART_MERONYM, PART_HOLONYM);
        PointerType.setSymmetric(SIMILAR_TO, SIMILAR_TO);
        PointerType.setSymmetric(ENTAILMENT, ENTAILED_BY);
    }
}

