/*
 * Decompiled with CFR 0.152.
 */
package jwnl.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Vector;
import jwnl.data.DictionaryElement;
import jwnl.data.IndexWordException;
import jwnl.data.POS;
import jwnl.data.Pointer;
import jwnl.data.PointerTarget;
import jwnl.data.PointerType;
import jwnl.data.Synset;
import jwnl.data.list.pointer_target.PointerTargetList;
import jwnl.data.list.pointer_target.PointerTargetListItr;
import jwnl.data.list.pointer_target.PointerTargetListNode;
import jwnl.data.list.pointer_target.PointerTargetTree;
import jwnl.data.list.pointer_target.PointerTargetTreeList;
import jwnl.data.list.pointer_target.PointerTargetTreeListItr;
import jwnl.data.list.pointer_target.PointerTargetTreeNode;
import jwnl.dictionary.DictionaryDatabase;
import jwnl.dictionary.file.object.DictionaryObjectInputStream;
import jwnl.util.TokenizerParser;

public class IndexWord
implements DictionaryElement {
    protected DictionaryDatabase dictionary;
    protected POS pos;
    protected long offset;
    protected String lemma;
    protected int taggedSenseCount;
    protected int senseCount;
    protected long[] synsetOffsets;
    protected Synset[] synsets;
    public static final int INFINITY = Integer.MAX_VALUE;
    protected int DEFAULT_DEPTH = Integer.MAX_VALUE;
    protected int DEFAULT_POINTER_DEPTH = Integer.MAX_VALUE;

    public IndexWord(DictionaryDatabase dictionary) {
        this.dictionary = dictionary;
    }

    public IndexWord initializeFrom(String line) throws IndexWordException {
        if (line == null || line.equals("")) {
            throw new IndexWordException("Cannot initialize an IndexWord from a null or zero-length string");
        }
        TokenizerParser tokenizer = new TokenizerParser(line, " ");
        this.lemma = tokenizer.nextToken().replace('_', ' ');
        this.pos = POS.lookup(tokenizer.nextToken());
        tokenizer.nextToken();
        int p_cnt = tokenizer.nextInt();
        int i = 0;
        while (i < p_cnt) {
            tokenizer.nextToken();
            ++i;
        }
        this.senseCount = tokenizer.nextInt();
        this.taggedSenseCount = tokenizer.nextInt();
        this.synsetOffsets = new long[this.senseCount];
        int i2 = 0;
        while (i2 < this.senseCount) {
            this.synsetOffsets[i2] = tokenizer.nextLong();
            ++i2;
        }
        return this;
    }

    public static IndexWord parseIndexWord(DictionaryDatabase dictionary, String line) throws IndexWordException {
        try {
            return new IndexWord(dictionary).initializeFrom(line);
        }
        catch (Exception e) {
            throw new IndexWordException("Error while parsing line " + line + ": " + e.toString());
        }
    }

    public boolean equals(Object object) {
        return object instanceof IndexWord && ((IndexWord)object).pos.equals(this.pos) && ((IndexWord)object).offset == this.offset;
    }

    public int hashCode() {
        return this.lemma.hashCode() ^ this.pos.hashCode();
    }

    public String toString() {
        return "[IndexWord " + this.offset + "@" + this.pos.getLabel() + ": \"" + this.lemma + "\"]";
    }

    public POS getPOS() {
        return this.pos;
    }

    public String getLemma() {
        return this.lemma;
    }

    public long getOffset() {
        return this.offset;
    }

    public long[] getSynsetOffsets() {
        return this.synsetOffsets;
    }

    public Object getKey() {
        return this.lemma;
    }

    public int getTaggedSenseCount() {
        return this.taggedSenseCount;
    }

    public int getSenseCount() {
        return this.senseCount;
    }

    public DictionaryDatabase getDictionary() {
        return this.dictionary;
    }

    public void setDictionary(DictionaryDatabase db) {
        this.dictionary = db;
    }

    public Synset[] getSenses() {
        if (this.synsets == null) {
            this.synsets = new Synset[this.synsetOffsets.length];
            int i = 0;
            while (i < this.synsetOffsets.length) {
                this.synsets[i] = this.dictionary.getSynsetAt(this.pos, this.synsetOffsets[i]);
                ++i;
            }
        }
        return this.synsets;
    }

    public Synset getSense(int index) {
        Synset[] sets = this.getSenses();
        if (index > 0 && index <= sets.length) {
            return sets[index - 1];
        }
        throw new IndexWordException(this.lemma + " does not have a sense " + index);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object obj;
        in.defaultReadObject();
        if (in instanceof DictionaryObjectInputStream && (obj = ((DictionaryObjectInputStream)in).getObject()) instanceof DictionaryDatabase) {
            this.dictionary = (DictionaryDatabase)obj;
        }
    }

    public void setDefaultPointerDepth(int depth) {
        if (depth >= 0) {
            this.DEFAULT_POINTER_DEPTH = depth;
        }
    }

    public void setDefaultDepth(int depth) {
        if (depth >= 0) {
            this.DEFAULT_DEPTH = depth;
        }
    }

    public PointerTargetList getDirectHypernyms(int sense) {
        return this.getPointerTargets(sense, PointerType.HYPERNYM);
    }

    public PointerTargetTree getHypernymTree(int sense) {
        return this.getHypernymTree(sense, this.DEFAULT_DEPTH);
    }

    public PointerTargetTree getHypernymTree(int sense, int depth) {
        return this.makeTree(sense, PointerType.HYPERNYM, null, depth);
    }

    public PointerTargetList getDirectHyponyms(int sense) {
        return this.getPointerTargets(sense, PointerType.HYPONYM);
    }

    public PointerTargetTree getHyponymTree(int sense) {
        return this.getHyponymTree(sense, this.DEFAULT_DEPTH);
    }

    public PointerTargetTree getHyponymTree(int sense, int depth) {
        return this.makeTree(sense, PointerType.HYPONYM, null, depth);
    }

    public PointerTargetList getCoordinateTerms(int sense) {
        PointerTargetListItr hypernyms = this.getDirectHypernyms(sense).getIterator();
        PointerTargetList list = new PointerTargetList();
        while (hypernyms.hasNext()) {
            list.append(this.getPointerTargets(hypernyms.nextSynset(), PointerType.HYPONYM));
        }
        return list;
    }

    public PointerTargetList getAntonyms(int sense) {
        return this.getPointerTargets(sense, PointerType.ANTONYM);
    }

    public PointerTargetTree getExtendedAntonyms(int sense) {
        return this.getExtendedAntonyms(sense, 1);
    }

    public PointerTargetTree getExtendedAntonyms(int sense, int depth) {
        PointerTargetTreeList list = new PointerTargetTreeList();
        if (this.pos == POS.ADJECTIVE) {
            PointerTargetList antonyms = this.getAntonyms(sense);
            list = this.makeTreeList(antonyms, PointerType.SIMILAR_TO, PointerType.ANTONYM, depth, false);
        }
        return new PointerTargetTree(new PointerTargetTreeNode((PointerTarget)this.getSense(sense), list, null));
    }

    public PointerTargetTree getIndirectAntonyms(int sense) {
        return this.getIndirectAntonyms(sense, 1);
    }

    public PointerTargetTree getIndirectAntonyms(int sense, int depth) {
        PointerTargetTreeList list = new PointerTargetTreeList();
        if (this.pos == POS.ADJECTIVE) {
            PointerTargetList synonyms = this.getSynonyms(sense);
            list = this.makeTreeList(synonyms, PointerType.ANTONYM, PointerType.ANTONYM, depth, false);
        }
        return new PointerTargetTree(new PointerTargetTreeNode((PointerTarget)this.getSense(sense), list, null));
    }

    public PointerTargetList getAttributes(int sense) {
        return this.getPointerTargets(sense, PointerType.ATTRIBUTE);
    }

    public PointerTargetList getAlsoSees(int sense) {
        return this.getPointerTargets(sense, PointerType.SEE_ALSO);
    }

    public PointerTargetTree getAlsoSeeTree(int sense) {
        return this.getAlsoSeeTree(sense, this.DEFAULT_DEPTH);
    }

    public PointerTargetTree getAlsoSeeTree(int sense, int depth) {
        return this.makeTree(sense, PointerType.SEE_ALSO, null, depth);
    }

    public PointerTargetList getMeronyms(int sense) {
        PointerTargetListItr partMeronyms = this.getPartMeronyms(sense).getIterator();
        PointerTargetListItr memberMeronyms = this.getMemberMeronyms(sense).getIterator();
        PointerTargetListItr substanceMeronyms = this.getSubstanceMeronyms(sense).getIterator();
        PointerTargetList list = new PointerTargetList();
        while (partMeronyms.hasNext()) {
            list.add(partMeronyms.next());
        }
        while (memberMeronyms.hasNext()) {
            list.add(memberMeronyms.next());
        }
        while (substanceMeronyms.hasNext()) {
            list.add(substanceMeronyms.next());
        }
        return list;
    }

    public PointerTargetList getPartMeronyms(int sense) {
        return this.getPointerTargets(sense, PointerType.PART_MERONYM);
    }

    public PointerTargetList getMemberMeronyms(int sense) {
        return this.getPointerTargets(sense, PointerType.MEMBER_MERONYM);
    }

    public PointerTargetList getSubstanceMeronyms(int sense) {
        return this.getPointerTargets(sense, PointerType.SUBSTANCE_MERONYM);
    }

    public PointerTargetTree getInteritedMeronyms(int sense) {
        return this.getInheritedMeronyms(sense, this.DEFAULT_POINTER_DEPTH, this.DEFAULT_DEPTH);
    }

    public PointerTargetTree getInheritedMeronyms(int sense, int pointerDepth, int ancestorDepth) {
        PointerType[] types = new PointerType[]{PointerType.PART_MERONYM, PointerType.MEMBER_MERONYM, PointerType.SUBSTANCE_MERONYM};
        return this.getInherited(sense, types, null, pointerDepth, ancestorDepth, false);
    }

    public PointerTargetTree getInheritedPartMeronyms(int sense) {
        return this.getInheritedPartMeronyms(sense, this.DEFAULT_POINTER_DEPTH, this.DEFAULT_DEPTH);
    }

    public PointerTargetTree getInheritedPartMeronyms(int sense, int pointerDepth, int ancestorDepth) {
        return this.getInherited(sense, PointerType.PART_MERONYM, null, pointerDepth, ancestorDepth);
    }

    public PointerTargetTree getInheritedMemberMeronyms(int sense) {
        return this.getInheritedMemberMeronyms(sense, this.DEFAULT_POINTER_DEPTH, this.DEFAULT_DEPTH);
    }

    public PointerTargetTree getInheritedMemberMeronyms(int sense, int pointerDepth, int ancestorDepth) {
        return this.getInherited(sense, PointerType.MEMBER_MERONYM, null, pointerDepth, ancestorDepth);
    }

    public PointerTargetTree getInheritedSubstanceMeronyms(int sense) {
        return this.getInheritedSubstanceMeronyms(sense, this.DEFAULT_POINTER_DEPTH, this.DEFAULT_DEPTH);
    }

    public PointerTargetTree getInheritedSubstanceMeronyms(int sense, int pointerDepth, int ancestorDepth) {
        return this.getInherited(sense, PointerType.SUBSTANCE_MERONYM, null, pointerDepth, ancestorDepth);
    }

    public PointerTargetList getHolonyms(int sense) {
        PointerTargetListItr partHolonyms = this.getPartHolonyms(sense).getIterator();
        PointerTargetListItr memberHolonyms = this.getMemberHolonyms(sense).getIterator();
        PointerTargetListItr substanceHolonyms = this.getSubstanceHolonyms(sense).getIterator();
        PointerTargetList list = new PointerTargetList();
        while (partHolonyms.hasNext()) {
            list.add(partHolonyms.next());
        }
        while (memberHolonyms.hasNext()) {
            list.add(memberHolonyms.next());
        }
        while (substanceHolonyms.hasNext()) {
            list.add(substanceHolonyms.next());
        }
        return list;
    }

    public PointerTargetList getPartHolonyms(int sense) {
        return this.getPointerTargets(sense, PointerType.PART_HOLONYM);
    }

    public PointerTargetList getMemberHolonyms(int sense) {
        return this.getPointerTargets(sense, PointerType.MEMBER_HOLONYM);
    }

    public PointerTargetList getSubstanceHolonyms(int sense) {
        return this.getPointerTargets(sense, PointerType.SUBSTANCE_HOLONYM);
    }

    public PointerTargetTree getInheritedHolonyms(int sense) {
        return this.getInheritedHolonyms(sense, this.DEFAULT_POINTER_DEPTH, this.DEFAULT_DEPTH);
    }

    public PointerTargetTree getInheritedHolonyms(int sense, int pointerDepth, int ancestorDepth) {
        PointerType[] types = new PointerType[]{PointerType.PART_HOLONYM, PointerType.MEMBER_HOLONYM, PointerType.SUBSTANCE_HOLONYM};
        return this.getInherited(sense, types, null, pointerDepth, ancestorDepth, false);
    }

    public PointerTargetTree getInheritedPartHolonyms(int sense) {
        return this.getInheritedPartHolonyms(sense, this.DEFAULT_POINTER_DEPTH, this.DEFAULT_DEPTH);
    }

    public PointerTargetTree getInheritedPartHolonyms(int sense, int pointerDepth, int ancestorDepth) {
        return this.getInherited(sense, PointerType.PART_HOLONYM, null, pointerDepth, ancestorDepth);
    }

    public PointerTargetTree getInheritedMemberHolonyms(int sense) {
        return this.getInheritedMemberHolonyms(sense, this.DEFAULT_POINTER_DEPTH, this.DEFAULT_DEPTH);
    }

    public PointerTargetTree getInheritedMemberHolonyms(int sense, int pointerDepth, int ancestorDepth) {
        return this.getInherited(sense, PointerType.MEMBER_HOLONYM, null, pointerDepth, ancestorDepth);
    }

    public PointerTargetTree getInheritedSubstanceHolonyms(int sense) {
        return this.getInheritedSubstanceHolonyms(sense, this.DEFAULT_POINTER_DEPTH, this.DEFAULT_DEPTH);
    }

    public PointerTargetTree getInheritedSubstanceHolonyms(int sense, int pointerDepth, int ancestorDepth) {
        return this.getInherited(sense, PointerType.SUBSTANCE_HOLONYM, null, pointerDepth, ancestorDepth);
    }

    public PointerTargetList getEntailments(int sense) {
        return this.getPointerTargets(sense, PointerType.ENTAILMENT);
    }

    public PointerTargetTree getEntailmentTree(int sense) {
        return this.getEntailmentTree(sense, this.DEFAULT_DEPTH);
    }

    public PointerTargetTree getEntailmentTree(int sense, int depth) {
        return this.makeTree(sense, PointerType.ENTAILMENT, null, depth);
    }

    public PointerTargetList getEntailedBy(int sense) {
        return this.getPointerTargets(sense, PointerType.ENTAILED_BY);
    }

    public PointerTargetTree getEntailedByTree(int sense) {
        return this.getEntailedByTree(sense, this.DEFAULT_DEPTH);
    }

    public PointerTargetTree getEntailedByTree(int sense, int depth) {
        return this.makeTree(sense, PointerType.ENTAILED_BY, null, depth);
    }

    public PointerTargetList getCauses(int sense) {
        return this.getPointerTargets(sense, PointerType.CAUSE);
    }

    public PointerTargetTree getCauseTree(int sense) {
        return this.getCauseTree(sense, this.DEFAULT_DEPTH);
    }

    public PointerTargetTree getCauseTree(int sense, int depth) {
        return this.makeTree(sense, PointerType.CAUSE, null, depth);
    }

    public PointerTargetList getVerbGroup(int sense) {
        Vector<PointerTargetListNode> nodes = new Vector<PointerTargetListNode>();
        nodes.addElement(new PointerTargetListNode(this.getSense(sense), PointerType.VERB_GROUP));
        int maxIndex = 0;
        int index = -1;
        do {
            PointerTargetListNode node = (PointerTargetListNode)nodes.elementAt(++index);
            PointerTargetListItr itr = this.getPointerTargets(node.getSynset(), PointerType.VERB_GROUP).getIterator();
            while (itr.hasNext()) {
                PointerTargetListNode testNode = itr.next();
                if (nodes.contains(testNode)) continue;
                nodes.addElement(testNode);
                ++maxIndex;
            }
        } while (index < maxIndex);
        PointerTargetList list = new PointerTargetList();
        int i = 0;
        while (i < nodes.size()) {
            list.add((PointerTargetListNode)nodes.elementAt(i));
            ++i;
        }
        return list;
    }

    public PointerTargetList getParticipleOf(int sense) {
        return this.getPointerTargets(sense, PointerType.PARTICIPLE_OF);
    }

    public PointerTargetList getDerived(int sense) {
        return this.getPointerTargets(sense, PointerType.DERIVED);
    }

    public PointerTargetList getSynonyms(int sense) {
        return this.getPointerTargets(sense, PointerType.SIMILAR_TO);
    }

    public PointerTargetTree getSynonymTree(int sense) {
        return this.getSynonymTree(sense, this.DEFAULT_DEPTH);
    }

    public PointerTargetTree getSynonymTree(int sense, int depth) {
        return this.makeTree(sense, PointerType.SIMILAR_TO, null, depth, false);
    }

    public PointerTargetList getPointers(Synset set) {
        Pointer[] p = set.getPointers();
        PointerTargetList list = new PointerTargetList();
        int i = 0;
        while (i < p.length) {
            list.add(p[i].getTarget(), p[i].getType());
            ++i;
        }
        return list;
    }

    protected PointerTargetList getPointerTargets(Synset set, PointerType type) {
        PointerTargetList list = new PointerTargetList();
        if (type.appliesTo(set.getPOS())) {
            Pointer[] p = set.getPointers(type);
            int i = 0;
            while (i < p.length) {
                list.add(p[i].getTarget(), type);
                ++i;
            }
        }
        return list;
    }

    protected PointerTargetList getPointerTargets(int sense, PointerType type) {
        return this.getPointerTargets(this.getSense(sense), type);
    }

    public PointerTargetTree makeTree(int sense, PointerType searchType, PointerType labelType, int depth) {
        return this.makeTree(sense, searchType, labelType, depth, true);
    }

    public PointerTargetTree makeTree(int sense, PointerType searchType, PointerType labelType, int depth, boolean allowRedundancies) {
        return this.makeTree(this.getSense(sense), searchType, labelType, depth, allowRedundancies);
    }

    public PointerTargetTree makeTree(Synset set, PointerType searchType, PointerType labelType, int depth, boolean allowRedundancies) {
        PointerType[] searchTypes = new PointerType[]{searchType};
        return this.makeTree(set, searchTypes, labelType, depth, allowRedundancies);
    }

    public PointerTargetTree makeTree(Synset set, PointerType[] searchTypes, PointerType labelType, int depth, boolean allowRedundancies) {
        PointerTargetTreeNode node = new PointerTargetTreeNode(set);
        PointerTargetTreeList list = this.makeTreeList(set, searchTypes, labelType, depth, allowRedundancies, node);
        node.setChildTreeList(list);
        return new PointerTargetTree(node);
    }

    public PointerTargetTreeList makeTreeList(int sense, PointerType searchType, PointerType labelType, int depth, boolean allowRedundancies) {
        return this.makeTreeList(this.getSense(sense), searchType, labelType, depth, allowRedundancies);
    }

    public PointerTargetTreeList makeTreeList(Synset set, PointerType searchType, PointerType labelType, int depth, boolean allowRedundancies) {
        PointerType[] searchTypes = new PointerType[]{searchType};
        return this.makeTreeList(set, searchTypes, labelType, depth, allowRedundancies);
    }

    public PointerTargetTreeList makeTreeList(PointerTargetList list, PointerType searchType, PointerType labelType, int depth, boolean allowRedundancies) {
        PointerType[] searchTypes = new PointerType[]{searchType};
        return this.makeTreeList(list, searchTypes, labelType, depth, allowRedundancies);
    }

    public PointerTargetTreeList makeTreeList(PointerTargetList list, PointerType[] searchTypes, PointerType labelType, int depth, boolean allowRedundancies) {
        PointerTargetListItr itr = list.getIterator();
        PointerTargetTreeList treeList = new PointerTargetTreeList();
        while (itr.hasNext()) {
            PointerTargetListNode node = itr.next();
            treeList.add(node.getPointerTarget(), this.makeTreeList(node.getSynset(), searchTypes, labelType, depth, allowRedundancies), labelType);
        }
        return treeList;
    }

    public PointerTargetTreeList makeTreeList(Synset synset, PointerType[] searchTypes, PointerType labelType, int depth) {
        return this.makeTreeList(synset, searchTypes, labelType, depth, true);
    }

    public PointerTargetTreeList makeTreeList(Synset synset, PointerType[] searchTypes, PointerType labelType, int depth, boolean allowRedundancies) {
        return this.makeTreeList(synset, searchTypes, labelType, depth, allowRedundancies, null);
    }

    public PointerTargetTreeList makeTreeList(Synset synset, PointerType[] searchTypes, PointerType labelType, int depth, boolean allowRedundancies, PointerTargetTreeNode parent) {
        --depth;
        PointerTargetTreeList list = new PointerTargetTreeList();
        int i = 0;
        while (i < searchTypes.length) {
            PointerType type = searchTypes[i];
            PointerTargetList targets = this.getPointerTargets(synset, type);
            if (targets.size() != 0) {
                PointerTargetListItr itr = targets.getIterator();
                while (itr.hasNext()) {
                    PointerTargetTreeNode node = new PointerTargetTreeNode(itr.next().getPointerTarget(), labelType == null ? type : labelType, parent);
                    if (!allowRedundancies && list.contains(node)) continue;
                    if (depth != 0) {
                        node.setChildTreeList(this.makeTreeList(node.getSynset(), searchTypes, labelType, depth, allowRedundancies, node));
                    }
                    list.add(node);
                }
            }
            ++i;
        }
        return list;
    }

    protected PointerTargetTree getInherited(int sense, PointerType searchType, PointerType labelType, int pointerDepth, int ancestorDepth) {
        return this.getInherited(sense, searchType, labelType, pointerDepth, ancestorDepth, true);
    }

    protected PointerTargetTree getInherited(int sense, PointerType searchType, PointerType labelType, int pointerDepth, int ancestorDepth, boolean allowRedundancies) {
        PointerType[] searchTypes = new PointerType[]{searchType};
        return this.getInherited(sense, searchTypes, labelType, pointerDepth, ancestorDepth, allowRedundancies);
    }

    protected PointerTargetTree getInherited(int sense, PointerType[] searchTypes, PointerType labelType, int pointerDepth, int ancestorDepth) {
        return this.getInherited(sense, searchTypes, labelType, pointerDepth, ancestorDepth, true);
    }

    protected PointerTargetTree getInherited(int sense, PointerType[] searchTypes, PointerType labelType, int pointerDepth, int ancestorDepth, boolean allowRedundancies) {
        PointerTargetTree hypernyms = this.getHypernymTree(sense);
        return this.makeInheritedTree(hypernyms, searchTypes, labelType, pointerDepth, ancestorDepth, allowRedundancies);
    }

    protected PointerTargetTree makeInheritedTree(PointerTargetTree tree, PointerType[] searchTypes, PointerType labelType, int pointerDepth, int ancestorDepth, boolean allowRedundancies) {
        PointerTargetTreeNode root = tree.getRootNode();
        root.setPointerTreeList(this.makeTreeList(root.getSynset(), searchTypes, labelType, pointerDepth, allowRedundancies));
        root.setChildTreeList(this.makeInheritedTreeList(root.getChildTreeList(), searchTypes, labelType, pointerDepth, ancestorDepth, allowRedundancies));
        return new PointerTargetTree(root);
    }

    protected PointerTargetTreeList makeInheritedTreeList(PointerTargetTreeList list, PointerType[] searchTypes, PointerType labelType, int pointerDepth, int ancestorDepth, boolean allowRedundancies) {
        --ancestorDepth;
        PointerTargetTreeListItr itr = list.getIterator();
        PointerTargetTreeList inherited = new PointerTargetTreeList();
        while (itr.hasNext()) {
            PointerTargetTreeNode node = itr.next();
            if (!allowRedundancies && inherited.contains(node)) continue;
            if (ancestorDepth == 0) {
                inherited.add(node.getPointerTarget(), null, this.makeTreeList(node.getSynset(), searchTypes, labelType, pointerDepth, allowRedundancies), PointerType.HYPERNYM);
                continue;
            }
            inherited.add(node.getPointerTarget(), this.makeInheritedTreeList(node.getChildTreeList(), searchTypes, labelType, pointerDepth, ancestorDepth, allowRedundancies), this.makeTreeList(node.getSynset(), searchTypes, labelType, pointerDepth, allowRedundancies), PointerType.HYPERNYM);
        }
        return inherited;
    }
}

