/*
 * Decompiled with CFR 0.152.
 */
package jwnl.util;

import java.io.File;

public class SystemInfo {
    protected static final boolean IS_WINDOWS_OS = System.getProperties().getProperty("os.name").startsWith("Windows");
    protected static final boolean IS_MAC_OS = System.getProperties().getProperty("os.name").startsWith("Mac");
    protected static final boolean IS_MW_VM = System.getProperties().getProperty("java.vendor").equalsIgnoreCase("Metrowerks Corp.");
    protected static final String fileSeparator = IS_MW_VM ? ":" : File.separator;

    public static String getWNHome() {
        String home = System.getProperty("WNHOME");
        if (home != null) {
            return home;
        }
        if (IS_WINDOWS_OS) {
            return "C:\\wn16";
        }
        if (IS_MAC_OS) {
            return ".";
        }
        return "/usr/local/wordnet1.6";
    }

    public static String getWNSearchDir() {
        String searchDir = System.getProperty("WNSEARCHDIR");
        if (searchDir != null) {
            return searchDir;
        }
        if (IS_MAC_OS && SystemInfo.getWNHome().equals(".")) {
            return "Database";
        }
        return SystemInfo.getWNHome() + fileSeparator + (IS_MAC_OS ? "Database" : "dict");
    }

    public static boolean isWindowsOS() {
        return IS_WINDOWS_OS;
    }

    public static boolean isMacOS() {
        return IS_MAC_OS;
    }

    public static boolean isMetrowerksVM() {
        return IS_MW_VM;
    }

    public static String getFileSeparator() {
        return fileSeparator;
    }
}

