/*
 * Decompiled with CFR 0.152.
 */
package jwnl.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import jwnl.data.IndexWordSet;
import jwnl.dictionary.flatfile.FileBackedDictionary;

public final class PerformanceTester {
    private FileBackedDictionary database;

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            System.err.println("Syntax: java PerformanceTester <test filename> [location of wordnet 1.6 dictionary]");
        } else if (args.length == 1) {
            PerformanceTester pt = new PerformanceTester(args[0]);
        } else {
            PerformanceTester performanceTester = new PerformanceTester(args[0], args[1]);
        }
    }

    public PerformanceTester(String testfile) {
        this(testfile, null);
    }

    public PerformanceTester(String testfile, String dbLoc) {
        FileBackedDictionary db = dbLoc == null ? new FileBackedDictionary() : new FileBackedDictionary(dbLoc);
        int counter = 0;
        String line = null;
        LineNumberReader lnr = null;
        try {
            lnr = new LineNumberReader(new InputStreamReader(new FileInputStream(testfile)));
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        long start_time = System.currentTimeMillis();
        while (true) {
            try {
                line = lnr.readLine();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (line == null) break;
            long t1 = System.currentTimeMillis();
            System.out.println("Testing \"" + line + "\"...");
            IndexWordSet set = db.lookupAllIndexWords(line);
            long t2 = System.currentTimeMillis();
            System.out.println("Number: " + counter++ + "\t\tTime: " + (t2 - t1) + " milliseconds" + "\t\tWord (Number of POS's): " + set.getLemma() + " (" + set.size() + ")");
        }
        long end_time = System.currentTimeMillis();
        long total_time = end_time - start_time;
        int hours = (int)((double)total_time / 3600000.0);
        total_time = (long)((double)total_time - (double)hours * 3600000.0);
        int minutes = (int)((double)total_time / 60000.0);
        total_time = (long)((double)total_time - (double)minutes * 60000.0);
        int seconds = (int)((double)total_time / 1000.0);
        total_time = (long)((double)total_time - (double)seconds * 1000.0);
        System.out.println("\nTotal Time:\t" + hours + ":" + minutes + ":" + seconds + ":" + total_time);
        total_time = (end_time - start_time) / (long)counter;
        hours = (int)((double)total_time / 3600000.0);
        total_time = (long)((double)total_time - (double)hours * 3600000.0);
        minutes = (int)((double)total_time / 60000.0);
        total_time = (long)((double)total_time - (double)minutes * 60000.0);
        seconds = (int)((double)total_time / 1000.0);
        total_time = (long)((double)total_time - (double)seconds * 1000.0);
        System.out.println("Average Time:\t" + hours + ":" + minutes + ":" + seconds + ":" + total_time);
    }
}

