/*
 * Decompiled with CFR 0.152.
 */
package jwnl.dictionary.file.object;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import jwnl.data.POS;
import jwnl.dictionary.file.DefaultDictionaryFile;
import jwnl.dictionary.file.DictionaryFileException;
import jwnl.dictionary.file.object.DictionaryObjectInputStream;

public class ObjectDictionaryFile
extends DefaultDictionaryFile {
    protected File file = null;
    protected ObjectInputStream in = null;
    protected ObjectOutputStream out = null;

    public ObjectDictionaryFile(POS pos, int fileType) {
        super(pos, fileType);
    }

    public File getFile() {
        return this.file;
    }

    public boolean isOpen() {
        return this.file != null;
    }

    public void close() {
        try {
            this.in.close();
            this.out.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.in = null;
        this.out = null;
        this.file = null;
    }

    public void openStreams() {
        this.openStreams(null);
    }

    public void openStreams(Object obj) {
        if (!this.canWrite()) {
            this.openOutputStream();
        }
        if (!this.canRead()) {
            this.openInputStream(obj);
        }
    }

    public void openOutputStream() {
        try {
            this.out = new ObjectOutputStream(new FileOutputStream(this.file));
        }
        catch (Throwable t) {
            throw new DictionaryFileException(t.toString());
        }
    }

    public void openInputStream(Object obj) {
        try {
            this.in = new DictionaryObjectInputStream(new FileInputStream(this.file), obj);
        }
        catch (Throwable t) {
            throw new DictionaryFileException(t.toString());
        }
    }

    public ObjectInputStream getInputStream() {
        return this.in;
    }

    public ObjectOutputStream getOutputStream() {
        return this.out;
    }

    public boolean canRead() {
        return this.in != null;
    }

    public boolean canWrite() {
        return this.out != null;
    }

    public Object readObject() {
        if (this.isOpen() && this.canRead()) {
            try {
                return this.in.readObject();
            }
            catch (Throwable t) {
                throw new DictionaryFileException(t.toString());
            }
        }
        return null;
    }

    public void writeObject(Object obj) {
        if (this.isOpen() && this.canWrite()) {
            try {
                this.out.writeObject(obj);
            }
            catch (Throwable t) {
                throw new DictionaryFileException(t.toString());
            }
        }
    }

    protected void openFile(String path, Object obj) throws FileNotFoundException {
        this.file = new File(path);
        if (!this.file.exists()) {
            try {
                this.file.createNewFile();
            }
            catch (Throwable t) {
                throw new DictionaryFileException(t.toString());
            }
            this.openOutputStream();
        } else {
            this.openInputStream(obj);
        }
    }
}

