/*
 * Decompiled with CFR 0.152.
 */
package jwnl.dictionary.file;

import java.util.Hashtable;
import jwnl.data.POS;
import jwnl.dictionary.file.DictionaryFile;
import jwnl.util.SystemInfo;

public abstract class DefaultDictionaryFile
extends DictionaryFile {
    public static final int INDEX = 0;
    public static final int DATA = 1;
    public static final int EXCEPTION = 2;
    public static final int[] FILE_TYPES = new int[]{0, 1, 2};
    protected static final String[] NON_WINDOWS_FILE_TYPE_STRINGS = new String[]{"index", "data", "exc"};
    protected static final String[] WINDOWS_FILE_TYPE_STRINGS = new String[]{"idx", "dat", "exc"};
    protected static final int[] NOUN_FILE_SIZES = new int[]{94473, 66024, 5969};
    protected static final int[] VERB_FILE_SIZES = new int[]{10318, 12126, 5281};
    protected static final int[] ADJECTIVE_FILE_SIZES = new int[]{20169, 17914, 1322};
    protected static final int[] ADVERB_FILE_SIZES = new int[]{4546, 3574, 7};
    protected static final POSInfo[] info = new POSInfo[]{new POSInfo(POS.NOUN, "noun", NOUN_FILE_SIZES), new POSInfo(POS.VERB, "verb", VERB_FILE_SIZES), new POSInfo(POS.ADJECTIVE, "adj", ADJECTIVE_FILE_SIZES), new POSInfo(POS.ADVERB, "adv", ADVERB_FILE_SIZES)};
    protected static final POSHashtable posTable = new POSHashtable(info);

    public DefaultDictionaryFile(POS pos, int fileType) {
        super(pos, fileType);
        this.setSize(DefaultDictionaryFile.getSize(pos, fileType));
    }

    public static int getSize(POS pos, int fileType) {
        POSInfo info = (POSInfo)posTable.get(pos);
        return info.getSize(fileType);
    }

    public String makeFilename(POS pos, int fileType) {
        String posString = this.getPOSString(pos);
        if (fileType == 2) {
            return posString + ".exc";
        }
        return this.makeFilename(posString, fileType);
    }

    protected String makeFilename(String pos, int fileType) {
        if (SystemInfo.isWindowsOS()) {
            return this.makeWindowsFilename(pos, this.getWindowsFileTypeString(fileType));
        }
        return this.makeNonWindowsFilename(pos, this.getNonWindowsFileTypeString(fileType));
    }

    protected String makeWindowsFilename(String posStr, String fileTypeStr) {
        return posStr + "." + fileTypeStr;
    }

    protected String makeNonWindowsFilename(String posStr, String fileTypeStr) {
        return fileTypeStr + "." + posStr;
    }

    protected String getPOSString(POS pos) {
        return ((POSInfo)DefaultDictionaryFile.posTable.get((Object)pos)).str;
    }

    protected String getWindowsFileTypeString(int fileType) {
        return WINDOWS_FILE_TYPE_STRINGS[fileType];
    }

    protected String getNonWindowsFileTypeString(int fileType) {
        return NON_WINDOWS_FILE_TYPE_STRINGS[fileType];
    }

    protected static class POSHashtable
    extends Hashtable {
        public POSHashtable(POSInfo[] p) {
            int i = 0;
            while (i < p.length) {
                this.put(p[i].pos, p[i]);
                ++i;
            }
        }
    }

    protected static class POSInfo {
        POS pos;
        String str;
        int[] sizes;

        public POSInfo(POS pos, String str, int[] sizes) {
            this.pos = pos;
            this.str = str;
            this.sizes = sizes;
        }

        public int getSize(int index) {
            return this.sizes[index];
        }
    }
}

