/*
 * Decompiled with CFR 0.152.
 */
package jwnl.dictionary;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import jwnl.data.Exc;
import jwnl.data.IndexWord;
import jwnl.data.IndexWordSet;
import jwnl.data.POS;
import jwnl.data.Synset;
import jwnl.dictionary.BaseFormLookupException;
import jwnl.dictionary.DatabaseKeyException;
import jwnl.util.Cache;
import jwnl.util.LRUCache;

public abstract class DictionaryDatabase {
    protected static final int DEFAULT_CACHE_CAPACITY = 1000;
    protected boolean enableCaching = true;
    protected Cache indexWordCache;
    protected Cache synsetCache;
    protected Cache exceptionCache;
    protected Cache baseFormCache;
    protected static final String[][] nounSuffixes = new String[][]{{"s", ""}, {"ses", "s"}, {"xes", "x"}, {"zes", "z"}, {"ches", "c"}, {"shes", "sh"}};
    protected static final String[][] verbSuffixes = new String[][]{{"s", ""}, {"es", "e"}, {"es", ""}, {"ed", "e"}, {"ed", ""}, {"ing", "e"}, {"ing", ""}};
    protected static final String[][] adjectiveSuffixes = new String[][]{{"er", ""}, {"est", ""}, {"er", "e"}, {"est", "e"}};

    public DictionaryDatabase() {
    }

    public DictionaryDatabase(boolean enableCaching) {
        this.enableCaching = enableCaching;
        if (enableCaching) {
            this.indexWordCache = new LRUCache(1000);
            this.synsetCache = new LRUCache(1000);
        }
        this.baseFormCache = new LRUCache(1000);
    }

    public abstract Enumeration indexWords(POS var1);

    public abstract IndexWord lookupIndexWord(POS var1, String var2);

    public abstract Enumeration searchIndexWords(POS var1, String var2);

    public abstract Enumeration synsets(POS var1);

    public abstract Synset getSynsetAt(POS var1, long var2, String var4);

    public abstract Synset getSynsetAt(POS var1, long var2);

    public abstract Enumeration exceptions(POS var1);

    public abstract Exc lookupExceptions(POS var1, String var2);

    public abstract void close();

    public IndexWord lookupWord(POS pos, String lemma) {
        IndexWord word = this.lookupIndexWord(pos, lemma);
        if (word == null) {
            word = this.lookupBaseForm(pos, lemma);
        }
        return word;
    }

    public IndexWordSet lookupAllIndexWords(String lemma) {
        IndexWordSet set = new IndexWordSet(lemma);
        POS[] cats = POS.getCats();
        int i = 0;
        while (i < cats.length) {
            IndexWord current = this.lookupWord(cats[i], lemma);
            if (current != null) {
                set.add(current);
            }
            ++i;
        }
        return set;
    }

    public boolean cachingEnabled() {
        return this.enableCaching;
    }

    protected IndexWord lookupCachedIndexWord(DatabaseKey key) {
        if (this.cachingEnabled()) {
            return (IndexWord)this.indexWordCache.get(key);
        }
        return null;
    }

    protected void cacheIndexWord(DatabaseKey key, IndexWord word) {
        if (this.cachingEnabled()) {
            this.indexWordCache.put(key, word);
        }
    }

    protected Synset lookupCachedSynset(DatabaseKey key) {
        if (this.cachingEnabled()) {
            return (Synset)this.synsetCache.get(key);
        }
        return null;
    }

    protected void cacheSynset(DatabaseKey key, Synset set) {
        if (this.cachingEnabled()) {
            this.synsetCache.put(key, set);
        }
    }

    protected Exc lookupCachedException(DatabaseKey key) {
        if (this.cachingEnabled()) {
            return (Exc)this.exceptionCache.get(key);
        }
        return null;
    }

    protected void cacheException(DatabaseKey key, Exception exc) {
        if (this.cachingEnabled()) {
            this.exceptionCache.put(key, exc);
        }
    }

    protected void cacheBaseForm(DatabaseKey key, BaseForm form) {
        this.baseFormCache.put(key, form);
    }

    protected BaseForm getCachedBaseForm(DatabaseKey key) {
        return (BaseForm)this.baseFormCache.get(key);
    }

    public IndexWord lookupBaseForm(POS pos, String derivation) {
        BaseForm form = this.getCachedBaseForm(new DatabaseKey(pos, derivation));
        if (form != null && form.hasCurrentForm()) {
            return this.lookupIndexWord(pos, form.getCurrentForm());
        }
        return this.lookupNextBaseForm(pos, derivation, form);
    }

    public IndexWord lookupNextBaseForm(POS pos, String derivation) {
        return this.lookupNextBaseForm(pos, derivation, null);
    }

    public IndexWord lookupNextBaseForm(POS pos, String derivation, BaseForm form) {
        if (derivation.equals("") || derivation == null) {
            return null;
        }
        DatabaseKey key = new DatabaseKey(pos, derivation);
        String str = null;
        if (form == null) {
            form = this.getCachedBaseForm(key);
            if (form == null) {
                form = new BaseForm(derivation, pos);
                this.cacheBaseForm(key, form);
            } else {
                str = form.getNextForm();
            }
        }
        while (str == null) {
            int step = form.getNextStep();
            switch (step) {
                case 1: {
                    this.lookupExceptions(pos, derivation, form);
                    break;
                }
                case 2: {
                    this.detachSuffixes(pos, derivation, form);
                    break;
                }
                case 3: {
                    this.removeDelimiters(pos, derivation, form);
                    break;
                }
                case 4: {
                    this.removePrepPhrases(pos, derivation, form);
                    break;
                }
                case 5: {
                    return null;
                }
                default: {
                    throw new BaseFormLookupException("Invalid BaseForm lookup step: " + step);
                }
            }
            if (!form.hasMoreForms()) continue;
            str = form.getNextForm();
        }
        return this.lookupIndexWord(pos, str);
    }

    protected void lookupExceptions(POS pos, String derivation, BaseForm form) {
        this.findExceptions(pos, derivation, form);
        StringTokenizer tokenizer = new StringTokenizer(derivation);
        if (tokenizer.countTokens() > 1) {
            IndexWord word;
            String[] tokens = new String[tokenizer.countTokens()];
            String token = "";
            String str = "";
            BaseForm temp = new BaseForm("", pos);
            int i = 0;
            while (i < tokens.length) {
                token = tokenizer.nextToken();
                this.findExceptions(pos, token, temp);
                if (temp.hasMoreForms()) {
                    try {
                        str = str + temp.getNextForm() + " ";
                    }
                    catch (BaseFormLookupException ex) {
                        str = str + token + " ";
                    }
                } else {
                    str = str + token + " ";
                }
                ++i;
            }
            try {
                word = this.lookupIndexWord(pos, str.trim());
            }
            catch (DatabaseKeyException ex) {
                throw new RuntimeException(ex.toString());
            }
            if (word != null) {
                form.add(str.trim());
            }
        }
    }

    protected void findExceptions(POS pos, String str, BaseForm form) {
        Exc exc = this.lookupExceptions(pos, str);
        if (exc != null) {
            String[] exceptions = exc.getExceptionArray();
            int i = 0;
            while (i < exceptions.length) {
                form.add(exceptions[i]);
                ++i;
            }
        }
    }

    protected Vector getStemmedForms(String lemma, String[][] suffixArray) {
        Vector<String> v = new Vector<String>();
        v.addElement(lemma);
        int i = 0;
        while (i < suffixArray.length) {
            if (lemma.endsWith(suffixArray[i][0])) {
                v.addElement(lemma.substring(0, lemma.length() - suffixArray[i][0].length()) + suffixArray[i][1]);
            }
            ++i;
        }
        return v;
    }

    protected void detachSuffixes(POS pos, String str, BaseForm form) {
        String[][] suffixArray = null;
        if (pos == POS.NOUN) {
            suffixArray = nounSuffixes;
        } else if (pos == POS.VERB) {
            suffixArray = verbSuffixes;
        } else if (pos == POS.ADJECTIVE) {
            suffixArray = adjectiveSuffixes;
        } else {
            return;
        }
        int i = 0;
        StringTokenizer tokenizer = new StringTokenizer(str);
        Vector[] stemmedForms = new Vector[tokenizer.countTokens()];
        while (tokenizer.hasMoreTokens()) {
            stemmedForms[i++] = this.getStemmedForms(tokenizer.nextToken(), suffixArray);
        }
        int[] endArray = new int[stemmedForms.length];
        int[] indexArray = new int[stemmedForms.length];
        i = 0;
        while (i < stemmedForms.length) {
            endArray[i] = stemmedForms[i].size() - 1;
            indexArray[i] = 0;
            ++i;
        }
        indexArray[indexArray.length - 1] = -1;
        do {
            String testLemma = "";
            IndexWord testWord = null;
            i = stemmedForms.length - 1;
            while (i >= 0) {
                int n = i;
                indexArray[n] = indexArray[n] + 1;
                if (indexArray[n] <= endArray[i]) break;
                indexArray[i] = 0;
                --i;
            }
            i = 0;
            while (i < stemmedForms.length) {
                testLemma = testLemma + (String)stemmedForms[i].elementAt(indexArray[i]) + " ";
                ++i;
            }
            if (testLemma.equals(str)) continue;
            try {
                testWord = this.lookupIndexWord(pos, testLemma.trim());
            }
            catch (DatabaseKeyException ex) {
                throw new RuntimeException(ex.toString());
            }
            if (testWord == null) continue;
            form.add(testLemma.trim());
        } while (!Arrays.equals(indexArray, endArray));
    }

    protected void removeDelimiters(POS pos, String str, BaseForm form) {
        String str1;
        StringTokenizer tokenizer;
        if (str.indexOf("-") >= 0) {
            tokenizer = new StringTokenizer(str, "-\t\n\r\f");
            str1 = "";
            while (tokenizer.hasMoreTokens()) {
                str1 = str1 + tokenizer.nextToken() + " ";
            }
            str1 = str1.trim();
            this.repeatSteps(pos, str1, form);
        } else {
            str1 = str;
        }
        if (str1.indexOf(" ") >= 0) {
            tokenizer = new StringTokenizer(str1, " ");
            String str2 = "";
            while (tokenizer.hasMoreTokens()) {
                str2 = str2 + tokenizer.nextToken();
            }
            this.repeatSteps(pos, str2, form);
        }
        tokenizer = new StringTokenizer(str1, ".,;:?/!&()'\"\\");
        String str3 = "";
        while (tokenizer.hasMoreTokens()) {
            str3 = str3 + tokenizer.nextToken() + " ";
        }
        if ((str3 = str3.trim()) != str1) {
            this.repeatSteps(pos, str3, form);
            tokenizer = new StringTokenizer(str3, " ");
            String str4 = "";
            while (tokenizer.hasMoreTokens()) {
                str4 = str4 + tokenizer.nextToken();
            }
            this.repeatSteps(pos, str4, form);
        }
    }

    protected void repeatSteps(POS pos, String str, BaseForm form) {
        IndexWord word;
        try {
            word = this.lookupIndexWord(pos, str);
        }
        catch (DatabaseKeyException ex) {
            throw new RuntimeException(ex.toString());
        }
        if (word != null) {
            form.add(str);
        }
        this.lookupExceptions(pos, str, form);
        this.detachSuffixes(pos, str, form);
    }

    protected void removePrepPhrases(POS pos, String str, BaseForm form) {
    }

    protected class BaseForm {
        public static final int EXCEPTIONS = 1;
        public static final int SUFFIXES = 2;
        public static final int DELIMITERS = 3;
        public static final int PREPOSITIONS = 4;
        public static final int ERROR = 5;
        public static final int FIRST_STEP = 1;
        public static final int LAST_STEP = 4;
        protected String lemma;
        protected Vector forms = new Vector();
        protected int nextIndex = 0;
        protected int nextStep = 1;
        protected POS pos;

        public BaseForm(String lemma, POS pos) {
            this.lemma = lemma;
            this.pos = pos;
        }

        public boolean hasMoreForms() {
            return this.nextIndex < this.forms.size();
        }

        public boolean hasCurrentForm() {
            return this.nextIndex - 1 >= 0;
        }

        public void add(String s) {
            this.forms.addElement(s);
        }

        public Vector getForms() {
            return this.forms;
        }

        public String getLemma() {
            return this.lemma;
        }

        public POS getPOS() {
            return this.pos;
        }

        public int getNextStep() {
            if (this.nextStep == 5) {
                return 5;
            }
            int i = this.nextStep++;
            return i;
        }

        public void setNextStep(int step) {
            if (step > 4 || step < 1) {
                throw new BaseFormLookupException("Invalid Step: cannot set step for BaseForm(" + this.lemma + ") to " + step);
            }
            this.nextStep = step;
        }

        public void resetNextStep() {
            this.nextStep = 1;
        }

        public void resetForms() {
            this.nextIndex = 0;
        }

        public void clearForms() {
            this.forms = new Vector();
        }

        public String getCurrentForm() {
            if (!this.hasCurrentForm()) {
                throw new BaseFormLookupException("No current form found");
            }
            return this.getForm(this.nextIndex - 1);
        }

        public String getNextForm() {
            if (this.nextIndex >= this.forms.size()) {
                throw new BaseFormLookupException("No next form found");
            }
            int i = this.nextIndex++;
            return this.getForm(i);
        }

        public String getForm(int index) {
            if (index < 0 || index >= this.forms.size()) {
                throw new BaseFormLookupException("No form found at index " + index);
            }
            return (String)this.forms.elementAt(index);
        }

        public int numForms() {
            return this.forms.size();
        }
    }

    public class DatabaseKey {
        POS pos;
        Object key;

        public DatabaseKey(POS pos, Object key) {
            if (pos == null || key == null) {
                throw new DatabaseKeyException("Invalid Key: cannot have a key with a null value.");
            }
            this.pos = pos;
            this.key = key;
        }

        public boolean equals(Object object) {
            return object instanceof DatabaseKey && ((DatabaseKey)object).pos.equals(this.pos) && ((DatabaseKey)object).key.equals(this.key);
        }

        public int hashCode() {
            return this.pos.hashCode() ^ this.key.hashCode();
        }

        public String toString() {
            return this.pos.toString() + this.key.toString();
        }
    }
}

