/*
 * Decompiled with CFR 0.152.
 */
package jwnl.data.list;

import java.util.Collections;
import java.util.LinkedList;
import java.util.ListIterator;
import jwnl.data.list.Node;
import jwnl.data.list.NodeListItr;
import jwnl.data.list.NodePrinter;

public class NodeList {
    protected LinkedList list = new LinkedList();

    public NodeList() {
    }

    protected NodeList(LinkedList list) {
        this.list = list;
    }

    protected void add(Node node) {
        this.list.add(node);
    }

    protected LinkedList getList() {
        return this.list;
    }

    protected Node getFirstNode() {
        return (Node)this.list.getFirst();
    }

    protected Node getLastNode() {
        return (Node)this.list.getLast();
    }

    protected NodeListItr getNodeListIterator() {
        return new NodeListItr(this.getListIterator());
    }

    protected ListIterator getListIterator() {
        return this.list.listIterator();
    }

    protected Node[] toNodeArray() {
        return this.getList().toArray(new Node[this.list.size()]);
    }

    protected NodeList reverseNodeList() {
        return new NodeList(this.reverseLinkedList());
    }

    protected LinkedList reverseLinkedList() {
        LinkedList reversedList = (LinkedList)this.list.clone();
        Collections.reverse(reversedList);
        return reversedList;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsNode(Node node) {
        return this.list.contains(node);
    }

    public void append(NodeList list) {
        NodeListItr itr = this.getNodeListIterator();
        while (itr.hasNext()) {
            this.add(itr.nextNode());
        }
    }

    public boolean equals(Object object) {
        return this.list.equals(object);
    }

    public void print() {
        this.getNodeListIterator().print();
    }

    public void print(NodePrinter p) {
        this.getNodeListIterator().print(p);
    }

    public void print(int indent) {
        this.getNodeListIterator().print(indent);
    }

    public void print(NodePrinter p, int indent) {
        this.getNodeListIterator().print(p, indent);
    }
}

