/*
 * Decompiled with CFR 0.152.
 */
package jwnl.data;

import java.util.Vector;
import jwnl.data.POS;
import jwnl.data.Pointer;
import jwnl.data.PointerTarget;
import jwnl.data.PointerType;
import jwnl.data.Synset;
import jwnl.data.VerbFrame;

public class Word
implements PointerTarget {
    public static final int NONE = 0;
    public static final int PREDICATIVE = 1;
    public static final int ATTRIBUTIVE = 2;
    public static final int IMMEDIATE_POSTNOMINAL = 4;
    protected Synset synset;
    protected int index;
    protected String lemma;
    protected int flags;
    protected long verbFrameFlags;

    public Word(Synset synset, int index, String lemma, int flags) {
        this.synset = synset;
        this.index = index;
        this.lemma = lemma;
        this.flags = flags;
    }

    void setVerbFrameFlag(int fnum) {
        this.verbFrameFlags |= (long)(1 << fnum);
    }

    public boolean equals(Object object) {
        return object instanceof Word && ((Word)object).synset.equals(this.synset) && ((Word)object).index == this.index;
    }

    public int hashCode() {
        return this.synset.hashCode() ^ this.index;
    }

    public String toString() {
        return "[Word " + this.synset.offset + "@" + this.synset.pos + "(" + this.index + ")" + ": \"" + this.getLemma() + "\"]";
    }

    public Synset getSynset() {
        return this.synset;
    }

    public POS getPOS() {
        return this.synset.getPOS();
    }

    public int getIndex() {
        return this.index;
    }

    public String getLemma() {
        return this.lemma;
    }

    public long getFlags() {
        return this.flags;
    }

    public long getVerbFrameFlags() {
        return this.verbFrameFlags;
    }

    public String getDescription() {
        return this.lemma;
    }

    public String[] getVerbFrames() {
        return VerbFrame.getFrames(this.verbFrameFlags);
    }

    public String getLongDescription() {
        String description = this.getDescription();
        String gloss = this.synset.getGloss();
        if (gloss != null) {
            description = description + " -- (" + gloss + ")";
        }
        return description;
    }

    protected Pointer[] restrictPointers(Pointer[] source) {
        Vector<Pointer> vector = new Vector<Pointer>(source.length);
        int i = 0;
        while (i < source.length) {
            Pointer pointer = source[i];
            if (pointer.getSource() == this) {
                vector.addElement(pointer);
            }
            ++i;
        }
        Object[] result = new Pointer[vector.size()];
        vector.copyInto(result);
        return result;
    }

    public Pointer[] getPointers() {
        return this.restrictPointers(this.synset.getPointers());
    }

    public Pointer[] getPointers(PointerType type) {
        return this.restrictPointers(this.synset.getPointers(type));
    }

    public PointerTarget[] getTargets() {
        return Synset.collectTargets(this.getPointers());
    }

    public PointerTarget[] getTargets(PointerType type) {
        return Synset.collectTargets(this.getPointers(type));
    }
}

