/*
 * Decompiled with CFR 0.152.
 */
package jwnl.data;

import java.io.Serializable;
import jwnl.data.POS;
import jwnl.data.PointerTarget;
import jwnl.data.PointerType;
import jwnl.data.Synset;
import jwnl.data.Word;
import jwnl.dictionary.DictionaryDatabase;
import jwnl.util.TokenizerParser;

public class Pointer
implements Serializable {
    protected Synset synset;
    protected int index;
    protected PointerType pointerType;
    protected PointerTarget source;
    protected TargetIndex targetIndex;

    Pointer(Synset synset, int index) {
        this.synset = synset;
        this.index = index;
    }

    Pointer initializeFrom(TokenizerParser tokenizer) {
        this.pointerType = PointerType.parseKey(tokenizer.nextToken());
        long targetOffset = tokenizer.nextLong();
        POS pos = POS.lookup(tokenizer.nextToken());
        int linkIndices = tokenizer.nextHexInt();
        int sourceIndex = linkIndices / 256;
        int targetIndex = linkIndices & 0xFF;
        this.source = this.resolveTarget(this.synset, sourceIndex);
        this.targetIndex = new TargetIndex(pos, targetOffset, targetIndex);
        return this;
    }

    static Pointer parsePointer(Synset source, int index, TokenizerParser tokenizer) {
        return new Pointer(source, index).initializeFrom(tokenizer);
    }

    public boolean equals(Object object) {
        return object instanceof Pointer && ((Pointer)object).source.equals(this.source) && ((Pointer)object).index == this.index;
    }

    public int hashCode() {
        return this.source.hashCode() + this.index;
    }

    public String toString() {
        return "[Link #" + this.index + " from " + this.source + "]";
    }

    public PointerType getType() {
        return this.pointerType;
    }

    public boolean isLexical() {
        return this.source instanceof Word;
    }

    protected PointerTarget resolveTarget(Synset synset, int index) {
        if (index == 0) {
            return synset;
        }
        return synset.getWord(index - 1);
    }

    public PointerTarget getSource() {
        return this.source;
    }

    public PointerTarget getTarget() {
        DictionaryDatabase db = this.synset.getDictionary();
        Synset syn = db.getSynsetAt(this.targetIndex.pos, this.targetIndex.offset);
        return this.resolveTarget(syn, this.targetIndex.index);
    }

    public Synset getTargetSynset() {
        PointerTarget target = this.getTarget();
        Synset s = target instanceof Word ? ((Word)target).getSynset() : (Synset)target;
        return s;
    }

    public long getTargetOffset() {
        return this.targetIndex.offset;
    }

    protected class TargetIndex
    implements Serializable {
        POS pos;
        long offset;
        int index;

        TargetIndex(POS pos, long offset, int index) {
            this.pos = pos;
            this.offset = offset;
            this.index = index;
        }

        public String toString() {
            return this.pos + " " + this.offset + " " + this.index;
        }
    }
}

