/*
 * Decompiled with CFR 0.152.
 */
import jwnl.data.IndexWord;
import jwnl.data.POS;
import jwnl.data.list.pointer_target.PointerTargetList;
import jwnl.data.list.pointer_target.PointerTargetTree;
import jwnl.data.relationship.Relationship;
import jwnl.data.relationship.RelationshipList;
import jwnl.dictionary.DictionaryDatabase;
import jwnl.dictionary.hashtable.HashtableBackedDictionary;

public class Examples {
    private DictionaryDatabase db = new HashtableBackedDictionary();

    public static void main(String[] args) {
        Examples examples = new Examples();
    }

    public Examples() {
        System.out.println("Base form for \"running-away\": " + this.db.lookupBaseForm(POS.VERB, "running-away"));
        System.out.println();
        IndexWord accomplish = this.db.lookupIndexWord(POS.VERB, "accomplish");
        PointerTargetList hypernyms = accomplish.getDirectHypernyms(1);
        System.out.println("Direct hypernyms of \"accomplish\":");
        hypernyms.print();
        System.out.println();
        IndexWord dog = this.db.lookupIndexWord(POS.NOUN, "dog");
        PointerTargetTree hyponyms = dog.getHyponymTree(1);
        System.out.println("Hyponyms of \"dog\":");
        hyponyms.print();
        System.out.println();
        IndexWord cat = this.db.lookupWord(POS.NOUN, "cat");
        RelationshipList list = Relationship.findHypernymRelationships(dog, 1, cat, 1);
        Relationship[] r = list.toArray();
        System.out.println("Hypernym relationship between \"dog\" and \"cat\"");
        int i = 0;
        while (i < r.length) {
            r[i].print();
            ++i;
        }
        System.out.println();
        IndexWord funny = this.db.lookupWord(POS.ADJECTIVE, "funny");
        IndexWord droll = this.db.lookupWord(POS.ADJECTIVE, "droll");
        list = Relationship.findSynonymRelationships(funny, 1, droll, 1);
        r = list.toArray();
        System.out.println("Synonym relationship between \"funny\" and \"droll\"");
        int i2 = 0;
        while (i2 < r.length) {
            r[i2].print();
            ++i2;
        }
    }
}

