/*
 * Decompiled with CFR 0.152.
 */
package jwnl.dictionary.hashtable;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import jwnl.data.Exc;
import jwnl.data.IndexWord;
import jwnl.data.POS;
import jwnl.data.Synset;
import jwnl.dictionary.DictionaryDatabase;
import jwnl.dictionary.file.object.ObjectDictionaryCatalog;
import jwnl.dictionary.file.object.ObjectDictionaryCatalogSet;
import jwnl.dictionary.file.object.ObjectDictionaryFile;
import jwnl.util.SystemInfo;

public class HashtableBackedDictionary
extends DictionaryDatabase {
    protected static final int INDEX = 0;
    protected static final int DATA = 1;
    protected static final int EXCEPTION = 2;
    protected Hashtable indexTables = new Hashtable(4, 1.0f);
    protected Hashtable dataTables = new Hashtable(4, 1.0f);
    protected Hashtable exceptionTables = new Hashtable(4, 1.0f);

    public HashtableBackedDictionary() {
        this(HashtableBackedDictionary.getWNSearchDir());
    }

    public HashtableBackedDictionary(String searchDir) {
        this(new ObjectDictionaryCatalogSet(searchDir));
    }

    public HashtableBackedDictionary(ObjectDictionaryCatalogSet files) {
        super(false);
        files.open(this);
        POS[] cats = POS.getCats();
        int i = 0;
        while (i < cats.length) {
            POS pos = cats[i];
            ObjectDictionaryCatalog catalog = files.get(pos);
            System.out.println("Loading " + pos + " index...");
            this.putTable(pos, 0, this.loadDictFile(catalog.get(0)));
            System.out.println("Loading " + pos + " data...");
            this.putTable(pos, 1, this.loadDictFile(catalog.get(1)));
            System.out.println("Loading " + pos + " exception...");
            this.putTable(pos, 2, this.loadDictFile(catalog.get(2)));
            ++i;
        }
        files.close();
    }

    public static String getWNSearchDir() {
        String searchDir = System.getProperty("WNSEARCHDIR");
        if (searchDir == null && (searchDir = SystemInfo.getWNSearchDir()) == null) {
            searchDir = "";
        }
        return searchDir + SystemInfo.getFileSeparator() + "serialized";
    }

    protected Hashtable loadDictFile(ObjectDictionaryFile file) {
        return (Hashtable)file.readObject();
    }

    public IndexWord lookupIndexWord(POS pos, String lemma) {
        return (IndexWord)this.getIndexTable(pos).get(lemma);
    }

    public Enumeration searchIndexWords(POS pos, final String substring) {
        final Enumeration enumeration = this.indexWords(pos);
        String temp = null;
        while (enumeration.hasMoreElements()) {
            IndexWord word = (IndexWord)enumeration.nextElement();
            String w = word.getLemma();
            if (w.indexOf(substring) == -1) continue;
            temp = w;
            break;
        }
        final String startWord = temp;
        return new Enumeration(){
            private String nextWord;
            private Enumeration e;
            {
                this.nextWord = startWord;
                this.e = enumeration;
            }

            public boolean hasMoreElements() {
                return this.nextWord != null;
            }

            public Object nextElement() {
                if (this.hasMoreElements()) {
                    String thisWord = this.nextWord;
                    this.nextWord = null;
                    while (this.e.hasMoreElements()) {
                        IndexWord word = (IndexWord)enumeration.nextElement();
                        String w = word.getLemma();
                        if (w.indexOf(substring) == -1) continue;
                        this.nextWord = w;
                        break;
                    }
                    return thisWord;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Enumeration indexWords(POS pos) {
        return this.getIndexTable(pos).elements();
    }

    public Enumeration synsets(POS pos) {
        return this.getDataTable(pos).elements();
    }

    public Enumeration exceptions(POS pos) {
        return this.getExceptionTable(pos).elements();
    }

    public Synset getSynsetAt(POS pos, long offset, String line) {
        return this.getSynsetAt(pos, offset);
    }

    public Synset getSynsetAt(POS pos, long offset) {
        return (Synset)this.getDataTable(pos).get(new Long(offset));
    }

    public Exc lookupExceptions(POS pos, String derivation) {
        return (Exc)this.getExceptionTable(pos).get(derivation);
    }

    public void putTable(POS pos, int fileType, Hashtable table) {
        this.getTypeTable(fileType).put(pos, table);
    }

    public void putTables(int fileType, Hashtable table) {
        switch (fileType) {
            case 0: {
                this.indexTables = table;
            }
            case 1: {
                this.dataTables = table;
            }
            case 2: {
                this.exceptionTables = table;
            }
        }
    }

    public Hashtable getTypeTable(int fileType) {
        switch (fileType) {
            case 0: {
                return this.indexTables;
            }
            case 1: {
                return this.dataTables;
            }
            case 2: {
                return this.exceptionTables;
            }
        }
        return null;
    }

    protected Hashtable getIndexTable(POS pos) {
        return (Hashtable)this.indexTables.get(pos);
    }

    protected Hashtable getDataTable(POS pos) {
        return (Hashtable)this.dataTables.get(pos);
    }

    protected Hashtable getExceptionTable(POS pos) {
        return (Hashtable)this.exceptionTables.get(pos);
    }

    public void close() {
    }
}

