/*
 * Decompiled with CFR 0.152.
 */
package jwnl.data.list;

import java.util.ListIterator;
import jwnl.data.list.Node;
import jwnl.data.list.NodePrinter;

public class NodeListItr {
    protected ListIterator itr;
    protected NodePrinter defaultPrinter = new NodePrinter(){

        public void print(Node node, int indent) {
            System.out.println(node);
        }
    };
    protected int defaultIndent = 0;

    public NodeListItr(ListIterator itr) {
        this.itr = itr;
    }

    protected Node nextNode() {
        return (Node)this.itr.next();
    }

    protected Node previousNode() {
        return (Node)this.itr.previous();
    }

    public void add(Node node) {
        this.itr.add(node);
    }

    public boolean hasNext() {
        return this.itr.hasNext();
    }

    public boolean hasPrevious() {
        return this.itr.hasPrevious();
    }

    public int nextIndex() {
        return this.itr.nextIndex();
    }

    public int currentIndex() {
        return this.nextIndex() - 1;
    }

    public int previousIndex() {
        return this.itr.previousIndex();
    }

    public void remove() {
        this.itr.remove();
    }

    public void set(Node node) {
        this.itr.set(node);
    }

    public void setPrinter(NodePrinter printer) {
        this.defaultPrinter = printer;
    }

    public void setIndent(int indent) {
        this.defaultIndent = indent;
    }

    public int moveTo(int index) {
        block3: {
            block2: {
                if (this.currentIndex() >= index) break block2;
                while (this.currentIndex() < index && this.hasNext()) {
                    this.nextNode();
                }
                break block3;
            }
            if (this.currentIndex() <= index) break block3;
            while (this.currentIndex() > index && this.hasPrevious()) {
                this.previousNode();
            }
        }
        return this.currentIndex();
    }

    public void moveToBeginning() {
        this.moveTo(-1);
    }

    public void moveToFirst() {
        this.moveTo(0);
    }

    public void moveToLast() {
        this.moveTo(Integer.MAX_VALUE);
    }

    public void print() {
        this.print(this.defaultPrinter);
    }

    public void print(NodePrinter np) {
        this.print(np, this.defaultIndent);
    }

    public void print(int indent) {
        this.print(this.defaultPrinter, indent);
    }

    public void print(NodePrinter np, int indent) {
        int curNode = this.currentIndex();
        this.moveToBeginning();
        while (this.hasNext()) {
            np.print(this.nextNode(), indent);
        }
        this.moveTo(curNode);
    }
}

