/*
 * Decompiled with CFR 0.152.
 */
package jwnl.data;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import jwnl.data.IndexWord;
import jwnl.data.POS;

public class IndexWordSet {
    protected Hashtable indexWords = new Hashtable(4, 1.0f);
    protected String lemma;

    public IndexWordSet(String lemma) {
        this.lemma = lemma;
    }

    public void add(IndexWord word) {
        this.indexWords.put(word.getPOS(), word);
    }

    public void remove(POS p) {
        this.indexWords.remove(p);
    }

    public int size() {
        return this.indexWords.size();
    }

    public IndexWord getIndexWord(POS p) {
        return (IndexWord)this.indexWords.get(p);
    }

    public IndexWord[] getIndexWordArray() {
        IndexWord[] words = new IndexWord[this.indexWords.size()];
        return this.indexWords.values().toArray(words);
    }

    public Collection getIndexWordCollection() {
        return this.indexWords.values();
    }

    public POS[] getValidPOSArray() {
        POS[] pos = new POS[this.indexWords.size()];
        return this.indexWords.keySet().toArray(pos);
    }

    public Set getValidPOSSet() {
        return this.indexWords.keySet();
    }

    public Enumeration getValidPOSEnum() {
        return this.indexWords.keys();
    }

    public boolean isValidPOS(POS pos) {
        return this.indexWords.containsKey(pos);
    }

    public int getSenseCount(POS pos) {
        return this.getIndexWord(pos).getSenseCount();
    }

    public String toString() {
        Enumeration e = this.getValidPOSEnum();
        String s = "";
        while (e.hasMoreElements()) {
            POS p = (POS)e.nextElement();
            s = s + p.getLabel() + ": " + this.getIndexWord(p).toString() + "\n";
        }
        if (s != "") {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public String getLemma() {
        return this.lemma;
    }

    public boolean equals(Object object) {
        return object instanceof IndexWordSet && this.lemma.equals(((IndexWordSet)object).getLemma());
    }
}

