/*****************************
File:       fail.c
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

/* Distributed under a BSD type license. See the netwrap COPYRIGHT file */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <windows.h>

#include "H3DNetworkingUtils/fail.h"

void Fail (char * message)
{
  fprintf(stderr, "%s\n", message);
  exit(1);
}

void FailNull (void * ptr, char * message)
{
  char msg[256];
  
  if (ptr == NULL) {
    sprintf(msg, "NULL pointer: %s", message);
    Fail(msg);
  }
}

void FailErr (int code, char * message)
{
  char msg[256];
  int  errno;

  if (code < 0) {
    errno = GetLastError();
    if (errno == 0)
      sprintf(msg, "Error code %d: %s", code, message);
    else
      sprintf(msg, "Error code %d: %s", errno, message);
    Fail(msg);
  }
}

void SetErrNo (int code)
{
  SetLastError(code);
}

void FailStatus (int code, char * message)
{
  char msg[256];

  if (code != 0) {
    sprintf(msg, "Error code %d: %s", code, message);
    Fail(msg);
  }
}
