/*****************************
File:      StickySlotDynamic.cpp
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

#include "H3DNetworkingUtils/StickySlotDynamic.h"

using namespace H3D;
using namespace H3DUtil;
using namespace H3DNetworkingUtils;

// -----------------------------------------------------------------------------
H3DNodeDatabase StickySlotDynamic::database(
  "StickySlotDynamic", 
  &(newInstance<StickySlotDynamic>),
  typeid(StickySlotDynamic),
  &StickyDynamic::database);

namespace StickySlotDynamicInternals {
  FIELDDB_ELEMENT( StickySlotDynamic, start, INPUT_OUTPUT );
  FIELDDB_ELEMENT( StickySlotDynamic, end, INPUT_OUTPUT );
}

// -----------------------------------------------------------------------------
StickySlotDynamic::StickySlotDynamic(Inst<SFBool> _locked,  
                             Inst<SFFloat> _startForce,
                             Inst<SFFloat> _slideForce,
                             Inst<SFFloat> _friction,
                             Inst<SFTime> _stopDelay,
                             Inst<H3D::SFFloat> _start,
					              Inst<H3D::SFFloat> _end):
StickyDynamic(_locked, _startForce, _slideForce, _friction, _stopDelay),
start(_start),
end(_end) {

   type_name = "StickySlotDynamic";
   database.initFields( this );

   start->setValue(0.0f);
   end->setValue(1.0f);
   freedom->setValue(Vec3f(1, 0, 0));
   angularFreedom->setValue(Vec3f(0, 0, 0));
}

// -----------------------------------------------------------------------------
void StickySlotDynamic::traverseSG(TraverseInfo & ti){
   // let the parent class move the dynamic   
   StickyDynamic::traverseSG(ti);
   Vec3f pos = position->getValue();
   if (pos.x < start->getValue()) {
      position->setValue(Vec3f(start->getValue(), 0, 0));
      stopIt();
   } else if (pos.x > end->getValue()) {
      position->setValue(Vec3f(end->getValue(), 0, 0));
      stopIt();
   }

}

