/*****************************
File:      SlaveDynamic.cpp
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/

#include "H3DNetworkingUtils/SlaveDynamic.h"

using namespace H3D;
using namespace H3DNetworkingUtils;
/// Note that this node is redundant and is included for backwards compatibility.
/// It is just a GrabableDynamic with slaveMode set to TRUE.

// -------------------------------------------------
const H3DNodeDatabase SlaveDynamic::H3DNodeDatabase(
  "SlaveDynamic", 
  &(newInstance<SlaveDynamic>),
  typeid(SlaveDynamic),
  &GrabableDynamic::database);


// -------------------------------------------------
SlaveDynamic::SlaveDynamic() {

   type_name = "SlaveDynamic";   
   database.initFields( this );

   slaveMode->setValue(true);   
}


