#include "H3DNetworkingUtils/RemoteVecToAttractor.h"
#include "H3DNetworkingUtils/RemoteConnection.h"

using namespace H3D;
using namespace H3DNetworkingUtils;

// ----------------------------------------------------------------------------
H3DNodeDatabase RemoteVecToAttractor::database(   
  "RemoteVecToAttractor", 
  &(newInstance<RemoteVecToAttractor>),
  typeid(RemoteVecToAttractor),
  &RemoteSFVec3f::database);

namespace RemoteVecToAttractorInternals {   
  FIELDDB_ELEMENT( RemoteSFVec3f, toBeSent, INPUT_ONLY );
  FIELDDB_ELEMENT( RemoteVecToAttractor, attractor, INPUT_OUTPUT );
}

// ----------------------------------------------------------------------------
RemoteVecToAttractor::RemoteVecToAttractor(Inst<SFRealtimeAttractor>  _attractor) :
attractor (_attractor)  {

  type_name = "RemoteVecToAttractor";
  database.initFields( this );

  attractor->setOwner(this);
}

// ----------------------------------------------------------------------------
void RemoteVecToAttractor::initialize() {
  attrP = attractor->getValue();
  RemoteSFVec3f::initialize();
}

// ----------------------------------------------------------------------------
void RemoteVecToAttractor::readValue() {
  Vec3f val;
  val.x = conP->readH3DFloat();
  val.y = conP->readH3DFloat();
  val.z = conP->readH3DFloat();
  if (attrP ) {
    attrP->realtimePoint->setValue(val);
  }
}

