/*****************************
File:       RemoteTCPClient.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/RemoteTCPClient.h"
#include "H3DNetworkingUtils/sockwrap.h"
#include "H3DNetworkingUtils/fail.h"
#include "H3DNetworkingUtils/RemoteSync.h"

using namespace H3D;
using namespace H3DNetworkingUtils;

H3DNodeDatabase RemoteTCPClient::database(   
  "RemoteTCPClient", 
  &(newInstance<RemoteTCPClient>),
  typeid(RemoteTCPClient),
  &RemoteClient::database);


// ----------------------------------------------------------------------------
RemoteTCPClient::RemoteTCPClient() :
RemoteClient      ("TCP") {

  type_name = "RemoteTCPClient";
  database.initFields( this );

}

// ----------------------------------------------------------------------------
RemoteTCPClient::~RemoteTCPClient() {
  setShuttingDown(true);
  while (receiveLoopRunning() || sendLoopRunning()) {
     setShuttingDown(true); // Sometimes you need to keep doing it
     Sleep(50);
  }
}

// ----------------------------------------------------------------------------
void RemoteTCPClient::startReceiving() {
  // Called in graphics thread.

  if (!receive_loop_threadP) {
    receive_loop_threadP = new Thread((ThreadFunction)clientReceivingLoopTH, this);
  }
}

// ----------------------------------------------------------------------------
void RemoteTCPClient::clientReceiveLoop() {
  // Called in receiving thread.

  setReceiveLoopRunning(true);
  ///while (true) {
  while (!isShuttingDown()) {
    connected_sem.wait(); // Wait for graphics thread to say we are connected.
    receiveLoop();
  }
  setReceiveLoopRunning(false);
}

// ----------------------------------------------------------------------------
void RemoteTCPClient::restartClient() {
  // Called in graphics thread.

  char tmp [80];
  if (sockP) {
    sock_lock.lock();
    delete sockP;
    sockP = 0;
    sock_lock.unlock();
  }

  sockP = new TCPSock(0);
  ///  setSendTimeout(new_sockP, 100);
  int code = sockP->connect(&remote_end);
  if (code < 0) {
    sprintf(tmp, "Cannot connect to TCP server on %s\n", addr);
    showError(tmp);
    sock_lock.lock();
    delete sockP;
    sockP = 0;
    sock_lock.unlock();
  }
  else {
    sprintf(tmp, "TCP connection to server %s\n", addr);
    clearError();
    showInfo(tmp);
  }

  if (sockP) {
    requestOpenComms();
    startReceiving();
    restart_requested = false;
  }
}

