/*****************************
File:       RemoteServer.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/RemoteServer.h"
#include <stdio.h>
#include "H3DNetworkingUtils/sockwrap.h"
#include "H3DNetworkingUtils/fail.h"
#include "H3DNetworkingUtils/RemoteSync.h"

using namespace H3D;
using namespace H3DNetworkingUtils;

// ----------------------------------------------------------------------------
H3DNodeDatabase RemoteServer::database(   
  "RemoteServer", 
  NULL,
  typeid(RemoteServer),
  &RemoteConnection::database);

namespace RemoteServerInternals {   
  FIELDDB_ELEMENT( RemoteServer, listeningPort, INPUT_OUTPUT );
  FIELDDB_ELEMENT( RemoteServer, open, INPUT_OUTPUT );
}

// ----------------------------------------------------------------------------
RemoteServer::RemoteServer(Inst<H3D::SFInt32> _listeningPort,
                           Inst<OpenHandler>  _open) :
listeningPort (_listeningPort),
open           (_open) {

  type_name = "RemoteServer";
  database.initFields( this );

  open->setOwner(this);
  open->setValue(false);
  listeningPort->setValue(9876);
}

// ----------------------------------------------------------------------------
RemoteServer::~RemoteServer() {
  ///setShuttingDown(true);
  ///while (listeningLoopRunning()) {
  ///   Sleep(50);
  ///}
}

// ----------------------------------------------------------------------------
void RemoteServer::initialize() {
  RemoteConnection::initialize();
  if (open->getValue()) {
    startServer(listeningPort->getValue());
  }
  if (remoteSync->getValue()) {
    open->route( remoteSync->getValue()->timer->enabled );
  }
}

// ----------------------------------------------------------------------------
void RemoteServer::OpenHandler::update() {
   H3D::SFBool * val = static_cast<H3D::SFBool *>(event.ptr);
   RemoteServer * serverP = static_cast<RemoteServer *>(getOwner());
   if (val->getValue() != value) {
     if (val->getValue()) {
       serverP->startServer(serverP->listeningPort->getValue());
     } else {
       serverP->requestClose();
     }
   }
}

// ----------------------------------------------------------------------------
void RemoteServer::OpenHandler::setValue( bool const & val, int id ) {
   RemoteServer * serverP = static_cast<RemoteServer *>(getOwner());
   if (val != value) {
     if (val) {
       serverP->startServer(serverP->listeningPort->getValue());
     } else {
       serverP->requestClose();
     }
   }
}

// ----------------------------------------------------------------------------
bool RemoteServer::doClosedActions() {
  // Called in graphics thread.
  // This gets called repeatedly while connection is closed.
  // In the case of the server, it does nothing.
  return false;
}


