/*****************************
File:       RemoteSFVec3fPair.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "RemoteSFVec3fPair.h"
#include "RemoteConnection.h"

#ifdef _WIN32
#include "RemoteSF.cpp"
#endif

using namespace H3D;

// ----------------------------------------------------------------------------
H3DNodeDatabase RemoteSFVec3fPair::database(
"RemoteSFVec3fPair",
typeid(RemoteSFVec3fPair),
Create<RemoteSFVec3fPair>::create,
eventIn(  "toBeSent", &RemoteSF<pair<Vec3f, Vec3f> >::to_be_sent ) +
eventOut( "received", &RemoteSF<pair<Vec3f, Vec3f> >::received   ),
&RemoteField::database
);
// toBeSent and received are really fields of the parent class but because of
// a bug in Win32 template instantiation they must be included here instead.

// ----------------------------------------------------------------------------
RemoteSFVec3fPair::RemoteSFVec3fPair()  {
  received->initialiseValue( make_pair(Vec3f(0.0,0.0,0.0), Vec3f(0.0,0.0,0.0)) );
}

// ----------------------------------------------------------------------------
void RemoteSFVec3fPair::writeValue (pair<Vec3f, Vec3f> const & val) {
  writeMgFloat(val.first.x);
  writeMgFloat(val.first.y);
  writeMgFloat(val.first.z);
  writeMgFloat(val.second.x);
  writeMgFloat(val.second.y);
  writeMgFloat(val.second.z);
}

// ----------------------------------------------------------------------------
void RemoteSFVec3fPair::readValue() {
  Vec3f val1;
  val1.x = conP->readMgFloat();
  if (!conP->closeRequested()) {
    val1.y = conP->readMgFloat();
  }
  if (!conP->closeRequested()) {
    val1.z = conP->readMgFloat();
  }
  Vec3f val2;
  val2.x = conP->readMgFloat();
  if (!conP->closeRequested()) {
    val2.y = conP->readMgFloat();
  }
  if (!conP->closeRequested()) {
    val2.z = conP->readMgFloat();
  }

  if (!conP->closeRequested()) {
    received->setValue(make_pair(val1, val2));
  }
}

// ----------------------------------------------------------------------------
void RemoteSFVec3fPair::setValue(pair<Vec3f, Vec3f> const & val) {
  received->setValue(val);
}
