/*****************************
File:       RemoteSFVec3f.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/RemoteSFVec3f.h"
#include "H3DNetworkingUtils/RemoteConnection.h"

#ifdef _WIN32
#include "RemoteSF.cpp"
#endif

using namespace H3D;
using namespace H3DNetworkingUtils;

// ----------------------------------------------------------------------------
H3DNodeDatabase RemoteSFVec3f::database(   
  "RemoteSFVec3f", 
  &(newInstance<RemoteSFVec3f>),
  typeid(RemoteSFVec3f),
  &RemoteField::database);

namespace RemoteSFVec3fInternals {   
  FIELDDB_ELEMENT( RemoteSFVec3f, toBeSent, INPUT_ONLY );
  FIELDDB_ELEMENT( RemoteSFVec3f, received, OUTPUT_ONLY );
}
// toBeSent and received are really fields of the parent class but because of
// a bug in Win32 template instantiation they must be included here instead.

// ----------------------------------------------------------------------------
RemoteSFVec3f::RemoteSFVec3f() :
RemoteSF<SFVec3f>(H3D::X3DTypes::SFVEC3F) {

  type_name = "RemoteSFVec3f";
  database.initFields( this );

  received->initialiseValue( Vec3f(0.0,0.0,0.0));
}

// ----------------------------------------------------------------------------
void RemoteSFVec3f::writeValue (Vec3f const & val) {

  writeH3DFloat(val.x);
  writeH3DFloat(val.y);
  writeH3DFloat(val.z);
}

// ----------------------------------------------------------------------------
void RemoteSFVec3f::readValue() {
  Vec3f val;
  int fld_id = fieldId->getValue();
  val.x = conP->readH3DFloat();
  if (!conP->closeRequested()) {
    val.y = conP->readH3DFloat();
  }
  if (!conP->closeRequested()) {
    val.z = conP->readH3DFloat();
  }

  if (!conP->closeRequested()) {
    received->setValue(val, id);
  }
  ///cout << "readvalue " << val.x << endl;
}

// ----------------------------------------------------------------------------
void RemoteSFVec3f::setValue(Vec3f const & val) {
  received->setValue(val, id);
}
