/*****************************
File:       RemoteSFVec2f.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/RemoteSFVec2f.h"
#include "H3DNetworkingUtils/RemoteConnection.h"

#ifdef _WIN32
#include "RemoteSF.cpp"
#endif

using namespace H3D;
using namespace H3DNetworkingUtils;

// ----------------------------------------------------------------------------
H3DNodeDatabase RemoteSFVec2f::database(   
  "RemoteSFVec2f", 
  &(newInstance<RemoteSFVec2f>),
  typeid(RemoteSFVec2f),
  &RemoteField::database);

namespace RemoteSFVec2fInternals {   
  FIELDDB_ELEMENT( RemoteSFVec2f, toBeSent, INPUT_ONLY );
  FIELDDB_ELEMENT( RemoteSFVec2f, received, OUTPUT_ONLY );
}
// toBeSent and received are really fields of the parent class but because of
// a bug in Win32 template instantiation they must be included here instead.

// ----------------------------------------------------------------------------
RemoteSFVec2f::RemoteSFVec2f() :
RemoteSF<SFVec2f>(H3D::X3DTypes::SFVEC2F) {

  type_name = "RemoteSFVec2f";
  database.initFields( this );

  received->initialiseValue(Vec2f(0.0,0.0));
}

// ----------------------------------------------------------------------------
void RemoteSFVec2f::writeValue( Vec2f const &val) {
  writeH3DFloat( val.x);
  writeH3DFloat( val.y);
}

// ----------------------------------------------------------------------------
void RemoteSFVec2f::readValue() {
  Vec2f val;
  val[0] = conP->readH3DFloat();
  if ( !conP->closeRequested() ) {
    val[1] = conP->readH3DFloat();
  }
  if ( !conP->closeRequested()) {
    received->setValue( val, id );
  }
}

// ----------------------------------------------------------------------------
void RemoteSFVec2f::setValue( Vec2f const &val ) {
  received->setValue( val, id );
}
