/*****************************
File:       RemoteSFTime.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/RemoteSFTime.h"
#include "H3DNetworkingUtils/RemoteConnection.h"
#include "H3DNetworkingUtils/BufferedSField.h"

#ifdef _WIN32
#include "RemoteSF.cpp"
#endif

using namespace H3D;
using namespace H3DNetworkingUtils;

// ----------------------------------------------------------------------------
H3DNodeDatabase RemoteSFTime::database(   
  "RemoteSFTime", 
  &(newInstance<RemoteSFTime>),
  typeid(RemoteSFTime),
  &RemoteField::database);

namespace RemoteSFTimeInternals {   
  ///FIELDDB_ELEMENT( RemoteSFTime, toBeSent, INPUT_ONLY );
  FIELDDB_ELEMENT_EX( RemoteSFTime, send_t, INPUT_OUTPUT, toBeSent ); // Yes it needs to be I/O so that toBeSent can get values from it
  FIELDDB_ELEMENT_EX( RemoteSFTime, received_t, OUTPUT_ONLY, received );
}
// toBeSent and received are really fields of the parent class but because of
// a bug in Win32 template instantiation they must be included here instead.


// ----------------------------------------------------------------------------
RemoteSFTime::RemoteSFTime(Inst<SFTime> _send_t, Inst<SFTimeTransfer> _received_t) :
send_t (_send_t),
received_t (_received_t),
RemoteSF<SFDouble>(H3D::X3DTypes::SFDOUBLE) {

  type_name = "RemoteSFTime";
  database.initFields( this );

  received->initialiseValue(0);
  received->route(received_t, id);
  send_t->route(toBeSent, id);
}

// ----------------------------------------------------------------------------
void RemoteSFTime::readValue() {
  H3DTime val = readDouble();
  if (!conP->closeRequested()) {
    received->setValue(val, id);
  }
}

// ----------------------------------------------------------------------------
void RemoteSFTime::SFTimeTransfer::update() {
   H3DDouble d = static_cast<SFDouble*>(event.ptr)->getValue();
   H3DTime t(d);
   value = t;
}