/*****************************
File:       RemoteSFString.CPP
Language:   C++ (header)
Project:    H3DNetworkingUtils
The contents of this file are subject to the Mozilla Public License
Version 1.1 (the "License"); you may not use this file except in
compliance with the License. You may obtain a copy of the License at
http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS"
basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
License for the specific language governing rights and limitations
under the License.

The Original Code is H3DNetworkingUtils v1.0.

The Initial Developer of the Original Code is CSIRO.
Portions created by the Initial Developer are Copyright (C) 1009 CSIRO. All Rights Reserved.
Contributor(s):
    Chris Gunn  <Chris.Gunn@csiro.au> <ChrisJGunn@gmail.com>
***************************/
#include "H3DNetworkingUtils/RemoteSFString.h"
#include "H3DNetworkingUtils/RemoteConnection.h"

#ifdef _WIN32
#include "RemoteSF.cpp"
#endif

using namespace H3D;
using namespace H3DNetworkingUtils;
using namespace std;

H3DNodeDatabase RemoteSFString::database(   
   "RemoteSFString", 
   &(newInstance<RemoteSFString>),
   typeid(RemoteSFString),
   &RemoteField::database);

namespace RemoteSFStringInternals {   
  FIELDDB_ELEMENT( RemoteSFString, toBeSent, INPUT_ONLY );
  FIELDDB_ELEMENT( RemoteSFString, received, OUTPUT_ONLY );
}
// toBeSent and received are really fields of the parent class but because of
// a bug in Win32 template instantiation they must be included here instead.


// ----------------------------------------------------------------------------
RemoteSFString::RemoteSFString() :
RemoteSF<SFString>(H3D::X3DTypes::SFSTRING) {

  type_name = "RemoteSFString";
  database.initFields( this );

  received->initialiseValue( string("") );
}

// ----------------------------------------------------------------------------
void RemoteSFString::writeValue (string const & val) {
  writeString(val);
}

// ----------------------------------------------------------------------------
void RemoteSFString::readValue() {
  string val;
  val = readString();
  if (!conP->closeRequested()) {
    received->setValue(val, id);
  }
}

// ----------------------------------------------------------------------------
void RemoteSFString::setValue(string const & val) {
  received->setValue(val);
}
